/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.GetBeamDataRequest;
import com.nokia.em.bts.coreasset.message.GetBeamDataResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEFrequencyData;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEGetBeamDataScenarioListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class RAEGetBeamDataScenario
implements Scenario {
    private BTSConnection myConnection;
    private RAEGetBeamDataScenarioListener myGetBeamDataListener;
    private int myUnitId;
    private RAEFrequencyData myFrequency;
    private Logger myLogger;
    private boolean myRunning = false;
    private Object myLock = new Object();

    public RAEGetBeamDataScenario(BTSConnection connection, RAEGetBeamDataScenarioListener listener, int id, RAEFrequencyData frequency) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myGetBeamDataListener = listener;
        this.myUnitId = id;
        this.myFrequency = frequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myRunning) {
                throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
            }
            this.myRunning = true;
        }
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber = -1;

            protected Object construct() {
                this.seqNumber = RAEGetBeamDataScenario.this.myConnection.createScenario();
                return RAEGetBeamDataScenario.this.runScenario(this.seqNumber);
            }

            protected void finished() {
                RAEGetBeamDataScenario.this.myConnection.deleteScenario(this.seqNumber);
                RAEGetBeamDataScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    public Object runScenario(int seqNumber) {
        if (CoreAsset.isSnapshotOpening()) {
            this.openSnapshot();
            return true;
        }
        GetBeamDataRequest getBeamDataRequest = new GetBeamDataRequest(seqNumber, this.myUnitId, this.myFrequency);
        this.myConnection.sendToBTS((BTSMessage)getBeamDataRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(seqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                response = this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof GetBeamDataResponse) {
                    GetBeamDataResponse getBeamDataResponse = (GetBeamDataResponse)response;
                    int cause = getBeamDataResponse.getCause();
                    if (cause == 36 || cause == -1) {
                        this.myLogger.debug((Object)"Get beam data succeeded.");
                        this.myGetBeamDataListener.getBeamDataSucceeded(getBeamDataResponse);
                        return true;
                    }
                    this.myLogger.debug((Object)("Get beam data failed. Reason: " + cause));
                    this.myGetBeamDataListener.getBeamDataFailed(cause, getBeamDataResponse.getOperationFeedback());
                    return false;
                }
                this.myGetBeamDataListener.getBeamDataFailed(28);
                this.myLogger.error((Object)("Wrong reply received from BTS. GetBeamDataResponse or Ack expected, " + response.getClass() + " received."));
                return false;
            }
            this.myLogger.debug((Object)"NACK received");
            this.myGetBeamDataListener.startGetBeamDataFailed(ackResponse.getNackReason());
            return false;
        }
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"get beam data failed, connection lost.");
            this.myGetBeamDataListener.getBeamDataFailed(68);
            return false;
        }
        if (response == null) {
            this.myLogger.debug((Object)"get beam data failed, connection lost.");
            return false;
        }
        this.myLogger.debug((Object)"get beam data failed, invalid message.");
        this.myGetBeamDataListener.getBeamDataFailed(28);
        return false;
    }

    private void openSnapshot() {
        this.myLogger.debug((Object)"Snapshot open not supported.");
        this.myGetBeamDataListener.getBeamDataFailed(85, null);
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"This scenario cannot be aborted.");
        return true;
    }
}

