/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.GetDirectionDataRequest;
import com.nokia.em.bts.coreasset.message.GetDirectionDataResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEBeamData;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEFrequencyData;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEGetDirectionDataScenarioListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class RAEGetDirectionDataScenario
implements Scenario {
    private BTSConnection myConnection;
    private RAEGetDirectionDataScenarioListener myGetDirectionDataListener;
    private int myUnitId;
    private RAEFrequencyData myFrequency;
    private RAEBeamData myBeam;
    private Logger myLogger;
    private boolean myRunning = false;
    private Object myLock = new Object();

    public RAEGetDirectionDataScenario(BTSConnection connection, RAEGetDirectionDataScenarioListener listener, int id, RAEFrequencyData frequency, RAEBeamData beam) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myGetDirectionDataListener = listener;
        this.myUnitId = id;
        this.myFrequency = frequency;
        this.myBeam = beam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myRunning) {
                throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
            }
            this.myRunning = true;
        }
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber = -1;

            protected Object construct() {
                this.seqNumber = RAEGetDirectionDataScenario.this.myConnection.createScenario();
                return RAEGetDirectionDataScenario.this.runScenario(this.seqNumber);
            }

            protected void finished() {
                RAEGetDirectionDataScenario.this.myConnection.deleteScenario(this.seqNumber);
                RAEGetDirectionDataScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    public Object runScenario(int seqNumber) {
        if (CoreAsset.isSnapshotOpening()) {
            this.openSnapshot();
            return true;
        }
        GetDirectionDataRequest getDirectionDataRequest = new GetDirectionDataRequest(seqNumber, this.myUnitId, this.myFrequency, this.myBeam);
        this.myConnection.sendToBTS((BTSMessage)getDirectionDataRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(seqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                response = this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof GetDirectionDataResponse) {
                    GetDirectionDataResponse getDirectionDataResponse = (GetDirectionDataResponse)response;
                    int cause = getDirectionDataResponse.getCause();
                    if (cause == 36 || cause == -1) {
                        this.myLogger.debug((Object)"Get direction data succeeded.");
                        this.myGetDirectionDataListener.getDirectionDataSucceeded(getDirectionDataResponse);
                        return true;
                    }
                    this.myLogger.debug((Object)("Get direction data failed. Reason: " + cause));
                    this.myGetDirectionDataListener.getDirectionDataFailed(cause, getDirectionDataResponse.getOperationFeedback());
                    return false;
                }
                this.myGetDirectionDataListener.getDirectionDataFailed(28);
                this.myLogger.error((Object)("Wrong reply received from BTS. GetDirectionDataResponse or Ack expected, " + response.getClass() + " received."));
                return false;
            }
            this.myLogger.debug((Object)"NACK received");
            this.myGetDirectionDataListener.startGetDirectionDataFailed(ackResponse.getNackReason());
            return false;
        }
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"get Direction data failed, connection lost.");
            this.myGetDirectionDataListener.getDirectionDataFailed(68);
            return false;
        }
        if (response == null) {
            this.myLogger.debug((Object)"get Direction data failed, connection lost.");
            return false;
        }
        this.myLogger.debug((Object)"get Direction data failed, invalid message.");
        this.myGetDirectionDataListener.getDirectionDataFailed(28);
        return false;
    }

    private void openSnapshot() {
        this.myLogger.debug((Object)"Snapshot open not supported.");
        this.myGetDirectionDataListener.getDirectionDataFailed(85, null);
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"This scenario cannot be aborted.");
        return true;
    }
}

