/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.GetWeightDataRequest;
import com.nokia.em.bts.coreasset.message.GetWeightDataResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEFrequencyData;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEGetWeightDataScenarioListener;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEWeightBeamData;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class RAEGetWeightDataScenario
implements Scenario {
    private BTSConnection myConnection;
    private RAEGetWeightDataScenarioListener myGetWeightDataListener;
    private int myUnitId;
    private RAEFrequencyData myFrequency;
    private RAEWeightBeamData myVerticalBeam;
    private RAEWeightBeamData myHorizontalBeam;
    private Logger myLogger;
    private boolean myRunning = false;
    private Object myLock = new Object();

    public RAEGetWeightDataScenario(BTSConnection connection, RAEGetWeightDataScenarioListener listener, int id, RAEFrequencyData frequency, RAEWeightBeamData verticalBeam, RAEWeightBeamData horizontalBeam) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myGetWeightDataListener = listener;
        this.myUnitId = id;
        this.myFrequency = frequency;
        this.myVerticalBeam = verticalBeam;
        this.myHorizontalBeam = horizontalBeam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myRunning) {
                throw new IllegalStateException("Cannot execute Scenario. Scenario already started.");
            }
            this.myRunning = true;
        }
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber = -1;

            protected Object construct() {
                this.seqNumber = RAEGetWeightDataScenario.this.myConnection.createScenario();
                return RAEGetWeightDataScenario.this.runScenario(this.seqNumber);
            }

            protected void finished() {
                RAEGetWeightDataScenario.this.myConnection.deleteScenario(this.seqNumber);
                RAEGetWeightDataScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    public Object runScenario(int seqNumber) {
        if (CoreAsset.isSnapshotOpening()) {
            this.openSnapshot();
            return true;
        }
        GetWeightDataRequest getWeightDataRequest = new GetWeightDataRequest(seqNumber, this.myUnitId, this.myFrequency, this.myVerticalBeam, this.myHorizontalBeam);
        this.myConnection.sendToBTS((BTSMessage)getWeightDataRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(seqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                response = this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof GetWeightDataResponse) {
                    GetWeightDataResponse getWeightDataResponse = (GetWeightDataResponse)response;
                    int cause = getWeightDataResponse.getCause();
                    if (cause == 36 || cause == -1) {
                        this.myLogger.debug((Object)"Get weight data succeeded.");
                        this.myGetWeightDataListener.getWeightDataSucceeded(getWeightDataResponse);
                        return true;
                    }
                    this.myLogger.debug((Object)("Get weight data failed. Reason: " + cause));
                    this.myGetWeightDataListener.getWeightDataFailed(cause, getWeightDataResponse.getOperationFeedback());
                    return false;
                }
                this.myGetWeightDataListener.getWeightDataFailed(28);
                this.myLogger.error((Object)("Wrong reply received from BTS. GetWeightDataResponse or Ack expected, " + response.getClass() + " received."));
                return false;
            }
            this.myLogger.debug((Object)"NACK received");
            this.myGetWeightDataListener.startGetWeightDataFailed(ackResponse.getNackReason());
            return false;
        }
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"get beam data failed, connection lost.");
            this.myGetWeightDataListener.getWeightDataFailed(68);
            return false;
        }
        if (response == null) {
            this.myLogger.debug((Object)"get beam data failed, connection lost.");
            return false;
        }
        this.myLogger.debug((Object)"get beam data failed, invalid message.");
        this.myGetWeightDataListener.getWeightDataFailed(28);
        return false;
    }

    private void openSnapshot() {
        this.myLogger.debug((Object)"Snapshot open not supported.");
        this.myGetWeightDataListener.getWeightDataFailed(85, null);
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"This scenario cannot be aborted.");
        return true;
    }
}

