/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.GetRAEPropertiesRequest;
import com.nokia.em.bts.coreasset.message.GetRAEPropertiesResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.RAEPropertiesScenarioListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class RAEPropertiesScenario
implements Scenario {
    private BTSConnection myConnection;
    private RAEPropertiesScenarioListener myRAEPropertiesListener;
    private int myId;
    private Logger myLogger;
    private boolean myRunning = false;
    private Object myLock = new Object();

    public RAEPropertiesScenario(BTSConnection connection, RAEPropertiesScenarioListener listener, int id) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myRAEPropertiesListener = listener;
        this.myId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myRunning) {
                throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
            }
            this.myRunning = true;
        }
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber = -1;

            protected Object construct() {
                this.seqNumber = RAEPropertiesScenario.this.myConnection.createScenario();
                return RAEPropertiesScenario.this.runScenario(this.seqNumber);
            }

            protected void finished() {
                RAEPropertiesScenario.this.myConnection.deleteScenario(this.seqNumber);
                RAEPropertiesScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    public Object runScenario(int seqNumber) {
        if (CoreAsset.isSnapshotOpening()) {
            this.openSnapshot();
            return true;
        }
        GetRAEPropertiesRequest getRAEPropertiesRequest = new GetRAEPropertiesRequest(seqNumber, this.myId);
        this.myConnection.sendToBTS((BTSMessage)getRAEPropertiesRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(seqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                response = this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof GetRAEPropertiesResponse) {
                    this.myLogger.debug((Object)"Get RAE properties succeeded.");
                    this.myRAEPropertiesListener.getRAEPropertiesSucceeded((GetRAEPropertiesResponse)response);
                    return true;
                }
                this.myRAEPropertiesListener.getRAEPropertiesFailed(28);
                this.myLogger.error((Object)("Wrong reply received from BTS. GetRAEPropertiesResponse or Ack expected, " + response.getClass() + " received."));
                return false;
            }
            this.myLogger.debug((Object)"NACK received");
            this.myRAEPropertiesListener.startGetRAEPropertiesFailed(ackResponse.getNackReason());
            return false;
        }
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"get RAE properties failed, connection lost.");
            this.myRAEPropertiesListener.getRAEPropertiesFailed(68);
            return false;
        }
        if (response == null) {
            this.myLogger.debug((Object)"Connection lost.");
            return false;
        }
        this.myLogger.debug((Object)"get RAE properties failed, invalid message or connection lost.");
        this.myRAEPropertiesListener.getRAEPropertiesFailed(28);
        return false;
    }

    private void openSnapshot() {
        this.myLogger.debug((Object)"Snapshot open not supported.");
        this.myRAEPropertiesListener.getRAEPropertiesFailed(85);
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"This scenario cannot be aborted.");
        return true;
    }
}

