/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ResetWeightRequest;
import com.nokia.em.bts.coreasset.message.ResetWeightResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.raemanagement.ResetFactoryListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ResetWeightScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private ResetFactoryListener myResetListener;
    private boolean myRunning;
    private int mySeqNbr;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private boolean myAborted;
    private int myUnitId;

    public ResetWeightScenario(BTSConnection btsConnection, ResetFactoryListener resetListener, int unitId) {
        this.myBTSConnection = btsConnection;
        this.myResetListener = resetListener;
        this.myUnitId = unitId;
        this.myRunning = false;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.myAborted = false;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return ResetWeightScenario.this.runScenario();
            }

            protected void finished() {
                ResetWeightScenario.this.myBTSConnection.deleteScenario(ResetWeightScenario.this.mySeqNbr);
                ResetWeightScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myResetListener.resetFactoryFailed(85);
            return null;
        }
        this.mySeqNbr = this.myBTSConnection.createScenario();
        ResetWeightRequest request = new ResetWeightRequest(this.mySeqNbr, this.myUnitId);
        this.myBTSConnection.sendToBTS((BTSMessage)request);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                int reason = ack.getNackReason();
                this.myLogger.debug((Object)("Module weight failed, " + reason));
                this.myResetListener.startResetFactoryFailed(reason);
                return false;
            }
            response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr);
            if (response instanceof ResetWeightResponse) {
                ResetWeightResponse resetResponse = (ResetWeightResponse)response;
                if (resetResponse.isFaildWithErrorCode()) {
                    this.myResetListener.resetFactoryFailed(resetResponse.getCause(), resetResponse.getOperationFeedback());
                    return false;
                }
                this.myResetListener.resetFactorySucceeded();
                return true;
            }
            this.myResetListener.resetFactoryFailed(28);
            return false;
        }
        if (response instanceof Timeout) {
            this.myLogger.error((Object)"Reset weight failed due to timeout.");
            this.myResetListener.resetFactoryFailed(68);
            return false;
        }
        if (response == null) {
            if (this.myAborted) {
                this.myLogger.debug((Object)"Aborted by user.");
            } else {
                this.myLogger.debug((Object)"Null message, connection lost.");
                this.myResetListener.resetFactoryFailed(87);
            }
        } else {
            this.myLogger.error((Object)"Invalid message from BTS.");
            this.myResetListener.resetFactoryFailed(28);
        }
        return null;
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myAborted = true;
            this.myBTSConnection.interruptScenario(this.mySeqNbr);
        }
        return true;
    }
}

