/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.antennamanagement.vswr.monitoring;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.LicencedAck;
import com.nokia.em.bts.coreasset.message.VSWRMonitoringNotification;
import com.nokia.em.bts.coreasset.message.VSWRMonitoringStateRequest;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.vswr.monitoring.VSWRMonitoringListener;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.vswr.monitoring.VSWRMonitoringStopTimeoutHandler;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.apache.log4j.Logger;

class VSWRMonitoringWorkerThread
extends CoreAssetThread {
    private BTSConnection myBTSConnection;
    private Logger myLogger;
    private List<Integer> myUnitIds;
    private int myInterval;
    private VSWRMonitoringListener myListener;
    private int mySeqNumber;
    private boolean myIsRunning;
    private BTSMessage.Type myType;
    private VSWRMonitoringStopTimeoutHandler myTimeoutHandler;

    protected VSWRMonitoringWorkerThread(BTSConnection btsConnection, List<Integer> unitIds, int interval, VSWRMonitoringListener listener, BTSMessage.Type type) {
        this.myBTSConnection = btsConnection;
        this.myUnitIds = unitIds;
        this.myInterval = interval;
        this.myListener = listener;
        this.myType = type;
        this.myLogger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.myTimeoutHandler = new VSWRMonitoringStopTimeoutHandler(new VSWRMonitoringStopTimeoutHandlerListener());
    }

    protected Object construct() throws Exception {
        if (this.isManagerInSnapshotMode()) {
            return false;
        }
        this.setIsRunning(true);
        this.initializeScenario();
        if (!this.processStartMonitoring()) {
            return false;
        }
        this.processReceiveNotification();
        return true;
    }

    protected void finished() {
        this.setIsRunning(false);
        this.myBTSConnection.deleteScenario(this.mySeqNumber);
    }

    public void stopExecution() {
        if (!this.isRunning()) {
            return;
        }
        VSWRMonitoringStateRequest stopRequest = new VSWRMonitoringStateRequest(this.mySeqNumber, this.myUnitIds, false, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)stopRequest);
        this.myTimeoutHandler.start();
    }

    private synchronized void setIsRunning(boolean isRunning) {
        this.myIsRunning = isRunning;
    }

    public synchronized boolean isRunning() {
        return this.myIsRunning;
    }

    private boolean isManagerInSnapshotMode() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myListener.startMonitoringFailed(85);
            return true;
        }
        return false;
    }

    private void initializeScenario() {
        this.mySeqNumber = this.myBTSConnection.createScenario();
    }

    private boolean processStartMonitoring() {
        VSWRMonitoringStateRequest startRequest = this.myInterval >= 0 ? new VSWRMonitoringStateRequest(this.mySeqNumber, this.myUnitIds, true, this.myInterval, this.myType) : new VSWRMonitoringStateRequest(this.mySeqNumber, this.myUnitIds, true, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)startRequest);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof LicencedAck) {
            LicencedAck ack = (LicencedAck)response;
            if (!ack.isAck()) {
                this.myLogger.error((Object)"Start monitoring failed. _licenceOptionState=useDenied");
                this.myListener.startMonitoringFailed(40);
                return false;
            }
        } else if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                this.myLogger.error((Object)("Start monitoring failed. _nackReason=" + ack.getNackReason()));
                this.myListener.startMonitoringFailed(ack.getNackReason());
                return false;
            }
        } else {
            if (response instanceof Timeout) {
                this.myLogger.error((Object)"Start monitoring failed due to timeout.");
                this.myListener.startMonitoringFailed(68);
                return false;
            }
            this.myLogger.error((Object)"Start monitoring failed due to invalid message.");
            this.myListener.startMonitoringFailed(28);
            return false;
        }
        this.myListener.startMonitoringSuccess();
        return true;
    }

    private void processReceiveNotification() {
        while (true) {
            BTSMessage response;
            if ((response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber)) instanceof VSWRMonitoringNotification) {
                VSWRMonitoringNotification notif = (VSWRMonitoringNotification)response;
                this.myListener.monitoringNotifcation(notif.getVswrMonitoringDataList());
                continue;
            }
            if (response instanceof Ack) {
                if (!this.myTimeoutHandler.isStarted()) {
                    this.myLogger.warn((Object)"Ack received but VSWRMonitoringNotification is expected.");
                    continue;
                }
                this.myTimeoutHandler.stop();
                Ack ack = (Ack)response;
                if (!ack.getAck()) {
                    this.myLogger.error((Object)("Stop monitoring failed. _nackReason=" + ack.getNackReason()));
                    this.myListener.stopMonitoringFailed(ack.getNackReason());
                    continue;
                }
                this.myLogger.debug((Object)"Stop monitoring succeeds.");
                this.myListener.stopMonitoringSuccess();
                break;
            }
            if (response == null) {
                this.myLogger.error((Object)"Response is null but VSWRMonitoringNotification is expected. Monitoring is terminated.");
                this.myListener.abortMonitoring();
                break;
            }
            this.myLogger.warn((Object)(String.valueOf(response.toString()) + " received but VSWRMonitoringNotification is expected."));
        }
    }

    protected void setStopTimeOut(int timeout) {
        this.myTimeoutHandler.setTimeout(timeout);
    }

    private class VSWRMonitoringStopTimeoutHandlerListener
    implements ActionListener {
        private VSWRMonitoringStopTimeoutHandlerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VSWRMonitoringWorkerThread.this.myListener.stopMonitoringFailed(68);
            VSWRMonitoringWorkerThread.this.myTimeoutHandler.stop();
        }
    }
}

