/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.authentication;

import com.nokia.em.bts.rp.master.tool.DomParserHelper;
import com.nokia.em.poseidon.frameworks.raml.RAMLCMData;
import com.nokia.em.poseidon.frameworks.raml.RAMLFile;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class RamlResponseParser {
    private boolean myIsLastMessage;
    private String myVersion;
    private String myCompression;
    private String myEncoding;
    private String myErrorText;
    private String myErrorCode;
    private Throwable myError;
    private final Logger myLogger;
    private Object myResponse;
    private List<RAMLManagedObject> myRamlManagedObjects = new ArrayList<RAMLManagedObject>();
    private List<Exception> myRamlMoExceptions = new ArrayList<Exception>();

    public RamlResponseParser(Object ramlResponse) {
        this.myResponse = ramlResponse;
        this.myLogger = Logger.getLogger(this.getClass());
    }

    public List<RAMLManagedObject> parse() throws Throwable {
        String ramlResponse = "";
        String result = "";
        try {
            DomParserHelper.StringTarget _lastMsg = new DomParserHelper.StringTarget(new String[]{"_lastMsg"});
            DomParserHelper.StringTarget _errorCode = new DomParserHelper.StringTarget(new String[]{"_errorCode"});
            DomParserHelper.StringTarget _errorText = new DomParserHelper.StringTarget(new String[]{"_errorText"});
            DomParserHelper.StructTarget parameters = new DomParserHelper.StructTarget(new String[]{"managedObject", "parameter"});
            parameters.add(new String[]{"parameterName"});
            parameters.add(new String[]{"newValue"});
            parameters.setMultiplicity(Integer.MAX_VALUE);
            if (this.myResponse instanceof Node) {
                DomParserHelper.parseTarget((Node)((Node)this.myResponse), (DomParserHelper.ParseTarget[])new DomParserHelper.ParseTarget[]{_lastMsg, _errorCode, _errorText, parameters});
            } else {
                DomParserHelper.parseTarget((String)((String)this.myResponse), (DomParserHelper.ParseTarget[])new DomParserHelper.ParseTarget[]{_lastMsg, _errorCode, _errorText, parameters});
            }
            this.myIsLastMessage = Boolean.parseBoolean((String)_lastMsg.getValue());
            this.myErrorCode = (String)_errorCode.getValue();
            this.myErrorText = (String)_errorText.getValue();
            for (DomParserHelper.Struct struct : parameters.getValues()) {
                String parameterName = struct.get(new String[]{"parameterName"});
                if ("version".equals(parameterName)) {
                    this.myVersion = struct.get(new String[]{"newValue"});
                    continue;
                }
                if ("compression".equals(parameterName)) {
                    this.myCompression = struct.get(new String[]{"newValue"});
                    continue;
                }
                if ("encoding".equals(parameterName)) {
                    this.myEncoding = struct.get(new String[]{"newValue"});
                    continue;
                }
                if ("RAMLFile".equals(parameterName)) {
                    ramlResponse = struct.get(new String[]{"newValue"});
                    continue;
                }
                if ("changedObjects".equals(parameterName)) {
                    ramlResponse = struct.get(new String[]{"newValue"});
                    continue;
                }
                if (!"result".equals(parameterName)) continue;
                result = struct.get(new String[]{"newValue"});
                this.parseResult(result);
                Exception error = this.getError();
                if (error == null) continue;
                this.setError(error);
            }
        }
        catch (Throwable t) {
            this.myLogger.error((Object)"RAML response parsing failed. Invalid format: ", t);
            throw t;
        }
        if (this.myErrorCode != null && this.myError == null) {
            this.myError = new Exception(this.myErrorCode);
        }
        if (ramlResponse != null && ramlResponse.length() > 0) {
            this.myRamlManagedObjects.addAll(this.createRamlFileAndParse(ramlResponse));
        }
        return this.myRamlManagedObjects;
    }

    public void parseResult(String result) throws Throwable {
        Exception moException = null;
        DomParserHelper.StructTarget ruleStructTarget = new DomParserHelper.StructTarget(new String[]{"message"});
        ruleStructTarget.add("version", (DomParserHelper.ParseRule)new DomParserHelper.AttributeRule("name", "version"), new String[]{"p"});
        ruleStructTarget.add("progressInfo", (DomParserHelper.ParseRule)new DomParserHelper.AttributeRule("name", "progressInfo"), new String[]{"p"});
        ruleStructTarget.add("dn", (DomParserHelper.ParseRule)new DomParserHelper.AttributeRule("name", "dn"), new String[]{"p"});
        ruleStructTarget.add("text", (DomParserHelper.ParseRule)new DomParserHelper.AttributeRule("name", "text"), new String[]{"p"});
        ruleStructTarget.add("status", (DomParserHelper.ParseRule)new DomParserHelper.AttributeRule("name", "status"), new String[]{"p"});
        ruleStructTarget.add("details", (DomParserHelper.ParseRule)new DomParserHelper.AttributeRule("name", "details"), new String[]{"p"});
        ruleStructTarget.setMultiplicity(Integer.MAX_VALUE);
        DomParserHelper.parseTarget((String)result, (DomParserHelper.ParseTarget[])new DomParserHelper.ParseTarget[]{ruleStructTarget});
        for (DomParserHelper.Struct struct : ruleStructTarget.getValues()) {
            if (struct.get(new String[]{"status"}) != null) {
                if ("ok".equals(struct.get(new String[]{"status"}))) continue;
                moException = new Exception();
            }
            if (struct.get(new String[]{"progressInfo"}) != null) {
                moException = new Exception(struct.get(new String[]{"progressInfo"}));
            }
            if (struct.get(new String[]{"text"}) != null) {
                moException = new Exception(struct.get(new String[]{"text"}));
            }
            if (moException == null) continue;
            this.myRamlMoExceptions.add(moException);
        }
    }

    public String getEncoding() {
        return this.myEncoding;
    }

    public String getCompression() {
        return this.myCompression;
    }

    public String getVersion() {
        return this.myVersion;
    }

    private List<RAMLManagedObject> createRamlFileAndParse(String ramlResponse) throws Throwable {
        RAMLFile myRamlFile = null;
        ArrayList<RAMLManagedObject> ramlModelObjects = new ArrayList<RAMLManagedObject>();
        try {
            myRamlFile = new RAMLFile();
            myRamlFile.readFrom((InputStream)new ByteArrayInputStream(ramlResponse.getBytes()));
            for (Object obj : ((RAMLCMData)myRamlFile.getCMData().get(0)).getMOs()) {
                ramlModelObjects.add((RAMLManagedObject)obj);
            }
        }
        catch (Throwable ex) {
            this.myLogger.error((Object)"RAML response parsing failed. Invalid format", ex);
            throw ex;
        }
        return ramlModelObjects;
    }

    public boolean isLastMessage() {
        return this.myIsLastMessage;
    }

    public void setError(Exception error) {
        this.myError = error;
    }

    public Exception getError() {
        if (this.myRamlMoExceptions != null && this.myRamlMoExceptions.size() > 0 && this.myError == null) {
            if (this.myErrorCode != null && this.myErrorText == null) {
                StringBuilder message = new StringBuilder();
                for (Exception exception : this.myRamlMoExceptions) {
                    message.append(exception.getMessage());
                }
                this.myErrorText = message.toString();
            }
            this.myError = new Exception(this.myErrorText);
        }
        return (Exception)this.myError;
    }
}

