/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.authentication;

import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.authentication.RamlResponseParser;
import com.nokia.em.bts.coreasset.scenario.authentication.UserAuthenticationScenarioListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.RAMLRequest;
import com.nokia.em.bts.rp.master.message.RAMLResponse;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UserAuthenticationScenario
implements Scenario {
    private static int TIMEOUT = 305000;
    private BTSConnection myBTSConnection;
    private UserAuthenticationScenarioListener myListener;
    private String myUserName;
    private String myPassword;

    public UserAuthenticationScenario(BTSConnection connection, UserAuthenticationScenarioListener listener, String userName, String password) {
        this.myBTSConnection = connection;
        this.myListener = listener;
        this.myUserName = userName;
        this.myPassword = password;
    }

    @Override
    public void execute() {
        CoreAssetThread worker = new CoreAssetThread(){
            int intSeqNumber;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Object construct() throws Exception {
                this.intSeqNumber = UserAuthenticationScenario.this.myBTSConnection.createScenario();
                RAMLRequest request = new RAMLRequest(this.intSeqNumber, UserAuthenticationScenario.this.createRamlHeader());
                UserAuthenticationScenario.this.myBTSConnection.sendToBTS((BTSMessage)request);
                BTSMessage response = UserAuthenticationScenario.this.myBTSConnection.receiveFromBTS(this.intSeqNumber, (long)TIMEOUT);
                if (response instanceof RAMLResponse) {
                    try {
                        RAMLManagedObject mo;
                        List responseMOs = UserAuthenticationScenario.this.parseResponse(response);
                        Iterator iterator = responseMOs.iterator();
                        do {
                            if (iterator.hasNext()) continue;
                            UserAuthenticationScenario.this.myListener.sendFailed("Invalid RAMLResponse.");
                            return null;
                        } while (!"LUAC".equals((mo = (RAMLManagedObject)iterator.next()).getMOClass()));
                        UserAuthenticationScenario.this.myListener.sendCompleted();
                        return null;
                    }
                    catch (Throwable e) {
                        UserAuthenticationScenario.this.myListener.sendFailed(e.getMessage());
                        return null;
                    }
                }
                if (response instanceof Timeout) {
                    UserAuthenticationScenario.this.myListener.sendTimeout();
                    return null;
                }
                UserAuthenticationScenario.this.myListener.sendFailed("Invalid RAMLResponse.");
                return null;
            }
        };
        worker.start();
    }

    private String createRamlHeader() {
        StringBuilder ramlHeader = new StringBuilder(100);
        ramlHeader.append("<managedObject distName=\"FTM-1/RAML-1\">");
        ramlHeader.append(this.createRamlHeaderParameter("version", "1.0", ""));
        ramlHeader.append(this.createRamlHeaderParameter("compression", "NONE", ""));
        ramlHeader.append(this.createRamlHeaderParameter("encoding", "NONE", ""));
        ramlHeader.append(this.createRamlHeaderParameter("RAMLFile", this.createRamlFileData(), ""));
        ramlHeader.append("</managedObject>");
        return ramlHeader.toString();
    }

    private String createRamlHeaderParameter(String parameterName, String parameterValue, String parameterPreValue) {
        StringBuilder ramlParameter = new StringBuilder();
        ramlParameter.append("<parameter>");
        ramlParameter.append("<parameterName>").append(parameterName).append("</parameterName>");
        ramlParameter.append("<newValue>").append(parameterValue).append("</newValue>");
        ramlParameter.append("<prevValue>").append(parameterPreValue).append("</prevValue>");
        ramlParameter.append("</parameter>");
        return ramlParameter.toString();
    }

    private String createRamlFileData() {
        StringBuilder ramlFileData = new StringBuilder();
        ramlFileData.append("<![CDATA[");
        ramlFileData.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ramlFileData.append("<raml version=\"2.1E\" xmlns=\"raml21E.xsd\">");
        ramlFileData.append("<cmData type=\"actual\">");
        ramlFileData.append("<header>");
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        ramlFileData.append("<log action=\"modified\" dateTime=\"" + dateTimeFormatter.format(System.currentTimeMillis()) + "\"" + " appInfo=\"FLEXI TRS MANAGER\"/>");
        ramlFileData.append("</header>");
        RAMLManagedObject ne = new RAMLManagedObject("FTM-1/AMGR-1/LUAC-1", "LUAC", "update", null);
        ne.setVersion("1.0");
        ne.setParameter(new RAMLParameter("userName", this.myUserName));
        ne.setParameter(new RAMLParameter("password", this.myPassword));
        ne.setAttribute("LogTrace", "Sent local account update command");
        ramlFileData.append(ne.toXmlString());
        ramlFileData.append("</cmData>");
        ramlFileData.append("</raml>]]>");
        return ramlFileData.toString();
    }

    private List<RAMLManagedObject> parseResponse(BTSMessage response) throws Throwable {
        RamlResponseParser parser = new RamlResponseParser(((RAMLResponse)response).getRAMLResponse());
        ArrayList<RAMLManagedObject> responseMOs = new ArrayList<RAMLManagedObject>();
        responseMOs.addAll(parser.parse());
        return responseMOs;
    }

    @Override
    public boolean abort() {
        return false;
    }
}

