/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.batterybackup;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.BatteryBackupTimeNotifRequest;
import com.nokia.em.bts.coreasset.message.BatteryBackupTimeNotification;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.batterybackup.BatteryBackupListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class BatteryBackupTimeScenario
implements Scenario,
BTSNotificationListener {
    private BTSConnection myConnection;
    private BatteryBackupListener myBatteryBackupListener;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public BatteryBackupTimeScenario(BTSConnection connection, BatteryBackupListener batteryBackupListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myBatteryBackupListener = batteryBackupListener;
    }

    @Override
    public void execute() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            return;
        }
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){
            final int seqNumber;
            {
                this.seqNumber = BatteryBackupTimeScenario.this.myConnection.createScenario();
            }

            protected Object construct() {
                BatteryBackupTimeNotifRequest batteryBackupTimeNotifRequest = new BatteryBackupTimeNotifRequest(this.seqNumber, BatteryBackupTimeScenario.this.myType);
                BatteryBackupTimeScenario.this.myConnection.sendToBTS((BTSMessage)batteryBackupTimeNotifRequest);
                BTSMessage response = BatteryBackupTimeScenario.this.myConnection.receiveFromBTS(this.seqNumber);
                BatteryBackupTimeScenario.this.myConnection.deleteScenario(this.seqNumber);
                if (response instanceof BatteryBackupTimeNotification) {
                    BatteryBackupTimeNotification bbuNotif = (BatteryBackupTimeNotification)response;
                    BatteryBackupTimeScenario.this.myBatteryBackupListener.batteryBackUpTimeLeftReceived(bbuNotif.getRemainingTime());
                } else if (response != null) {
                    BatteryBackupTimeScenario.this.myLogger.error((Object)("Wrong reply received from BTS. BatteryBackupTimeNotification expected, " + response.getClass() + " received."));
                } else {
                    BatteryBackupTimeScenario.this.myLogger.error((Object)"Null reply received from BTS. BatteryBackupTimeNotification expected.");
                }
                return true;
            }

            protected void finished() {
                BatteryBackupTimeScenario.this.myRunning = false;
            }
        };
        this.myConnection.subscribeNotification((BTSNotificationListener)this);
        worker.start();
    }

    public void btsNotificationReceived(final BTSMessage btsMessage) {
        if (btsMessage instanceof BatteryBackupTimeNotification) {
            CoreAssetThread swingWorker = new CoreAssetThread(){

                protected Object construct() {
                    BatteryBackupTimeNotification batteryBackupTimeNotification = (BatteryBackupTimeNotification)btsMessage;
                    try {
                        BatteryBackupTimeScenario.this.myBatteryBackupListener.batteryBackUpTimeLeftReceived(batteryBackupTimeNotification.getRemainingTime());
                    }
                    catch (Exception e) {
                        BatteryBackupTimeScenario.this.myLogger.error((Object)("Exception in Calling BatteryBackup Listener " + e.getMessage()));
                    }
                    return true;
                }
            };
            swingWorker.start();
        }
    }

    @Override
    public boolean abort() {
        this.myConnection.unsubscribeNotification((BTSNotificationListener)this);
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

