/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.scenario.btstests.TestScenario;
import com.nokia.em.bts.coreasset.scenario.btstests.TestStopListener;
import java.util.HashMap;
import java.util.Map;

public class ActiveTestsHandler {
    private static ActiveTestsHandler myActiveTestsHandler;
    private Map<Integer, TestScenario> myTestScenarios = new HashMap<Integer, TestScenario>();
    private Map<Integer, TestStopListener> myStopListeners = new HashMap<Integer, TestStopListener>();

    private ActiveTestsHandler() {
    }

    public void addTestScenario(TestScenario testScenario, int seqNumber) {
        this.myTestScenarios.put(seqNumber, testScenario);
    }

    public void addStopListener(TestStopListener stopListener, int seqNumber) {
        this.myStopListeners.put(seqNumber, stopListener);
    }

    public static void reset() {
        if (myActiveTestsHandler != null) {
            ActiveTestsHandler.myActiveTestsHandler.myTestScenarios.clear();
            ActiveTestsHandler.myActiveTestsHandler.myStopListeners.clear();
        }
    }

    public static synchronized ActiveTestsHandler getInstance() {
        if (myActiveTestsHandler == null) {
            myActiveTestsHandler = new ActiveTestsHandler();
        }
        return myActiveTestsHandler;
    }

    public void requestStop(int seqNum) {
        TestScenario myTestScenario = this.myTestScenarios.get(seqNum);
        if (myTestScenario != null) {
            myTestScenario.stopTest();
        }
    }

    public Boolean isTestExists(int seqNum) {
        return this.myTestScenarios.containsKey(seqNum);
    }

    public void stopRequestFinished(int seqNum, int successCode) {
        TestStopListener myTestStopListener = this.myStopListeners.get(seqNum);
        if (myTestStopListener != null) {
            myTestStopListener.stopRequestFinished(successCode);
            this.myStopListeners.remove(seqNum);
        }
        if (successCode == 34 || successCode == 39) {
            this.myTestScenarios.remove(seqNum);
        }
    }
}

