/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ActiveTestListRequest;
import com.nokia.em.bts.coreasset.message.ActiveTestListResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTest;
import com.nokia.em.bts.coreasset.scenario.btstests.BtsTest;
import com.nokia.em.bts.coreasset.scenario.btstests.TestControlListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class ActiveTestsScenario
implements Scenario,
SnapshotSaver {
    private BTSConnection myConnection;
    private TestControlListener myTestControlListener;
    private ActiveTest myActiveTest;
    private boolean myRunning = false;
    private Logger myLogger;
    private static final String SNAPSHOT_TASK = "ActiveTests";
    private static final String SNAPSHOT_TASK_NAME = "CoreAsset_Snapshot_ActiveTests";
    private static final int SNAPSHOT_TIMEOUT = 10000;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public ActiveTestsScenario(BTSConnection connection, TestControlListener testControlListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myTestControlListener = testControlListener;
        this.myActiveTest = ActiveTest.getInstance();
    }

    public ActiveTestsScenario(BTSConnection connection, TestControlListener testControlListener, BTSMessage.Type type) {
        this(connection, testControlListener);
        this.myType = type;
    }

    private String getData() {
        StringBuilder sb = new StringBuilder("<ActiveTests>");
        Vector tests = this.myActiveTest.getActiveTests();
        int i = 0;
        while (i < tests.size()) {
            BtsTest test = (BtsTest)tests.get(i);
            sb.append("<ActiveTest>");
            sb.append("<_testInfo>").append(test.getTestType()).append("</_testInfo>");
            sb.append("<_seqNumber>").append(test.getSequenceNumber()).append("</_seqNumber>");
            sb.append("<_owned>").append(test.isOwned()).append("</_owned>");
            sb.append("</ActiveTest>");
            ++i;
        }
        sb.append("</ActiveTests>");
        return sb.toString();
    }

    private void openSnapshot() {
        String activeTestFile = String.valueOf(CoreAsset.getSnapshotOpenLocation().getFile()) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + ".xml";
        Element element = Tools.parseElement((String)activeTestFile);
        Vector activeTests = new Vector();
        if (element != null) {
            try {
                ActiveTestListResponse response = new ActiveTestListResponse(0, element);
                activeTests = response.getActiveTests();
            }
            catch (Exception e) {
                this.myLogger.warn((Object)"Cannot create fake activetestlistresponse message in open snapshot.", (Throwable)e);
            }
        }
        this.myActiveTest.setActiveTests(activeTests);
        this.myTestControlListener.activeTestsReceived(activeTests);
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){
            int intSeqNumber;

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    ActiveTestsScenario.this.myLogger.debug((Object)"Opening snapshot file.");
                    ActiveTestsScenario.this.openSnapshot();
                    return true;
                }
                this.intSeqNumber = ActiveTestsScenario.this.myConnection.createScenario();
                ActiveTestListRequest activeTestListRequest = new ActiveTestListRequest(this.intSeqNumber, ActiveTestsScenario.this.myType);
                ActiveTestsScenario.this.myConnection.sendToBTS((BTSMessage)activeTestListRequest);
                BTSMessage response = ActiveTestsScenario.this.myConnection.receiveFromBTS(this.intSeqNumber);
                if (response instanceof ActiveTestListResponse) {
                    ActiveTestListResponse activeTestListResponse = (ActiveTestListResponse)response;
                    Vector vecActiveTestsInMessage = activeTestListResponse.getActiveTests();
                    ActiveTestsScenario.this.myActiveTest.setActiveTests(vecActiveTestsInMessage);
                    CoreAsset.addSnapshotSaver(ActiveTestsScenario.this);
                    ActiveTestsScenario.this.myTestControlListener.activeTestsReceived(vecActiveTestsInMessage);
                    return true;
                }
                ActiveTestsScenario.this.myTestControlListener.activeTestsReceiveFailed(28);
                return false;
            }

            protected void finished() {
                ActiveTestsScenario.this.myConnection.deleteScenario(this.intSeqNumber);
                ActiveTestsScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    public Collection getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(SNAPSHOT_TASK_NAME);
        return l;
    }

    public boolean isLocalisationRequired() {
        return true;
    }

    public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL level, final SaverProgressListener sp) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                ActiveTestsScenario.this.runSave(url, sp);
                return null;
            }
        };
        worker.start();
    }

    private void runSave(String url, SaverProgressListener sp) {
        block8: {
            try {
                sp.taskStarted(SNAPSHOT_TASK_NAME, 7, 10000, this.isLocalisationRequired());
                File dir = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK);
                if (!dir.mkdir()) {
                    this.myLogger.warn((Object)"Failed to create active tests snapshot directory");
                }
                File f = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + ".xml");
                OutputStreamWriter out = null;
                try {
                    try {
                        out = new OutputStreamWriter(new FileOutputStream(f, false));
                        out.write(this.getData());
                    }
                    catch (Exception e) {
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                        this.myLogger.error((Object)"Failed to save active tests snapshot file", (Throwable)e);
                        out.close();
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                        this.myLogger.debug((Object)"Active tests snapshot file successfully created");
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    out.close();
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                    this.myLogger.debug((Object)"Active tests snapshot file successfully created");
                    throw throwable;
                }
                out.close();
                sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                this.myLogger.debug((Object)"Active tests snapshot file successfully created");
            }
            catch (Exception e) {
                sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                this.myLogger.error((Object)"Failed to save active tests snapshot data", (Throwable)e);
            }
        }
        sp.saveCompleted((SnapshotSaver)this);
    }

    public void cancel(SaverProgressListener sp) {
        sp.saveCancelled((SnapshotSaver)this);
    }

    public int getSavingPriority() {
        return 2;
    }

    public void stopProcess(int process) {
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

