/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.StartTestRequest;
import com.nokia.em.bts.coreasset.message.StartTestResponse;
import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.message.TestReportRequestBER;
import com.nokia.em.bts.coreasset.message.TestReportRequestLTEUL;
import com.nokia.em.bts.coreasset.message.TestReportResponseBER;
import com.nokia.em.bts.coreasset.message.TestReportResponseLTEUL;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTest;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTestsHandler;
import com.nokia.em.bts.coreasset.scenario.btstests.BtsTest;
import com.nokia.em.bts.coreasset.scenario.btstests.TestListener;
import com.nokia.em.bts.coreasset.scenario.btstests.TestReportListener;
import com.nokia.em.bts.coreasset.scenario.btstests.TestScenario;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class BerTestScenario
implements Scenario,
TestScenario {
    public static final String TEST_LISTENER = "testListener";
    public static final String TEST_REPORT_LISTENER = "testReportListener";
    public static final String LCR_ID = "lcrId";
    public static final String FRC_ID = "frcId";
    public static final String START_RB = "startRB";
    public static final String REPORTING_INTERVAL = "reportingInterval";
    public static final String EARFCN = "earfcn";
    public static final String TDD_FRAME_CONF = "tddFrameConf";
    public static final String TDD_SPEC_SUBF_CONF = "tddSpecSubfConf";
    private BTSConnection myBTSConnection;
    private TestListener myTestListener;
    private TestReportListener myTestReportListener;
    private final String myTestParameters;
    private int mySeqNumber;
    private boolean myRunning = false;
    private int myInterval = 0;
    private ActionListener myIntervalsTestIntervalActionListener = null;
    private ActionListener myIntervalsTestDurationActionListener = null;
    private int myLcrId;
    private int myDuration = -1;
    private final String myTestType;
    private ActiveTest myActiveTest;
    private ActiveTestsHandler myActiveTestsHandler;
    private static final int MILLISECOND_FACTOR = 1000;
    private Logger myLogger;
    private static final String MEASUREMENT_TYPE_PRACH = "Prach";
    private boolean isStopTestSent = false;
    private boolean isLastTeReportRequestSent = false;
    private boolean isSendReportRequest = true;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private Timer myStopTestTimeoutTimer;

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int testModelNumber, int lcrId, String txrxTestType, int interval) {
        this.init(connection, testListener, reportListener, lcrId, interval, -1);
        this.myTestType = "testModelWimax";
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_testModelNumber>" + testModelNumber + "</_testModelNumber>");
        testParameters.append("<_lcrId>" + lcrId + "</_lcrId>");
        testParameters.append("<_txrxTestType>" + txrxTestType + "</_txrxTestType>");
        this.myTestParameters = testParameters.toString();
    }

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, int uarfcn, int duration, long scramblingCode, int interval, BTSMessage.Type type) {
        this(connection, testListener, reportListener, lcrId, uarfcn, duration, scramblingCode, interval);
        this.myType = type;
    }

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, int uarfcn, int duration, long scramblingCode, int interval) {
        this.init(connection, testListener, reportListener, lcrId, interval, duration);
        this.myTestType = "BER";
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_lcrId>" + lcrId + "</_lcrId>");
        testParameters.append("<_uarfcn>" + uarfcn + "</_uarfcn>");
        testParameters.append("<_duration>" + duration + "</_duration>");
        testParameters.append("<_scramblingCode>" + scramblingCode + "</_scramblingCode>");
        this.myTestParameters = testParameters.toString();
    }

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, String frcId, int startRB, int reportingInterval) {
        this(connection, testListener, reportListener, lcrId, frcId, startRB, reportingInterval, -1);
    }

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, String frcId, int startRB, int reportingInterval, BTSMessage.Type type) {
        this(connection, testListener, reportListener, lcrId, frcId, startRB, reportingInterval, -1);
        this.myType = type;
    }

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, String frcId, int startRB, int reportingInterval, int earfcn) {
        this.init(connection, testListener, reportListener, lcrId, reportingInterval, -1);
        this.myTestType = "testModelLTEUpLinkTP";
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_lcrId>" + lcrId + "</_lcrId>");
        testParameters.append("<_frcId>" + frcId + "</_frcId>");
        testParameters.append("<_resourceBlockOffset>" + startRB + "</_resourceBlockOffset>");
        testParameters.append("<_reportingInterval>" + reportingInterval + "</_reportingInterval>");
        if (earfcn != -1) {
            testParameters.append("<_earfcn>" + earfcn + "</_earfcn>");
        }
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public BerTestScenario(BTSConnection connection, Map<String, Object> scenarioParameters) {
        TestListener testListener = (TestListener)scenarioParameters.get(TEST_LISTENER);
        TestReportListener reportListener = (TestReportListener)scenarioParameters.get(TEST_REPORT_LISTENER);
        int lcrId = (Integer)scenarioParameters.get(LCR_ID);
        String frcId = (String)scenarioParameters.get(FRC_ID);
        int startRB = (Integer)scenarioParameters.get(START_RB);
        int reportingInterval = (Integer)scenarioParameters.get(REPORTING_INTERVAL);
        int earfcn = (Integer)scenarioParameters.get(EARFCN);
        int tddFrameConf = (Integer)scenarioParameters.get(TDD_FRAME_CONF);
        int tddSpecSubfConf = (Integer)scenarioParameters.get(TDD_SPEC_SUBF_CONF);
        this.init(connection, testListener, reportListener, lcrId, reportingInterval, -1);
        this.myTestType = "testModelLTEUpLinkTP";
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_lcrId>" + lcrId + "</_lcrId>");
        testParameters.append("<_frcId>" + frcId + "</_frcId>");
        testParameters.append("<_resourceBlockOffset>" + startRB + "</_resourceBlockOffset>");
        testParameters.append("<_reportingInterval>" + reportingInterval + "</_reportingInterval>");
        testParameters.append("<_tddFrameConf>" + tddFrameConf + "</_tddFrameConf>");
        testParameters.append("<_tddSpecSubfConf>" + tddSpecSubfConf + "</_tddSpecSubfConf>");
        if (earfcn != -1) {
            testParameters.append("<_earfcn>" + earfcn + "</_earfcn>");
        }
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, String frcId, int startRB, int reportingInterval, int earfcn, BTSMessage.Type type) {
        this(connection, testListener, reportListener, lcrId, frcId, startRB, reportingInterval, earfcn);
        this.myType = type;
    }

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, String measurementType, int idleSubframes, int reportingInterval, int prachConfIndex, boolean highSpeed, int burstFormat, int acceptedTimingError, int constantOffset, int delayPatternDuration, String frcId) {
        this.init(connection, testListener, reportListener, lcrId, reportingInterval, -1);
        this.myTestType = "testModelLTEUpLinkCCM";
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_lcrId>" + lcrId + "</_lcrId>");
        testParameters.append("<_measurementType>" + measurementType + "</_measurementType>");
        testParameters.append("<_idleSubframes>" + idleSubframes + "</_idleSubframes>");
        testParameters.append("<_reportingInterval>" + reportingInterval + "</_reportingInterval>");
        if (measurementType.equals(MEASUREMENT_TYPE_PRACH)) {
            testParameters.append("<_prachConfIndex>" + prachConfIndex + "</_prachConfIndex>");
            testParameters.append("<_highSpeed>" + highSpeed + "</_highSpeed>");
            testParameters.append("<_burstFormat>" + burstFormat + "</_burstFormat>");
            testParameters.append("<_acceptedTimingError>" + acceptedTimingError + "</_acceptedTimingError>");
            testParameters.append("<_constantOffset>" + constantOffset + "</_constantOffset>");
            testParameters.append("<_delayPatternDuration>" + delayPatternDuration + "</_delayPatternDuration>");
        }
        if (!"Coreasset_Unknown".equals(frcId)) {
            testParameters.append("<_frcId>" + frcId + "</_frcId>");
        }
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public BerTestScenario(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, String measurementType, int idleSubframes, int reportingInterval, int prachConfIndex, boolean highSpeed, int burstFormat, int acceptedTimingError, int constantOffset, int delayPatternDuration, String frcId, BTSMessage.Type type) {
        this(connection, testListener, reportListener, lcrId, measurementType, idleSubframes, reportingInterval, prachConfIndex, highSpeed, burstFormat, acceptedTimingError, constantOffset, delayPatternDuration, frcId);
        this.myType = type;
    }

    private void init(BTSConnection connection, TestListener testListener, TestReportListener reportListener, int lcrId, int interval, int duration) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myTestListener = testListener;
        this.myTestReportListener = reportListener;
        this.myInterval = interval;
        this.myLcrId = lcrId;
        this.myDuration = duration;
        this.myActiveTest = ActiveTest.getInstance();
        this.myActiveTestsHandler = ActiveTestsHandler.getInstance();
        this.myIntervalsTestIntervalActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (BerTestScenario.this.myTestType.equals("testModelLTEUpLinkCCM") || BerTestScenario.this.myTestType.equals("testModelLTEUpLinkTP")) {
                    BerTestScenario.this.myBTSConnection.sendToBTS((BTSMessage)new TestReportRequestLTEUL(BerTestScenario.this.mySeqNumber));
                } else {
                    BerTestScenario.this.myBTSConnection.sendToBTS((BTSMessage)new TestReportRequestBER(BerTestScenario.this.mySeqNumber));
                }
            }
        };
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return BerTestScenario.this.runScenario();
            }

            protected void finished() {
                BerTestScenario.this.myBTSConnection.deleteScenario(BerTestScenario.this.mySeqNumber);
                BerTestScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    private void abortTest() {
        if (this.myActiveTest.getActiveTest(this.myLcrId, this.myTestType) != null) {
            BtsTest berTest = this.myActiveTest.getActiveTest(this.myLcrId, this.myTestType);
            if (berTest == null) {
                return;
            }
            int intSeqNumber = berTest.getSequenceNumber();
            if (!this.isSendReportRequest) {
                this.sendStopTestRequest(intSeqNumber);
                return;
            }
            this.isStopTestSent = false;
            this.isLastTeReportRequestSent = true;
            if (this.myTestType.equals("testModelLTEUpLinkCCM") || this.myTestType.equals("testModelLTEUpLinkTP")) {
                this.myLogger.debug((Object)"Last TestReportRequest sent");
                this.myBTSConnection.sendToBTS((BTSMessage)new TestReportRequestLTEUL(intSeqNumber));
            } else {
                this.myLogger.debug((Object)"Last TestReportRequest sent");
                this.myBTSConnection.sendToBTS((BTSMessage)new TestReportRequestBER(intSeqNumber));
            }
        } else if (this.myRunning) {
            this.myLogger.error((Object)("Failed. Active test not found. myLcrId " + this.myLcrId + ", mySeqNumber " + this.mySeqNumber));
        } else {
            this.sendTestAborted(34);
            this.myLogger.error((Object)("Active test not found, Scenario have been ended. myLcrId " + this.myLcrId + ", mySeqNumber " + this.mySeqNumber));
        }
    }

    public void setSendReportRequest(boolean value) {
        this.isSendReportRequest = value;
    }

    @Override
    public boolean abort() {
        if (this.myIntervalsTestIntervalActionListener != null) {
            TimerService.getInstance().stopTimer(this.myIntervalsTestIntervalActionListener);
        }
        this.abortTest();
        return true;
    }

    private void sendTestStartFailed(int successCode) {
        switch (successCode) {
            case 42: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 6);
                break;
            }
            case 58: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 10);
                break;
            }
            case 59: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 11);
                break;
            }
            case 105: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 15);
                break;
            }
            case 106: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 16);
                break;
            }
            case 107: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 17);
                break;
            }
            case 108: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 18);
                break;
            }
            case 60: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 12);
                break;
            }
            case 61: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 13);
                break;
            }
            case 62: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 14);
                break;
            }
            default: {
                this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, -1);
            }
        }
    }

    private void sendTestAborted(int successCode) {
        switch (successCode) {
            case 34: {
                this.myTestListener.testAborted(this.myLcrId, 1);
                break;
            }
            case 39: {
                this.myTestListener.testAborted(this.myLcrId, 2);
                break;
            }
            case 58: {
                this.myTestListener.testAborted(this.myLcrId, 10);
                break;
            }
            case 59: {
                this.myTestListener.testAborted(this.myLcrId, 11);
                break;
            }
            default: {
                this.myTestListener.testAborted(this.myLcrId, -1);
            }
        }
    }

    private void startTestDurationTimer() {
        this.myIntervalsTestDurationActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BerTestScenario.this.abortTest();
                if (BerTestScenario.this.myIntervalsTestIntervalActionListener != null) {
                    TimerService.getInstance().stopTimer(BerTestScenario.this.myIntervalsTestIntervalActionListener);
                }
            }
        };
        TimerService.getInstance().startTimer(this.myIntervalsTestDurationActionListener, (long)(this.myDuration * 1000), 1);
    }

    private void processReportResponse(TestReportResponseBER testReportResponseBER) {
        if (this.myTestType.equals("BER")) {
            if (!testReportResponseBER.isATMResponding()) {
                this.myTestReportListener.testReportBERReceivedATMNotResponding(this.myLcrId);
            } else {
                this.myTestReportListener.testReportBERReceived(this.myLcrId, -1, testReportResponseBER.getBerPercentage(), testReportResponseBER.getBlerPercentage(), testReportResponseBER.isATMSynchronized(), testReportResponseBER.getReceivedBits(), testReportResponseBER.getDefectedBits(), testReportResponseBER.getCrcErrorCount(), testReportResponseBER.getCountedFrames(), testReportResponseBER.getUnsynchrFrames());
            }
        } else if (this.myTestType.equals("testModelWimax")) {
            if (!testReportResponseBER.isATMResponding()) {
                this.myTestReportListener.testReportBERReceivedBBNotResponding(this.myLcrId);
            } else {
                this.myTestReportListener.testReportBERWimaxReceived(this.myLcrId, testReportResponseBER.getBerPercentage(), testReportResponseBER.getPerPercentage(), testReportResponseBER.getSyncState(), testReportResponseBER.getReceivedBits(), testReportResponseBER.getDefectedBits(), testReportResponseBER.getReceivedPackets(), testReportResponseBER.getDefectedPackets());
            }
        }
        if (this.isLastTeReportRequestSent && !this.isStopTestSent) {
            this.sendStopTestRequest(this.mySeqNumber);
            this.isLastTeReportRequestSent = false;
        }
    }

    private void processReportResponseLTE(TestReportResponseLTEUL testReportResponse) {
        try {
            if (this.myTestType.equals("testModelLTEUpLinkTP")) {
                this.myTestReportListener.testReportBERLTETPReceived(testReportResponse.getResultStatus(), this.myLcrId, testReportResponse.getThroughputPercentage(), testReportResponse.getReceivedBits(), testReportResponse.getDefectedBits(), testReportResponse.getReceivedBlocks(), testReportResponse.getUnreceivedBlocks());
            } else if (this.myTestType.equals("testModelLTEUpLinkCCM")) {
                this.myTestReportListener.testReportBERLTECCMReceived(testReportResponse.getResultStatus(), this.myLcrId, testReportResponse.getAckPaDetectedPercentage(), testReportResponse.getFalseAckPaPercentage(), testReportResponse.getAckPaDetected(), testReportResponse.getAckPaMissed(), testReportResponse.getFalseAckPa(), testReportResponse.getIdlePeriod());
            }
        }
        catch (Exception exception) {
            this.myLogger.error((Object)"Process testModelLTEUpLinkTP or testModelLTEUpLinkCCM error ", (Throwable)exception);
        }
        if (this.isLastTeReportRequestSent && !this.isStopTestSent) {
            this.sendStopTestRequest(this.mySeqNumber);
            this.isLastTeReportRequestSent = false;
        }
    }

    private void sendStopTestRequest(int intSeqNumber) {
        this.myBTSConnection.sendToBTS((BTSMessage)new StopTestRequest(intSeqNumber, this.myTestType));
        this.myLogger.debug((Object)"StopTestRequest sent");
        this.startStopTestTimer();
        this.isStopTestSent = true;
    }

    private void startStopTestTimer() {
        this.myStopTestTimeoutTimer = new Timer(200000, null);
        this.myStopTestTimeoutTimer.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                BerTestScenario.this.isStopTestSent = false;
                BerTestScenario.this.myTestListener.testAborted(BerTestScenario.this.myLcrId, 68);
            }
        });
        this.myStopTestTimeoutTimer.setRepeats(false);
        this.myStopTestTimeoutTimer.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 85);
            return true;
        }
        this.mySeqNumber = this.myBTSConnection.createScenario();
        StartTestRequest startTestRequest = new StartTestRequest(this.mySeqNumber, this.myTestType, this.myTestParameters, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)startTestRequest);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 200000L);
        if (response instanceof StartTestResponse) {
            StartTestResponse startResponse = (StartTestResponse)response;
            if (startResponse.getSuccessCode() != 34) {
                this.sendTestStartFailed(startResponse.getSuccessCode());
                return false;
            }
            this.myActiveTestsHandler.addTestScenario(this, this.mySeqNumber);
            BtsTest thisTest = new BtsTest(this.myTestType, this.mySeqNumber, true, this.myLcrId);
            this.myActiveTest.addActiveTest(thisTest);
            this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 1);
            if (this.myDuration > 0) {
                this.startTestDurationTimer();
            }
            if (this.myInterval > 0) {
                if (this.isSendReportRequest) {
                    TimerService.getInstance().startTimer(System.currentTimeMillis(), this.myIntervalsTestIntervalActionListener, (long)(this.myInterval * 1000), false, 0, true);
                }
            } else {
                this.myLogger.debug((Object)("Warning: reporting interval in cell " + this.myLcrId + " defined to value  " + this.myInterval));
            }
            while (true) {
                if ((response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber)) instanceof StopTestResponse && this.isStopTestSent) {
                    this.myLogger.debug((Object)"StopTestResponse received");
                    StopTestResponse stopTestResponse = (StopTestResponse)response;
                    if (this.myIntervalsTestIntervalActionListener != null) {
                        TimerService.getInstance().stopTimer(this.myIntervalsTestIntervalActionListener);
                    }
                    this.myStopTestTimeoutTimer.stop();
                    this.sendTestAborted(stopTestResponse.getSuccessCode());
                    this.myActiveTestsHandler.stopRequestFinished(this.mySeqNumber, stopTestResponse.getSuccessCode());
                    if (stopTestResponse.getSuccessCode() == 34 || stopTestResponse.getSuccessCode() == 39) {
                        this.myLogger.debug((Object)("terminate thread myLcrId " + this.myLcrId + ", mySeqNumber " + this.mySeqNumber));
                        this.myActiveTest.removeActiveTest(this.mySeqNumber);
                        return true;
                    }
                    this.myLogger.debug((Object)("re-activate test myLcrId " + this.myLcrId + ", mySeqNumber " + this.mySeqNumber));
                    this.myActiveTest.addActiveTest(thisTest);
                    this.isStopTestSent = false;
                    continue;
                }
                if (response instanceof TestReportResponseBER) {
                    this.processReportResponse((TestReportResponseBER)response);
                    continue;
                }
                if (response instanceof TestReportResponseLTEUL) {
                    this.processReportResponseLTE((TestReportResponseLTEUL)response);
                    continue;
                }
                if (response == null) break;
            }
            if (this.myIntervalsTestIntervalActionListener != null) {
                TimerService.getInstance().stopTimer(this.myIntervalsTestIntervalActionListener);
            }
            this.myActiveTest.removeActiveTest(this.mySeqNumber);
            this.myTestListener.testAborted(this.myLcrId, 1);
            return true;
        }
        if (response instanceof Timeout) {
            this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 68);
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. StartTestResponse expected.");
            this.myTestListener.testModelStarted(this.myTestType, this.myLcrId, 28);
        }
        return false;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    @Override
    public void stopTest() {
        this.abort();
    }
}

