/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ResetRequest;
import com.nokia.em.bts.coreasset.message.TestDedicatedStateRequest;
import com.nokia.em.bts.coreasset.message.TestDedicatedStateResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.ResetListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ResetToTestDedicatedStateScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private ResetListener myResetListener;
    private Boolean myResetFull;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private static final int RETRY_MAX = 2;
    private static final int RESET_INTERVAL = 10000;
    private int myCurrentRetry = 0;

    public ResetToTestDedicatedStateScenario(BTSConnection connection, ResetListener resetListener, Boolean resetFull) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myResetFull = resetFull;
        this.myResetListener = resetListener;
    }

    public ResetToTestDedicatedStateScenario(BTSConnection connection, ResetListener resetListener, Boolean resetFull, BTSMessage.Type type) {
        this(connection, resetListener, resetFull);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){
            int intSeqNumber;

            protected Object construct() {
                block22: {
                    BTSMessage response;
                    block21: {
                        if (CoreAsset.isSnapshotOpening()) {
                            ResetToTestDedicatedStateScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                ResetToTestDedicatedStateScenario.this.myLogger.debug((Object)"Sleep interrupted.", (Throwable)e);
                            }
                            ResetToTestDedicatedStateScenario.this.myResetListener.initializingFailed(85);
                            return false;
                        }
                        this.intSeqNumber = ResetToTestDedicatedStateScenario.this.myBTSConnection.createScenario();
                        TestDedicatedStateRequest testDedicatedStateRequest = new TestDedicatedStateRequest(this.intSeqNumber, ResetToTestDedicatedStateScenario.this.myType);
                        ResetToTestDedicatedStateScenario.this.myBTSConnection.sendToBTS((BTSMessage)testDedicatedStateRequest);
                        response = ResetToTestDedicatedStateScenario.this.myBTSConnection.receiveFromBTS(this.intSeqNumber, 480000L);
                        if (!(response instanceof TestDedicatedStateResponse)) break block21;
                        TestDedicatedStateResponse testDedicatedStateResponse = (TestDedicatedStateResponse)response;
                        int intNextStep = testDedicatedStateResponse.getNextStep();
                        int intStartingCounter = 0;
                        while (intNextStep == 52) {
                            if (intStartingCounter == 0 && intNextStep == 52) {
                                ++intStartingCounter;
                                ResetToTestDedicatedStateScenario.this.myResetListener.initializingCompleted(52);
                            }
                            if ((response = ResetToTestDedicatedStateScenario.this.myBTSConnection.receiveFromBTS(this.intSeqNumber, 480000L)) instanceof TestDedicatedStateResponse) {
                                testDedicatedStateResponse = (TestDedicatedStateResponse)response;
                                intNextStep = testDedicatedStateResponse.getNextStep();
                                continue;
                            }
                            if (response instanceof Timeout) {
                                ResetToTestDedicatedStateScenario.this.myLogger.debug((Object)"Second TestDedicatedStateResponse has timeouted ");
                                ResetToTestDedicatedStateScenario.this.myResetListener.initializingFailed(68);
                                return false;
                            }
                            ResetToTestDedicatedStateScenario.this.myLogger.error((Object)"Wrong reply received from BTS. TestDedicatedStateResponse expected.");
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                ResetToTestDedicatedStateScenario.this.myLogger.debug((Object)"Response wait interrupted.", (Throwable)e);
                            }
                        }
                        block3 : switch (intNextStep) {
                            case 53: {
                                ResetToTestDedicatedStateScenario.this.myResetListener.initializingCompleted(53);
                                break;
                            }
                            case 51: {
                                while (ResetToTestDedicatedStateScenario.this.myCurrentRetry <= 2) {
                                    this.intSeqNumber = ResetToTestDedicatedStateScenario.this.myBTSConnection.createScenario();
                                    ResetRequest resetRequest = new ResetRequest(this.intSeqNumber, ResetToTestDedicatedStateScenario.this.myResetFull);
                                    ResetToTestDedicatedStateScenario.this.myBTSConnection.sendToBTS((BTSMessage)resetRequest);
                                    response = ResetToTestDedicatedStateScenario.this.myBTSConnection.receiveFromBTS(this.intSeqNumber, 480000L);
                                    if (response instanceof Ack || response == null) {
                                        if (response != null && !((Ack)response).getAck()) {
                                            ResetToTestDedicatedStateScenario resetToTestDedicatedStateScenario = ResetToTestDedicatedStateScenario.this;
                                            resetToTestDedicatedStateScenario.myCurrentRetry = resetToTestDedicatedStateScenario.myCurrentRetry + 1;
                                            if (ResetToTestDedicatedStateScenario.this.myCurrentRetry > 2) {
                                                Ack ackResponse = (Ack)response;
                                                ResetToTestDedicatedStateScenario.this.myResetListener.resetFailed(ackResponse.getNackReason());
                                                break block3;
                                            }
                                            try {
                                                Thread.sleep(10000L);
                                            }
                                            catch (InterruptedException e) {
                                                ResetToTestDedicatedStateScenario.this.myLogger.debug((Object)"Reset retry sleep interrupted.", (Throwable)e);
                                            }
                                            continue;
                                        }
                                        ResetToTestDedicatedStateScenario.this.myResetListener.initializingCompleted(51);
                                        ResetToTestDedicatedStateScenario.this.myResetListener.resetStarted();
                                        break block3;
                                    }
                                    if (response instanceof Timeout) {
                                        ResetToTestDedicatedStateScenario.this.myLogger.debug((Object)"Test Dedicated State reset has timeouted ");
                                        ResetToTestDedicatedStateScenario.this.myResetListener.initializingFailed(68);
                                        return false;
                                    }
                                    ResetToTestDedicatedStateScenario.this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
                                    ResetToTestDedicatedStateScenario.this.myResetListener.resetFailed(30);
                                    break block3;
                                }
                                break block22;
                            }
                            default: {
                                ResetToTestDedicatedStateScenario.this.myLogger.debug((Object)("Default " + intNextStep));
                                ResetToTestDedicatedStateScenario.this.myResetListener.initializingFailed(37);
                                break;
                            }
                        }
                        break block22;
                    }
                    if (response instanceof Timeout) {
                        ResetToTestDedicatedStateScenario.this.myLogger.debug((Object)"TestDedicatedStateResponse has timeouted ");
                        ResetToTestDedicatedStateScenario.this.myResetListener.initializingFailed(68);
                        return false;
                    }
                    ResetToTestDedicatedStateScenario.this.myLogger.error((Object)"Wrong reply received from BTS. TestDedicatedStateResponse expected.");
                    ResetToTestDedicatedStateScenario.this.myResetListener.initializingFailed(28);
                    return false;
                }
                return true;
            }

            protected void finished() {
                ResetToTestDedicatedStateScenario.this.myBTSConnection.deleteScenario(this.intSeqNumber);
                ResetToTestDedicatedStateScenario.this.myCurrentRetry = 0;
                ResetToTestDedicatedStateScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"Scenario cannot be aborted.");
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

