/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.message.RadParamsSetRequest;
import com.nokia.em.bts.coreasset.message.RadParamsSetResponse;
import com.nokia.em.bts.coreasset.message.SetEstLevelRequest;
import com.nokia.em.bts.coreasset.message.SetEstLevelResponse;
import com.nokia.em.bts.coreasset.scenario.btstests.SelfTestListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParam;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SelfTestBaseScenario {
    protected static final long DSP_POST_FLAG_KEY = 427L;
    protected static final String RAD_SETTING_TYPE = "factoryDefaults";
    protected BTSConnection myConnection;
    protected SelfTestListener mySelfTestListener;
    protected String myBtsSwSC;
    protected int mySeqNumber;
    protected Logger myLogger;
    private boolean myRunning = false;
    private Object myRunningLock = new Object();
    private boolean myAbort = false;
    private Object myAbortLock = new Object();

    protected SelfTestBaseScenario(BTSConnection connection, SelfTestListener selfTestListener, String btsSwSC) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.mySelfTestListener = selfTestListener;
        this.myBtsSwSC = btsSwSC;
    }

    protected boolean restoreTestLevel() {
        return this.processSetEstLevelMessages(false);
    }

    protected boolean restoreTestLevelAndRadParams(long dspPostFlag, boolean isInvokeListenerOnError) {
        boolean retVal = this.processSetEstLevelMessages(isInvokeListenerOnError);
        if (!retVal) {
            return false;
        }
        retVal = this.processRadParamsSetMessages(dspPostFlag, isInvokeListenerOnError);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIsAbort(boolean value) {
        Object object = this.myAbortLock;
        synchronized (object) {
            this.myAbort = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAbort() {
        Object object = this.myAbortLock;
        synchronized (object) {
            return this.myAbort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIsRunning(boolean value) {
        Object object = this.myRunningLock;
        synchronized (object) {
            this.myRunning = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRunning() {
        Object object = this.myRunningLock;
        synchronized (object) {
            return this.myRunning;
        }
    }

    private boolean processSetEstLevelMessages(boolean isInvokeListenerOnError) {
        this.mySeqNumber = this.myConnection.createScenario();
        SetEstLevelRequest setEstLevelRequest = new SetEstLevelRequest(this.mySeqNumber, SelfTestListener.DSPPostFlag.OFF.getTestLevelString());
        this.myConnection.sendToBTS((BTSMessage)setEstLevelRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"SetEstLevelResponse has timed out.");
            if (isInvokeListenerOnError) {
                this.mySelfTestListener.selfTestTestingFailed(68);
            }
            return false;
        }
        if (!(response instanceof SetEstLevelResponse)) {
            this.myLogger.error((Object)"Wrong reply received from BTS. SetEstLevelResponse expected.");
            if (isInvokeListenerOnError) {
                this.mySelfTestListener.selfTestTestingFailed(30);
            }
            return false;
        }
        SetEstLevelResponse setEstLevelResponse = (SetEstLevelResponse)response;
        if (setEstLevelResponse.getSuccessCode() != 36) {
            this.myLogger.error((Object)"SetEstLevelResponse failed.");
            if (isInvokeListenerOnError) {
                this.mySelfTestListener.selfTestTestingFailed(30);
            }
            return false;
        }
        this.myLogger.debug((Object)"SetEstLevelResponse successful.");
        return true;
    }

    private boolean processRadParamsSetMessages(long dspPostFlag, boolean isInvokeListenerOnError) {
        this.mySeqNumber = this.myConnection.createScenario();
        RadParam radParam = new RadParam(427L, dspPostFlag, this.myBtsSwSC);
        ArrayList<RadParam> radParamList = new ArrayList<RadParam>();
        radParamList.add(radParam);
        RadParamsSetRequest radParamsSetRequest = new RadParamsSetRequest(this.mySeqNumber, this.myBtsSwSC, RAD_SETTING_TYPE, radParamList);
        this.myConnection.sendToBTS((BTSMessage)radParamsSetRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"RadParamsSetResponse has timed out.");
            if (isInvokeListenerOnError) {
                this.mySelfTestListener.selfTestTestingFailed(68);
            }
            return false;
        }
        if (!(response instanceof RadParamsSetResponse)) {
            this.myLogger.error((Object)"Wrong reply received from BTS. RadParamsSetResponse expected.");
            if (isInvokeListenerOnError) {
                this.mySelfTestListener.selfTestTestingFailed(30);
            }
            return false;
        }
        RadParamsSetResponse radParamsSetResponse = (RadParamsSetResponse)response;
        if (radParamsSetResponse.getSuccess() != 36) {
            this.myLogger.error((Object)"RadParamsSetResponse failed.");
            if (isInvokeListenerOnError) {
                this.mySelfTestListener.selfTestTestingFailed(30);
            }
            return false;
        }
        this.myLogger.debug((Object)"RadParamsSetResponse successful.");
        return true;
    }
}

