/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ESTModuleTestResultNotif;
import com.nokia.em.bts.coreasset.message.RadParamsGetRequest;
import com.nokia.em.bts.coreasset.message.RadParamsGetResponse;
import com.nokia.em.bts.coreasset.message.RadParamsSetRequest;
import com.nokia.em.bts.coreasset.message.RadParamsSetResponse;
import com.nokia.em.bts.coreasset.message.ResetRequest;
import com.nokia.em.bts.coreasset.message.SetEstLevelRequest;
import com.nokia.em.bts.coreasset.message.SetEstLevelResponse;
import com.nokia.em.bts.coreasset.message.TestCompletedNotif;
import com.nokia.em.bts.coreasset.message.TestDedicatedStateRequest;
import com.nokia.em.bts.coreasset.message.TestDedicatedStateResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.SelfTest;
import com.nokia.em.bts.coreasset.scenario.btstests.SelfTestBaseScenario;
import com.nokia.em.bts.coreasset.scenario.btstests.SelfTestListener;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParam;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelfTestInitScenario
extends SelfTestBaseScenario
implements Scenario,
SnapshotSaver {
    private SelfTestListener.DSPPostFlag myTestLevel;
    private long myDSPPostFlag = -1L;
    private SelfTest mySelfTest = SelfTest.getInstance();
    private static final String SNAPSHOT_TASK = "SelfTests";
    private static final String SNAPSHOT_TASK_NAME = "CoreAsset_Snapshot_SelfTests";
    private static final int SNAPSHOT_TIMEOUT = 10000;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SelfTestInitScenario(BTSConnection connection, SelfTestListener selfTestListener, SelfTestListener.DSPPostFlag testLevel, String btsSwSC) {
        super(connection, selfTestListener, btsSwSC);
        this.myTestLevel = testLevel;
    }

    public SelfTestInitScenario(BTSConnection connection, SelfTestListener selfTestListener, SelfTestListener.DSPPostFlag testLevel, String btsSwSC, BTSMessage.Type type) {
        super(connection, selfTestListener, btsSwSC);
        this.myTestLevel = testLevel;
        this.myType = type;
    }

    public long getDSPPostFlag() {
        return this.myDSPPostFlag;
    }

    private Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Opening snapshot file.");
            this.openSnapshot();
            return true;
        }
        this.mySelfTestListener.selfTestInitStarted();
        this.mySelfTest.setStep(SelfTestListener.SelfTestStep.INITIALIZING_STARTED);
        if (this.isAbort()) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.INITIALIZING_STOPPED);
            return false;
        }
        boolean retVal = this.processSetEstLevelMessages(this.myTestLevel.getTestLevelString());
        if (!retVal) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.INITIALIZING_FAILED);
            return retVal;
        }
        if (this.isAbort()) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.INITIALIZING_STOPPED);
            this.restoreTestLevel();
            return false;
        }
        retVal = this.processRadParamsGetMessages();
        if (!retVal) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.INITIALIZING_FAILED);
            this.restoreTestLevel();
            return retVal;
        }
        if (this.isAbort()) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.INITIALIZING_STOPPED);
            this.restoreTestLevel();
            return false;
        }
        retVal = this.processRadParamsSetMessages(this.myTestLevel);
        if (!retVal) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.INITIALIZING_FAILED);
            this.restoreTestLevel();
            return retVal;
        }
        this.mySelfTestListener.selfTestInitCompleted();
        this.mySelfTest.setStep(SelfTestListener.SelfTestStep.INITIALIZING_COMPLETED);
        this.mySelfTestListener.selfTestResetStarted();
        this.mySelfTest.setStep(SelfTestListener.SelfTestStep.RESETTING_STARTED);
        if (this.isAbort()) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.RESETTING_STOPPED);
            this.restoreTestLevelAndRadParams(this.myDSPPostFlag, false);
            return false;
        }
        retVal = this.processTestDedicatedStateMessages();
        if (!retVal) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.RESETTING_FAILED);
            this.restoreTestLevelAndRadParams(this.myDSPPostFlag, false);
            return retVal;
        }
        if (this.isAbort()) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.RESETTING_STOPPED);
            this.restoreTestLevelAndRadParams(this.myDSPPostFlag, false);
            return false;
        }
        retVal = this.processResetMessages();
        if (!retVal) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.RESETTING_FAILED);
            this.restoreTestLevelAndRadParams(this.myDSPPostFlag, false);
        }
        return retVal;
    }

    private void openSnapshot() {
        URL url = CoreAsset.getSnapshotOpenLocation();
        if (url == null) {
            this.myLogger.error((Object)"CoreAsset.getSnapshotOpenLocation() returns null.");
            return;
        }
        String selfTestFile = String.valueOf(url.getFile()) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + ".xml";
        Element xmlNode = Tools.parseElement((String)selfTestFile);
        if (xmlNode != null) {
            Node node;
            NodeList nodeList = xmlNode.getOwnerDocument().getElementsByTagName("ESTModuleTestResultNotif");
            int index = 0;
            while (index < nodeList.getLength()) {
                node = nodeList.item(index);
                try {
                    ESTModuleTestResultNotif moduleTestResult = new ESTModuleTestResultNotif(0, node);
                    this.mySelfTestListener.selfTestPartialResult(moduleTestResult.getUnitId(), moduleTestResult.getTestVerdict());
                }
                catch (Exception ex) {
                    this.myLogger.warn((Object)"ESTModuleTestResultNotif message cannot be loaded from snapshot.");
                }
                ++index;
            }
            nodeList = xmlNode.getOwnerDocument().getElementsByTagName("TestCompletedNotif");
            if (nodeList.getLength() > 0) {
                Node node2 = nodeList.item(0);
                try {
                    TestCompletedNotif testCompletedNotif = new TestCompletedNotif(0, node2);
                    this.mySelfTestListener.selfTestOverallTestResult(testCompletedNotif.getOverallTestResult());
                }
                catch (Exception ex) {
                    this.myLogger.warn((Object)"TestCompletedNotif message cannot be loaded from snapshot.");
                }
            }
            String testLevel = "";
            nodeList = xmlNode.getOwnerDocument().getElementsByTagName("TestLevel");
            if (nodeList.getLength() > 0) {
                node = nodeList.item(0);
                testLevel = node.getTextContent();
            }
            SelfTestListener.SelfTestStep selfTestStep = SelfTestListener.SelfTestStep.NOT_STARTED;
            nodeList = xmlNode.getOwnerDocument().getElementsByTagName("SelfTestStep");
            if (nodeList.getLength() > 0) {
                Node node3 = nodeList.item(0);
                String nodeValue = node3.getTextContent();
                SelfTestListener.SelfTestStep[] selfTestStepArray = SelfTestListener.SelfTestStep.values();
                int n = selfTestStepArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SelfTestListener.SelfTestStep step = selfTestStepArray[n2];
                    if (step.toString().equalsIgnoreCase(nodeValue)) {
                        selfTestStep = step;
                    }
                    ++n2;
                }
            }
            int elapsedTime = 0;
            nodeList = xmlNode.getOwnerDocument().getElementsByTagName("ElapsedTime");
            if (nodeList.getLength() > 0) {
                Node node4 = nodeList.item(0);
                elapsedTime = new Integer(node4.getTextContent());
            }
            this.mySelfTestListener.selfTestOpenSnapshot(testLevel, selfTestStep, elapsedTime);
        }
    }

    private boolean processSetEstLevelMessages(String testLevel) {
        this.mySeqNumber = this.myConnection.createScenario();
        SetEstLevelRequest setEstLevelRequest = new SetEstLevelRequest(this.mySeqNumber, testLevel);
        this.myConnection.sendToBTS((BTSMessage)setEstLevelRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"SetEstLevelResponse has timed out.");
            this.mySelfTestListener.selfTestInitFailed(68);
            return false;
        }
        if (!(response instanceof SetEstLevelResponse)) {
            this.myLogger.error((Object)"Wrong reply received from BTS. SetEstLevelResponse expected.");
            this.mySelfTestListener.selfTestInitFailed(28);
            return false;
        }
        this.mySelfTest.setTestLevel(testLevel);
        CoreAsset.addSnapshotSaver(this);
        SetEstLevelResponse setEstLevelResponse = (SetEstLevelResponse)response;
        if (setEstLevelResponse.getSuccessCode() != 36) {
            this.myLogger.error((Object)"SetEstLevelResponse failed.");
            this.mySelfTestListener.selfTestInitFailed(37);
            return false;
        }
        this.myLogger.debug((Object)"SetEstLevelResponse successful.");
        return true;
    }

    private boolean processRadParamsGetMessages() {
        this.mySeqNumber = this.myConnection.createScenario();
        RadParamsGetRequest radParamsGetRequest = new RadParamsGetRequest(this.mySeqNumber, this.myBtsSwSC, this.myType);
        this.myConnection.sendToBTS((BTSMessage)radParamsGetRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"RadParamsGetResponse has timed out.");
            this.mySelfTestListener.selfTestInitFailed(68);
            return false;
        }
        if (!(response instanceof RadParamsGetResponse)) {
            this.myLogger.error((Object)"Wrong reply received from BTS. RadParamsGetResponse expected.");
            this.mySelfTestListener.selfTestInitFailed(28);
            return false;
        }
        RadParamsGetResponse radParamsGetResponse = (RadParamsGetResponse)response;
        Map<Long, Long> radParams = radParamsGetResponse.getRadParams();
        if (!radParams.containsKey(427L)) {
            this.myLogger.error((Object)"RadParamsGetResponse does not contain parameter 427.");
            this.mySelfTestListener.selfTestInitFailed(28);
            return false;
        }
        this.myDSPPostFlag = radParamsGetResponse.getRadParams().get(427L);
        this.myLogger.debug((Object)("SetEstLevelResponse successful. myDSPPostFlag=[" + this.myDSPPostFlag + "]"));
        return true;
    }

    private boolean processRadParamsSetMessages(SelfTestListener.DSPPostFlag testLevel) {
        this.mySeqNumber = this.myConnection.createScenario();
        SelfTestListener.DSPPostFlag[] postFlagArray = SelfTestListener.DSPPostFlag.values();
        int index = 0;
        while (index < postFlagArray.length) {
            if (testLevel.getTestLevel() == postFlagArray[index].getTestLevel()) break;
            ++index;
        }
        RadParam radParam = new RadParam(427L, postFlagArray[index].getParamValue(), this.myBtsSwSC);
        ArrayList<RadParam> radParamList = new ArrayList<RadParam>();
        radParamList.add(radParam);
        RadParamsSetRequest radParamsSetRequest = new RadParamsSetRequest(this.mySeqNumber, this.myBtsSwSC, "factoryDefaults", radParamList);
        this.myConnection.sendToBTS((BTSMessage)radParamsSetRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"RadParamsSetResponse has timed out.");
            this.mySelfTestListener.selfTestInitFailed(68);
            return false;
        }
        if (!(response instanceof RadParamsSetResponse)) {
            this.myLogger.error((Object)"Wrong reply received from BTS. RadParamsSetResponse expected.");
            this.mySelfTestListener.selfTestInitFailed(28);
            return false;
        }
        RadParamsSetResponse radParamsSetResponse = (RadParamsSetResponse)response;
        if (radParamsSetResponse.getSuccess() != 36) {
            this.myLogger.error((Object)"RadParamsSetResponse failed.");
            this.mySelfTestListener.selfTestInitFailed(37);
            return false;
        }
        this.myLogger.debug((Object)"RadParamsSetResponse successful.");
        return true;
    }

    private boolean processTestDedicatedStateMessages() {
        this.mySeqNumber = this.myConnection.createScenario();
        TestDedicatedStateRequest testDedicatedStateRequest = new TestDedicatedStateRequest(this.mySeqNumber);
        this.myConnection.sendToBTS((BTSMessage)testDedicatedStateRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 480000L);
        if (response instanceof Timeout) {
            this.myLogger.error((Object)"TestDedicatedStateRequest timed out.");
            this.mySelfTestListener.selfTestResetFailed(68);
            return false;
        }
        if (!(response instanceof TestDedicatedStateResponse)) {
            this.myLogger.error((Object)"Wrong reply received from BTS. TestDedicatedStateResponse expected.");
            this.mySelfTestListener.selfTestResetFailed(28);
            return false;
        }
        TestDedicatedStateResponse testDedicatedStateResponse = (TestDedicatedStateResponse)response;
        int intNextStep = testDedicatedStateResponse.getNextStep();
        int intStartingCounter = 0;
        while (intNextStep == 52) {
            if (intStartingCounter == 0 && intNextStep == 52) {
                ++intStartingCounter;
            }
            if ((response = this.myConnection.receiveFromBTS(this.mySeqNumber, 480000L)) instanceof TestDedicatedStateResponse) {
                testDedicatedStateResponse = (TestDedicatedStateResponse)response;
                intNextStep = testDedicatedStateResponse.getNextStep();
                continue;
            }
            if (response instanceof Timeout) {
                this.myLogger.debug((Object)"Second TestDedicatedStateResponse has timed out.");
                this.mySelfTestListener.selfTestResetFailed(68);
                return false;
            }
            this.myLogger.error((Object)"Wrong reply received from BTS. TestDedicatedStateResponse expected.");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.myLogger.debug((Object)"TestDedicatedStateResponse successful.");
        return true;
    }

    private boolean processResetMessages() {
        this.mySeqNumber = this.myConnection.createScenario();
        ResetRequest resetRequest = new ResetRequest(this.mySeqNumber, true);
        this.myConnection.sendToBTS((BTSMessage)resetRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Ack || response == null) {
            if (response != null && !((Ack)response).getAck()) {
                Ack ackResponse = (Ack)response;
                this.mySelfTestListener.selfTestResetFailed(ackResponse.getNackReason());
                return false;
            }
        } else {
            if (response instanceof Timeout) {
                this.myLogger.error((Object)"ResetRequest timed out.");
                this.mySelfTestListener.selfTestResetFailed(68);
                return false;
            }
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
            this.mySelfTestListener.selfTestResetFailed(28);
            return false;
        }
        this.myLogger.debug((Object)"Reset successful.");
        return true;
    }

    private String getData() {
        StringBuilder sb = new StringBuilder("<SelfTests>");
        String testLevel = this.mySelfTest.getTestLevel();
        sb.append("<TestLevel>").append(testLevel).append("</TestLevel>");
        List<ESTModuleTestResultNotif> moduleTestResultList = this.mySelfTest.getModuleTestResult();
        Iterator<ESTModuleTestResultNotif> iterator = moduleTestResultList.iterator();
        while (iterator.hasNext()) {
            ESTModuleTestResultNotif moduleTestResult;
            ESTModuleTestResultNotif moduleResult = moduleTestResult = iterator.next();
            sb.append("<ESTModuleTestResultNotif>");
            sb.append("<_seqNumber>").append(moduleResult.getSeqNbr()).append("</_seqNumber>");
            sb.append("<_unitId>").append(moduleResult.getUnitId()).append("</_unitId>");
            sb.append("<_testVerdict>").append(moduleResult.getTestVerdictString()).append("</_testVerdict>");
            sb.append("</ESTModuleTestResultNotif>");
        }
        TestCompletedNotif testCompletedNotif = this.mySelfTest.getOverallTestResult();
        if (testCompletedNotif != null) {
            sb.append("<TestCompletedNotif>");
            sb.append("<_seqNumber>").append(testCompletedNotif.getSeqNbr()).append("</_seqNumber>");
            sb.append("<_testVerdict>").append(testCompletedNotif.getOverallTestResultString()).append("</_testVerdict>");
            sb.append("</TestCompletedNotif>");
        }
        SelfTestListener.SelfTestStep selftestStep = this.mySelfTest.getStep();
        sb.append("<SelfTestStep>").append(selftestStep.toString()).append("</SelfTestStep>");
        int elapsedTime = this.mySelfTest.getElapsedTime();
        sb.append("<ElapsedTime>").append(elapsedTime).append("</ElapsedTime>");
        sb.append("</SelfTests>");
        return sb.toString();
    }

    @Override
    public void execute() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.setIsRunning(true);
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return SelfTestInitScenario.this.runScenario();
            }

            protected void finished() {
                SelfTestInitScenario.this.myConnection.deleteScenario(SelfTestInitScenario.this.mySeqNumber);
                SelfTestInitScenario.this.setIsAbort(false);
                SelfTestInitScenario.this.setIsRunning(false);
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.setIsAbort(true);
        return true;
    }

    public Collection getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL snapshot_level) {
        ArrayList<String> savingTasks = new ArrayList<String>();
        savingTasks.add(SNAPSHOT_TASK_NAME);
        return savingTasks;
    }

    public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL snapshot_level, final SaverProgressListener sp) {
        this.mySelfTestListener.selfTestSaveSnapshot();
        CoreAssetThread worker = new CoreAssetThread(){

            public Object construct() {
                SelfTestInitScenario.this.runSave(url, sp);
                return null;
            }
        };
        worker.start();
    }

    private void runSave(String url, SaverProgressListener sp) {
        block11: {
            try {
                sp.taskStarted(SNAPSHOT_TASK_NAME, 7, 10000, this.isLocalisationRequired());
                File dir = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK);
                if (!dir.mkdir()) {
                    this.myLogger.warn((Object)"Failed to create self tests snapshot directory");
                }
                File f = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + ".xml");
                OutputStreamWriter out = null;
                try {
                    try {
                        out = new OutputStreamWriter(new FileOutputStream(f, false));
                        out.write(this.getData());
                    }
                    catch (Exception e) {
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                        this.myLogger.error((Object)"Failed to save self tests snapshot file", (Throwable)e);
                        if (out != null) {
                            out.close();
                            sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        out.close();
                        sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                    }
                    throw throwable;
                }
                if (out != null) {
                    out.close();
                    sp.taskUpdated(SNAPSHOT_TASK_NAME, 8, this.isLocalisationRequired());
                }
            }
            catch (Exception e) {
                sp.taskUpdated(SNAPSHOT_TASK_NAME, 4, this.isLocalisationRequired());
                this.myLogger.error((Object)"Failed to save self tests snapshot data", (Throwable)e);
            }
        }
        sp.saveCompleted((SnapshotSaver)this);
    }

    public void cancel(SaverProgressListener sp) {
        sp.saveCancelled((SnapshotSaver)this);
    }

    public int getSavingPriority() {
        return 2;
    }

    public void stopProcess(int process) {
    }

    public boolean isLocalisationRequired() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

