/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.message.ESTModuleTestResultNotif;
import com.nokia.em.bts.coreasset.message.StartTestRequest;
import com.nokia.em.bts.coreasset.message.StartTestResponse;
import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.message.TestCompletedNotif;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.SelfTest;
import com.nokia.em.bts.coreasset.scenario.btstests.SelfTestBaseScenario;
import com.nokia.em.bts.coreasset.scenario.btstests.SelfTestListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;

public class SelfTestTestingScenario
extends SelfTestBaseScenario
implements Scenario {
    private boolean myIsSendStopRequest = false;
    private Object myIsSendStopRequestLock = new Object();
    private long myDSPPostFlag = -1L;
    private int myRetryCount = 0;
    private SelfTest mySelfTest = SelfTest.getInstance();
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SelfTestTestingScenario(BTSConnection connection, SelfTestListener selfTestListener, long postFlag, String btsSwSC) {
        super(connection, selfTestListener, btsSwSC);
        this.myDSPPostFlag = postFlag;
    }

    public SelfTestTestingScenario(BTSConnection connection, SelfTestListener selfTestListener, long postFlag, String btsSwSC, BTSMessage.Type type) {
        this(connection, selfTestListener, postFlag, btsSwSC);
        this.myType = type;
    }

    private Object runScenario() {
        this.mySelfTestListener.selfTestResetCompleted();
        this.mySelfTest.setStep(SelfTestListener.SelfTestStep.RESETTING_COMPLETED);
        boolean retVal = this.processStartTestMessages();
        if (!retVal) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.TESTING_FAILED);
            this.restoreTestLevelAndRadParams(this.myDSPPostFlag, false);
            return retVal;
        }
        this.setCanSendStopRequest(true);
        this.mySelfTestListener.selfTestTestingStarted();
        this.mySelfTest.setStep(SelfTestListener.SelfTestStep.TESTING_STARTED);
        retVal = this.processResultCollection();
        if (!retVal) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.TESTING_FAILED);
            this.restoreTestLevelAndRadParams(this.myDSPPostFlag, false);
            return retVal;
        }
        this.setCanSendStopRequest(false);
        retVal = this.restoreTestLevelAndRadParams(this.myDSPPostFlag, true);
        if (!retVal) {
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.REST_OR_ATION_FAILED);
            return retVal;
        }
        if (this.isAbort()) {
            this.mySelfTestListener.selfTestAbortCompleted();
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.TESTING_STOPPED);
        } else {
            this.mySelfTestListener.selfTestTestingCompleted();
            this.mySelfTest.setStep(SelfTestListener.SelfTestStep.TESTING_COMPLETED);
        }
        return retVal;
    }

    private boolean processStartTestMessages() {
        this.mySeqNumber = this.myConnection.createScenario();
        StartTestRequest startTestRequest = new StartTestRequest(this.mySeqNumber, "est", this.myType);
        this.myConnection.sendToBTS((BTSMessage)startTestRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"StartTestResponse has timed out.");
            this.mySelfTestListener.selfTestTestingFailed(68);
            return false;
        }
        if (!(response instanceof StartTestResponse)) {
            this.myLogger.error((Object)"Wrong reply received from BTS. StartTestResponse expected.");
            this.mySelfTestListener.selfTestTestingFailed(28);
            return false;
        }
        StartTestResponse startTestResponse = (StartTestResponse)response;
        if (startTestResponse.getSuccessCode() != 34) {
            this.myLogger.error((Object)("StartTestResponse failed. Success code=[" + startTestResponse.getSuccessCode() + "]"));
            this.mySelfTestListener.selfTestTestingFailed(startTestResponse.getSuccessCode());
            return false;
        }
        this.myLogger.debug((Object)"StartTestResponse successful.");
        return true;
    }

    private boolean processResultCollection() {
        block7: {
            boolean isStopTestResponseReceived = false;
            while (true) {
                BTSMessage response;
                if ((response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L)) instanceof Timeout) {
                    this.myLogger.debug((Object)"Result collection reception has timed out.");
                    this.mySelfTestListener.selfTestTestingFailed(68);
                    return false;
                }
                if (response instanceof ESTModuleTestResultNotif) {
                    ESTModuleTestResultNotif moduleTestResult = (ESTModuleTestResultNotif)response;
                    this.myLogger.debug((Object)("ESTModuleTestResultNotif received. UnitId=[" + moduleTestResult.getUnitId() + "], Verdict=[" + moduleTestResult.getTestVerdict() + "]"));
                    if (isStopTestResponseReceived) {
                        this.myLogger.debug((Object)"ESTModuleTestResultNotif discarded.");
                        continue;
                    }
                    this.mySelfTest.addModuleTestResult(moduleTestResult);
                    this.mySelfTestListener.selfTestPartialResult(moduleTestResult.getUnitId(), moduleTestResult.getTestVerdict());
                    continue;
                }
                if (response instanceof TestCompletedNotif) {
                    TestCompletedNotif testCompletedNotif = (TestCompletedNotif)response;
                    this.myLogger.debug((Object)("TestCompletedNotif received. Overall Test Result=[" + testCompletedNotif.getOverallTestResult() + "]"));
                    this.mySelfTest.addOverallTestResult(testCompletedNotif);
                    this.mySelfTestListener.selfTestOverallTestResult(testCompletedNotif.getOverallTestResult());
                    break block7;
                }
                if (!(response instanceof StopTestResponse)) break;
                StopTestResponse stopTestResponse = (StopTestResponse)response;
                this.myLogger.debug((Object)("StopTestResponse received. Overall Test Result=[" + stopTestResponse.getSuccessCode() + "]"));
                if (stopTestResponse.getSuccessCode() != 34) {
                    this.myLogger.error((Object)("StopTestResponse failed. retryCount=[" + this.myRetryCount + "]"));
                    if (this.myRetryCount < 2) {
                        ++this.myRetryCount;
                        StopTestRequest stopTestRequest = new StopTestRequest(this.mySeqNumber, "est");
                        this.myConnection.sendToBTS((BTSMessage)stopTestRequest);
                        continue;
                    }
                    this.mySelfTestListener.selfTestAbortFailed(stopTestResponse.getSuccessCode());
                    this.myRetryCount = 0;
                    continue;
                }
                isStopTestResponseReceived = true;
            }
            this.myLogger.error((Object)"Wrong reply received from BTS. ESTModuleTestResultNotif / TestCompletedNotif expected.");
            this.mySelfTestListener.selfTestTestingFailed(28);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCanSendStopRequest(boolean value) {
        Object object = this.myIsSendStopRequestLock;
        synchronized (object) {
            this.myIsSendStopRequest = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSendStopRequest() {
        Object object = this.myIsSendStopRequestLock;
        synchronized (object) {
            return this.myIsSendStopRequest;
        }
    }

    @Override
    public void execute() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.setIsRunning(true);
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return SelfTestTestingScenario.this.runScenario();
            }

            protected void finished() {
                SelfTestTestingScenario.this.myConnection.deleteScenario(SelfTestTestingScenario.this.mySeqNumber);
                SelfTestTestingScenario.this.setIsAbort(false);
                SelfTestTestingScenario.this.setIsRunning(false);
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        if (this.isRunning()) {
            if (this.isSendStopRequest()) {
                StopTestRequest stopTestRequest = new StopTestRequest(this.mySeqNumber, "est");
                this.myConnection.sendToBTS((BTSMessage)stopTestRequest);
            }
            this.setIsAbort(true);
        }
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

