/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTest;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTestsHandler;
import com.nokia.em.bts.coreasset.scenario.btstests.BtsTest;
import com.nokia.em.bts.coreasset.scenario.btstests.TestAdapter;
import com.nokia.em.bts.coreasset.scenario.btstests.TestListener;
import com.nokia.em.bts.coreasset.scenario.btstests.TestStopListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSScenario;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class TestAbortScenario
implements Scenario,
TestStopListener {
    private BTSConnection myBTSConnection;
    private TestListener myTestListener;
    private ActiveTest myActiveTest;
    private BtsTest myTest;
    private boolean myExecution = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private ActiveTestsHandler myActiveTestsHandler;

    public TestAbortScenario(BTSConnection connection, TestListener l, BtsTest test) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        TestListener testListener = l;
        this.myActiveTestsHandler = ActiveTestsHandler.getInstance();
        if (testListener == null) {
            testListener = new TestAdapter();
            this.myLogger.debug((Object)"TestListener is NULL");
        }
        this.myTestListener = testListener;
        this.myActiveTest = ActiveTest.getInstance();
        this.myTest = test;
    }

    public TestAbortScenario(BTSConnection connection, TestListener l, BtsTest test, BTSMessage.Type type) {
        this(connection, l, test);
        this.myType = type;
    }

    @Override
    public void execute() {
        int intSeqNumber = this.myTest.getSequenceNumber();
        if (this.myActiveTestsHandler.isTestExists(intSeqNumber).booleanValue()) {
            this.myActiveTestsHandler.addStopListener(this, intSeqNumber);
            this.myActiveTestsHandler.requestStop(intSeqNumber);
        } else {
            if (this.myExecution) {
                throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
            }
            this.myExecution = true;
            if (this.myBTSConnection == null) {
                this.myLogger.debug((Object)"myBTSConnection is NULL");
                return;
            }
            CoreAssetThread worker = new CoreAssetThread(){
                int myIntSeqNumber;

                protected Object construct() {
                    if (CoreAsset.isSnapshotOpening()) {
                        TestAbortScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                        TestAbortScenario.this.myTestListener.testAborted(85);
                        return true;
                    }
                    this.myIntSeqNumber = TestAbortScenario.this.myTest.getSequenceNumber();
                    TestAbortScenario.this.myActiveTest.removeActiveTest(this.myIntSeqNumber);
                    BTSScenario scenario = TestAbortScenario.this.myBTSConnection.getScenario(this.myIntSeqNumber);
                    if (scenario == null) {
                        TestAbortScenario.this.myBTSConnection.createScenario(this.myIntSeqNumber);
                    }
                    StopTestRequest stopTestRequest = new StopTestRequest(this.myIntSeqNumber, TestAbortScenario.this.myTest.getTestType());
                    TestAbortScenario.this.myBTSConnection.sendToBTS((BTSMessage)stopTestRequest);
                    BTSMessage response = TestAbortScenario.this.myBTSConnection.receiveFromBTS(this.myIntSeqNumber);
                    if (response instanceof StopTestResponse) {
                        StopTestResponse stopTestResponse = (StopTestResponse)response;
                        TestAbortScenario.this.notifyTestListener(stopTestResponse.getSuccessCode());
                    } else {
                        TestAbortScenario.this.myTestListener.testAborted(28);
                    }
                    return true;
                }

                protected void finished() {
                    TestAbortScenario.this.myExecution = false;
                }
            };
            worker.start();
        }
    }

    private void notifyTestListener(int successCode) {
        switch (successCode) {
            case 34: {
                this.myTestListener.testAborted(1);
                break;
            }
            case 39: {
                this.myTestListener.testAborted(2);
                break;
            }
            case 40: {
                this.myTestListener.testAborted(3);
                break;
            }
            case 58: {
                this.myTestListener.testAborted(10);
                break;
            }
            case 59: {
                this.myTestListener.testAborted(11);
                break;
            }
            case 105: {
                this.myTestListener.testAborted(15);
                break;
            }
            case 106: {
                this.myTestListener.testAborted(16);
                break;
            }
            case 107: {
                this.myTestListener.testAborted(17);
                break;
            }
            case 108: {
                this.myTestListener.testAborted(18);
                break;
            }
            default: {
                this.myTestListener.testAborted(-1);
            }
        }
    }

    @Override
    public boolean abort() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    @Override
    public void stopRequestFinished(int successCode) {
        this.notifyTestListener(successCode);
    }
}

