/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.message.TestCompletedNotif;
import com.nokia.em.bts.coreasset.message.TestProgressRequest;
import com.nokia.em.bts.coreasset.message.TestProgressResponse;
import com.nokia.em.bts.coreasset.message.TestReportRequest;
import com.nokia.em.bts.coreasset.message.TestReportResponse;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTest;
import com.nokia.em.bts.coreasset.scenario.btstests.TestListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.poseidon.util.concurrency.CachedThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import org.apache.log4j.Logger;

public class TestManagerMsgPoller
extends CachedThread {
    private final BTSConnection myConnection;
    private final int mySeqNumber;
    private final String myReportFile;
    private final int myProgressInterval;
    private final int myFilter;
    private final TestListener myListener;
    private final ActiveTest myActiveTest;
    private boolean myTestRunning = true;
    private boolean myProcessMessages = true;
    private static final int TEST_COMPLETED = 100;
    private boolean myTestStopped;
    private Logger myLogger = Logger.getLogger(((Object)((Object)this)).getClass());
    private ActionListener progressActionListener = null;
    private Object abortLock;
    private boolean abortSuccess = false;

    public TestManagerMsgPoller(BTSConnection connection, TestListener listener, int seqNumber, String reportFile, int progressInterval, int filter) {
        this.myConnection = connection;
        this.myActiveTest = ActiveTest.getInstance();
        this.myListener = listener;
        this.mySeqNumber = seqNumber;
        this.myReportFile = reportFile;
        this.myProgressInterval = progressInterval;
        this.myFilter = filter;
        this.myTestStopped = false;
        this.abortLock = new Object();
        this.progressActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TestManagerMsgPoller.this.myProcessMessages) {
                    TestManagerMsgPoller.this.sendTestProgressRequest();
                } else {
                    TimerService.getInstance().stopTimer(TestManagerMsgPoller.this.progressActionListener);
                }
            }
        };
    }

    public void run() {
        this.myLogger.debug((Object)"run start.");
        TimerService.getInstance().startTimer(this.progressActionListener, (long)this.myProgressInterval);
        while (this.myProcessMessages) {
            BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber);
            this.messageReceived(response);
        }
        this.myLogger.debug((Object)"run end.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abortCDMATest(String testType) {
        if (this.myConnection != null) {
            StopTestRequest stopTestRequest = new StopTestRequest(this.mySeqNumber, testType);
            this.myConnection.sendToBTS((BTSMessage)stopTestRequest);
            Object object = this.abortLock;
            synchronized (object) {
                try {
                    this.abortLock.wait();
                }
                catch (InterruptedException e) {
                    this.myLogger.error((Object)e);
                }
            }
        }
        this.myLogger.error((Object)"Failed. BTSConnection not found");
        return this.abortSuccess;
    }

    private void sendTestProgressRequest() {
        TestProgressRequest testProgressRequest = new TestProgressRequest(this.mySeqNumber);
        this.myConnection.sendToBTS((BTSMessage)testProgressRequest);
    }

    private void messageReceived(BTSMessage message) {
        if (message == null) {
            this.myLogger.error((Object)"Null message received. Probably polling end.");
            this.terminateProcessMessagesLoop();
            return;
        }
        if (message instanceof TestProgressResponse) {
            this.processTestProgressResponse(message);
        } else if (message instanceof TestCompletedNotif) {
            this.processTestCompletedNotif(message);
        } else if (message instanceof StopTestResponse) {
            this.processStopTestResponse(message);
        } else if (message instanceof TestReportResponse) {
            this.processTestReportResponse(message);
        } else {
            this.myLogger.error((Object)("Wrong reply received from BTS. TestProgressResponse, TestCompletedNotif or StopTestResponse expected, " + message.getClass() + " received."));
            this.myListener.testFailed(28);
        }
    }

    private void processTestProgressResponse(BTSMessage message) {
        TestProgressResponse testProgressResponse = (TestProgressResponse)message;
        if (testProgressResponse.getProgressValue() < 100) {
            this.myListener.reportProgress(testProgressResponse.getProgressValue());
        } else if (testProgressResponse.getProgressValue() == 100) {
            this.myListener.reportProgress(testProgressResponse.getProgressValue());
            TimerService.getInstance().stopTimer(this.progressActionListener);
        }
    }

    private void processTestCompletedNotif(BTSMessage message) {
        this.myTestRunning = false;
        TimerService.getInstance().stopTimer(this.progressActionListener);
        this.myActiveTest.removeActiveTest(this.mySeqNumber);
        TestCompletedNotif notif = (TestCompletedNotif)message;
        this.myListener.testCompleted(notif.getCdmaTestSuccess());
        if (this.myTestStopped) {
            this.terminateProcessMessagesLoop();
            this.myConnection.deleteScenario(this.mySeqNumber);
        } else {
            TestReportRequest testReportRequest = new TestReportRequest(this.mySeqNumber, this.myReportFile, this.myFilter);
            this.myConnection.sendToBTS((BTSMessage)testReportRequest);
        }
    }

    private void terminateProcessMessagesLoop() {
        this.myProcessMessages = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTestReportResponse(BTSMessage message) {
        this.terminateProcessMessagesLoop();
        if (this.myTestRunning) {
            throw new IllegalStateException("TestReportResponse should not arrive while test is running.");
        }
        TestReportResponse testReportResponse = (TestReportResponse)message;
        this.myConnection.deleteScenario(this.mySeqNumber);
        if (testReportResponse.getSuccessCode() == 34) {
            File file = null;
            try {
                FTPTransferInfo ftpTransferInfo = testReportResponse.getFTPTransferInfo();
                if (ftpTransferInfo == null || ftpTransferInfo.getFileId().equals("Coreasset_Unknown") || ftpTransferInfo.getServerAddress().equals("Coreasset_Unknown")) {
                    ftpTransferInfo = ScenarioManagerImpl.getFTPTransferInfo();
                    ftpTransferInfo.setFileName(this.myReportFile);
                    FileTransferClient client = this.myConnection.getFileTransferFactory().getFileTransferClient();
                    client.setFTPTransferInfo(ftpTransferInfo);
                    file = client.getFile();
                } else {
                    FileTransferClient client = this.myConnection.getFileTransferFactory().getFileTransferClient();
                    client.setFTPTransferInfo(ftpTransferInfo);
                    file = client.getFile();
                    this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(this.mySeqNumber, new String[]{ftpTransferInfo.getFileId()}));
                }
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Error occured during test report file transfer. ", (Throwable)e);
            }
            if (file != null) {
                this.myListener.testCompleted(file);
                return;
            }
            this.myLogger.error((Object)"test report file transfer.");
            this.myListener.testFailed(7);
            return;
        }
        switch (testReportResponse.getSuccessCode()) {
            case 41: {
                this.myListener.testFailed(5);
                return;
            }
            case 42: {
                this.myListener.testFailed(8);
                return;
            }
        }
        this.myListener.testFailed(-1);
    }

    private void processStopTestResponse(BTSMessage message) {
        if (!this.myTestRunning) {
            this.allowScenarioTermination();
            return;
        }
        StopTestResponse stopTestResponse = (StopTestResponse)message;
        this.myTestStopped = true;
        int successCode = stopTestResponse.getSuccessCode();
        if (successCode == 34) {
            this.myListener.testAborted(1);
            this.abortSuccess = true;
        } else if (successCode == 39) {
            this.myListener.testAborted(2);
            this.abortSuccess = false;
        } else if (successCode == 40) {
            this.myListener.testAborted(3);
            this.abortSuccess = false;
        } else {
            this.myListener.testAborted(-1);
            this.abortSuccess = false;
        }
        this.allowScenarioTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allowScenarioTermination() {
        Object object = this.abortLock;
        synchronized (object) {
            this.abortLock.notify();
        }
    }
}

