/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.StartTestRequest;
import com.nokia.em.bts.coreasset.message.StartTestResponse;
import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTest;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTestsHandler;
import com.nokia.em.bts.coreasset.scenario.btstests.BtsTest;
import com.nokia.em.bts.coreasset.scenario.btstests.TestListener;
import com.nokia.em.bts.coreasset.scenario.btstests.TestScenario;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoAdapter;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.log4j.Logger;

public class TestModelScenario
extends ConnectionInfoAdapter
implements Scenario,
TestScenario {
    public static final String TESTMODEL_1 = "testModel1";
    public static final String TESTMODEL_2 = "testModel2";
    public static final String TESTMODEL_3 = "testModel3";
    public static final String TESTMODEL_4 = "testModel4";
    public static final String TESTMODEL_5 = "testModel5";
    public static final String TESTMODEL_6 = "testModel6";
    public static final long TESTMODEL_2_NUMBER_OF_DPCH_VALUE = 3L;
    public static final String TESTMODELWIMAX = "testModelWimax";
    public static final String TESTMODELNUMBER = "testModelNumber";
    public static final String LCRID = "lcrId";
    public static final String TXRX_TEST_TYPE = "txrxTestType";
    public static final String UARFCN = "uarfcn";
    public static final String DURATION = "duration";
    public static final String SCRAMBLING_CODE = "scramblingCode";
    public static final String NUMBER_OF_DPCH = "numberOfDpch";
    public static final String NUMBER_OF_HSPDSCH = "numberOfHsPdsch";
    public static final String VAM_DEDICATED_TESTMODEL = "vamDedicatedTestModel";
    public static final String TPC_DL_STEP_SIZE = "tpcDlStepSize";
    public static final String DL_TX_POWER = "dlTxPower";
    public static final String TX_POWER_OF_PRIMARY_CCPCH = "txPowerOfPrimaryCcpch";
    public static final String MIMO_PHASE = "mimoPhase";
    public static final String MIMO_STREAM = "mimoStream";
    public static final String TM_ID = "tmId";
    public static final String EARFCN = "earfcn";
    public static final String PHYSICAL_ID = "phyCellId";
    private static final int MILLISECOND_FACTOR = 1000;
    private BTSConnection myBTSConnection;
    private TestListener myTestListener;
    private String myTestParameters;
    private String myTestModel;
    private int myLcrId;
    private ActiveTest myActiveTest;
    private int myDuration = -1;
    private ActionListener testModelDurationActionListener = null;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    int intSeqNumber;
    private boolean myIsStopTestRequestSent = false;
    private CyclicBarrier myCyclicBarrier;
    private ActiveTestsHandler myActiveTestsHandler;
    protected boolean myIsAborting;

    public TestModelScenario(BTSConnection connection, TestListener testListener, String strTestModel, int testModelNumber, int lcrId) {
        this.init(connection, testListener, strTestModel, lcrId, -1);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append(this.wrapInTags(TESTMODELNUMBER, testModelNumber));
        testParameters.append(this.wrapInTags(LCRID, lcrId));
        testParameters.append(this.wrapInTags(TXRX_TEST_TYPE, "tx"));
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String strTestModel, int testModelNumber, int lcrId, BTSMessage.Type type) {
        this(connection, testListener, strTestModel, testModelNumber, lcrId);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String strTestModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, Boolean vamDedicated) {
        this.init(connection, testListener, strTestModel, lcrId, duration);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append(this.wrapInTags(LCRID, lcrId));
        testParameters.append(this.wrapInTags(UARFCN, txrfcn));
        testParameters.append(this.wrapInTags(DURATION, duration));
        testParameters.append(this.wrapInTags(SCRAMBLING_CODE, primaryScrCode));
        testParameters.append(this.wrapInTags(NUMBER_OF_DPCH, numberOfDpch));
        testParameters.append(this.getVamDedicatedTestModel(vamDedicated));
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String strTestModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, Boolean vamDedicated, BTSMessage.Type type) {
        this(connection, testListener, strTestModel, lcrId, txrfcn, duration, primaryScrCode, numberOfDpch, vamDedicated);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, float tpcDlStepSize, long dlTxPower, Boolean vamDedicated) {
        this.init(connection, testListener, testModel, lcrId, duration);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append(this.wrapInTags(LCRID, lcrId));
        testParameters.append(this.wrapInTags(UARFCN, txrfcn));
        testParameters.append(this.wrapInTags(DURATION, duration));
        testParameters.append(this.wrapInTags(SCRAMBLING_CODE, primaryScrCode));
        testParameters.append(this.wrapInTags(NUMBER_OF_DPCH, numberOfDpch));
        testParameters.append("<TModel2PowerControl>");
        testParameters.append(this.wrapInTags(TPC_DL_STEP_SIZE, Float.valueOf(tpcDlStepSize)));
        testParameters.append(this.wrapInTags(DL_TX_POWER, dlTxPower));
        testParameters.append("</TModel2PowerControl>");
        testParameters.append(this.getVamDedicatedTestModel(vamDedicated));
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, float tpcDlStepSize, long dlTxPower, Boolean vamDedicated, BTSMessage.Type type) {
        this(connection, testListener, testModel, lcrId, txrfcn, duration, primaryScrCode, numberOfDpch, tpcDlStepSize, dlTxPower, vamDedicated);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, int lcrId, int txrfcn, int duration, long primaryScrCode, long txPowerOfPrimaryCcpch, String testModel) {
        this.init(connection, testListener, testModel, lcrId, duration);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append(this.wrapInTags(LCRID, lcrId));
        testParameters.append(this.wrapInTags(UARFCN, txrfcn));
        testParameters.append(this.wrapInTags(DURATION, duration));
        testParameters.append(this.wrapInTags(SCRAMBLING_CODE, primaryScrCode));
        testParameters.append(this.wrapInTags(TX_POWER_OF_PRIMARY_CCPCH, txPowerOfPrimaryCcpch));
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, int lcrId, int txrfcn, int duration, long primaryScrCode, long txPowerOfPrimaryCcpch, String testModel, BTSMessage.Type type) {
        this(connection, testListener, lcrId, txrfcn, duration, primaryScrCode, txPowerOfPrimaryCcpch, testModel);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, long numberOfHsPdch, Boolean vamDedicated) {
        this.init(connection, testListener, testModel, lcrId, duration);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append(this.wrapInTags(LCRID, lcrId));
        testParameters.append(this.wrapInTags(UARFCN, txrfcn));
        testParameters.append(this.wrapInTags(DURATION, duration));
        testParameters.append(this.wrapInTags(SCRAMBLING_CODE, primaryScrCode));
        testParameters.append(this.wrapInTags(NUMBER_OF_DPCH, numberOfDpch));
        testParameters.append(this.wrapInTags(NUMBER_OF_HSPDSCH, numberOfHsPdch));
        testParameters.append(this.getVamDedicatedTestModel(vamDedicated));
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, long numberOfHsPdch, Boolean vamDedicated, BTSMessage.Type type) {
        this(connection, testListener, testModel, lcrId, txrfcn, duration, primaryScrCode, numberOfDpch, numberOfHsPdch, vamDedicated);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, String tmId) {
        this(connection, testListener, testModel, lcrId, tmId, -1);
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, String tmId, BTSMessage.Type type) {
        this(connection, testListener, testModel, lcrId, tmId, -1);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, String tmId, int earfcn) {
        this(connection, testListener, testModel, lcrId, tmId, earfcn, -1);
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, String tmId, int earfcn, BTSMessage.Type type) {
        this(connection, testListener, testModel, lcrId, tmId, earfcn, -1);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, String tmId, int earfcn, int phyCellId) {
        this.init(connection, testListener, testModel, lcrId, -1);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append(this.wrapInTags(LCRID, lcrId));
        testParameters.append(this.wrapInTags(TM_ID, tmId));
        if (earfcn != -1) {
            testParameters.append(this.wrapInTags(EARFCN, earfcn));
        }
        if (phyCellId != -1) {
            testParameters.append(this.wrapInTags(PHYSICAL_ID, phyCellId));
        }
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, String tmId, int earfcn, int phyCellId, BTSMessage.Type type) {
        this(connection, testListener, testModel, lcrId, tmId, earfcn, phyCellId);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String strTestModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, int mimoPhase, String mimoStream, Boolean vamDedicated) {
        this.init(connection, testListener, strTestModel, lcrId, duration);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append(this.wrapInTags(LCRID, lcrId));
        testParameters.append(this.wrapInTags(UARFCN, txrfcn));
        testParameters.append(this.wrapInTags(DURATION, duration));
        testParameters.append(this.wrapInTags(SCRAMBLING_CODE, primaryScrCode));
        testParameters.append(this.wrapInTags(NUMBER_OF_DPCH, numberOfDpch));
        testParameters.append(this.wrapInTags(MIMO_PHASE, mimoPhase));
        testParameters.append(this.wrapInTags(MIMO_STREAM, mimoStream));
        testParameters.append(this.getVamDedicatedTestModel(vamDedicated));
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String strTestModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, int mimoPhase, String mimoStream, Boolean vamDedicated, BTSMessage.Type type) {
        this(connection, testListener, strTestModel, lcrId, txrfcn, duration, primaryScrCode, numberOfDpch, mimoPhase, mimoStream, vamDedicated);
        this.myType = type;
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, long numberOfHsPdch, int mimoPhase, String mimoStream, Boolean vamDedicated) {
        this.init(connection, testListener, testModel, lcrId, duration);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append(this.wrapInTags(LCRID, lcrId));
        testParameters.append(this.wrapInTags(UARFCN, txrfcn));
        testParameters.append(this.wrapInTags(DURATION, duration));
        testParameters.append(this.wrapInTags(SCRAMBLING_CODE, primaryScrCode));
        testParameters.append(this.wrapInTags(NUMBER_OF_DPCH, numberOfDpch));
        testParameters.append(this.wrapInTags(NUMBER_OF_HSPDSCH, numberOfHsPdch));
        testParameters.append(this.wrapInTags(MIMO_PHASE, mimoPhase));
        testParameters.append(this.wrapInTags(MIMO_STREAM, mimoStream));
        testParameters.append(this.getVamDedicatedTestModel(vamDedicated));
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public TestModelScenario(BTSConnection connection, TestListener testListener, String testModel, int lcrId, int txrfcn, int duration, long primaryScrCode, long numberOfDpch, long numberOfHsPdch, int mimoPhase, String mimoStream, Boolean vamDedicated, BTSMessage.Type type) {
        this(connection, testListener, testModel, lcrId, txrfcn, duration, primaryScrCode, numberOfDpch, numberOfHsPdch, mimoPhase, mimoStream, vamDedicated);
        this.myType = type;
    }

    protected String wrapInTags(String name, Object value) {
        return "<_" + name + ">" + value + "</_" + name + ">";
    }

    protected String getTestParameters() {
        return this.myTestParameters;
    }

    protected String getVamDedicatedTestModel(Boolean vamDedicated) {
        String vamDedicatedTestModel = "";
        if (vamDedicated != null) {
            vamDedicatedTestModel = this.wrapInTags(VAM_DEDICATED_TESTMODEL, vamDedicated);
        }
        return vamDedicatedTestModel;
    }

    private void init(BTSConnection connection, TestListener testListener, String testModel, int lcrId, int duration) {
        this.myCyclicBarrier = new CyclicBarrier(2);
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myTestListener = testListener;
        this.myTestModel = testModel;
        this.myLcrId = lcrId;
        this.myDuration = duration;
        connection.addConnectionInfoListener((ConnectionInfoListener)this);
        this.myActiveTestsHandler = ActiveTestsHandler.getInstance();
        this.testModelDurationActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TestModelScenario.this.abort();
                TimerService.getInstance().stopTimer(TestModelScenario.this.testModelDurationActionListener);
            }
        };
    }

    @Override
    public void execute() {
        this.myLogger.debug((Object)"execute");
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return TestModelScenario.this.runScenario();
            }

            protected void finished() {
                TestModelScenario.this.myBTSConnection.deleteScenario(TestModelScenario.this.intSeqNumber);
                TestModelScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        this.myLogger.debug((Object)"runScenario");
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 85);
            return true;
        }
        this.intSeqNumber = this.myBTSConnection.createScenario();
        StartTestRequest startTestRequest = new StartTestRequest(this.intSeqNumber, this.myTestModel, this.myTestParameters, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)startTestRequest);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.intSeqNumber, 200000L);
        if (response instanceof StartTestResponse) {
            StartTestResponse startResponse = (StartTestResponse)response;
            if (startResponse.getSuccessCode() != 34) {
                this.callListener(startResponse.getSuccessCode());
                return false;
            }
            this.doStartTest();
            this.waitThreadExecution();
        } else if (response instanceof Timeout) {
            this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 68);
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. StartTestResponse expected.");
            this.myTestListener.testFailed(28);
        }
        return false;
    }

    private void callListener(int successCode) {
        switch (successCode) {
            case 42: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 6);
                break;
            }
            case 58: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 10);
                break;
            }
            case 59: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 11);
                break;
            }
            case 105: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 15);
                break;
            }
            case 106: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 16);
                break;
            }
            case 107: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 17);
                break;
            }
            case 108: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 18);
                break;
            }
            case 60: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 12);
                break;
            }
            case 61: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 13);
                break;
            }
            case 62: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 14);
                break;
            }
            default: {
                this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, -1);
            }
        }
    }

    protected void doStartTest() {
        this.myActiveTestsHandler.addTestScenario(this, this.intSeqNumber);
        this.myTestListener.testModelStarted(this.myTestModel, this.myLcrId, 1);
        BtsTest thisTest = new BtsTest(this.myTestModel, this.intSeqNumber, true, this.myLcrId);
        this.myActiveTest.addActiveTest(thisTest);
        if (this.myDuration > 0) {
            TimerService.getInstance().startTimer(this.testModelDurationActionListener, (long)(this.myDuration * 1000));
        }
    }

    @Override
    public boolean abort() {
        if (this.myActiveTest.getActiveTest(this.myLcrId, this.myTestModel) != null) {
            BtsTest berTest = this.myActiveTest.getActiveTest(this.myLcrId, this.myTestModel);
            if (berTest == null) {
                return false;
            }
            StopTestRequest stopTestRequest = new StopTestRequest(berTest.getSequenceNumber(), this.myTestModel, this.myType);
            this.myBTSConnection.sendToBTS((BTSMessage)stopTestRequest);
            this.myIsStopTestRequestSent = true;
            if (!this.myIsAborting) {
                this.startReceivingStopTestResponse();
                this.myIsAborting = true;
            }
        }
        return true;
    }

    private void startReceivingStopTestResponse() {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                TestModelScenario.this.receiveStopResponse();
                return true;
            }

            protected void finished() {
                TestModelScenario.this.myIsAborting = false;
                TestModelScenario.this.myIsStopTestRequestSent = false;
            }
        };
        worker.start();
    }

    protected void receiveStopResponse() {
        while (true) {
            BTSMessage response;
            if ((response = this.myBTSConnection.receiveFromBTS(this.intSeqNumber, 200000L)) instanceof StopTestResponse && this.myIsStopTestRequestSent) {
                StopTestResponse stopTestResponse = (StopTestResponse)response;
                int successCode = stopTestResponse.getSuccessCode();
                this.myActiveTestsHandler.stopRequestFinished(this.intSeqNumber, successCode);
                this.callAborted(successCode);
                if (successCode != 34 && successCode != 39) continue;
                this.tearDownScenarioAndWaitThread();
                return;
            }
            if (response instanceof Timeout && this.myIsStopTestRequestSent) {
                this.myTestListener.testAborted(this.myLcrId, 68);
                this.myIsStopTestRequestSent = false;
                continue;
            }
            if (response == null) break;
        }
        this.myTestListener.testAborted(this.myLcrId, 1);
        this.tearDownScenarioAndWaitThread();
        this.waitThreadExecution();
    }

    private void callAborted(int successCode) {
        switch (successCode) {
            case 34: {
                this.myTestListener.testAborted(this.myLcrId, 1);
                break;
            }
            case 39: {
                this.myTestListener.testAborted(this.myLcrId, 2);
                break;
            }
            case 58: {
                this.myTestListener.testAborted(this.myLcrId, 10);
                break;
            }
            case 59: {
                this.myTestListener.testAborted(this.myLcrId, 11);
                break;
            }
            case 105: {
                this.myTestListener.testAborted(this.myLcrId, 15);
                break;
            }
            case 106: {
                this.myTestListener.testAborted(this.myLcrId, 16);
                break;
            }
            case 107: {
                this.myTestListener.testAborted(this.myLcrId, 17);
                break;
            }
            case 108: {
                this.myTestListener.testAborted(this.myLcrId, 18);
                break;
            }
            default: {
                this.myTestListener.testAborted(this.myLcrId, -1);
            }
        }
    }

    private void tearDownScenarioAndWaitThread() {
        this.myActiveTest.removeActiveTest(this.intSeqNumber);
        this.myBTSConnection.deleteScenario(this.intSeqNumber);
        this.myBTSConnection.removeConnectionInfoListener((ConnectionInfoListener)this);
        this.waitThreadExecution();
    }

    private void waitThreadExecution() {
        try {
            this.myCyclicBarrier.await();
        }
        catch (InterruptedException e) {
            throw new IllegalThreadStateException();
        }
        catch (BrokenBarrierException e) {
            throw new IllegalThreadStateException();
        }
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    public void btsDisconnected() {
        this.myTestListener.testAborted(this.myLcrId, 1);
        this.tearDownScenarioAndWaitThread();
    }

    @Override
    public void stopTest() {
        this.abort();
    }
}

