/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.StartTestRequest;
import com.nokia.em.bts.coreasset.message.StartTestResponse;
import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.message.TestCompletedNotif;
import com.nokia.em.bts.coreasset.message.TestProgressRequest;
import com.nokia.em.bts.coreasset.message.TestProgressResponse;
import com.nokia.em.bts.coreasset.message.TestReportRequest;
import com.nokia.em.bts.coreasset.message.TestReportResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTest;
import com.nokia.em.bts.coreasset.scenario.btstests.BtsTest;
import com.nokia.em.bts.coreasset.scenario.btstests.TestListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WcdmaLoopTestScenario
implements Scenario {
    private BTSConnection myConnection;
    private TestListener myTestListener;
    private ActiveTest myActiveTest;
    private int mySeqNumber;
    private boolean myRunning = false;
    private String myTestParameters;
    private String myReportFile;
    private int myFilter;
    private int myProgressInterval;
    private String myTestType;
    private Logger myLogger;
    private Object abortLock;
    private ActionListener progressActionListener = null;
    private boolean abortSuccess = false;
    private boolean myScenarioReady = false;
    private static final int TEST_COMPLETED = 100;
    private ActionListener timeoutListener;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, int numberOfSequences, float dataRate, Vector coverageWAM, Vector coverageTRX, Vector coverageATM, Vector coverageWSP, Vector coverageDSP, boolean optimizedVariation, String reportFile, int filter, int progressInterval) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.initialize(connection, testListener, reportFile, filter, progressInterval, "CDMATest");
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_numberOfSequences>" + numberOfSequences + "</_numberOfSequences>");
        testParameters.append("<_userDataRate>" + dataRate + "</_userDataRate>");
        testParameters.append(this.formTestString(coverageWAM, "CoverageWAM", "_unitName"));
        testParameters.append(this.formTestString(coverageTRX, "CoverageTRX", "_unitName"));
        testParameters.append(this.formTestString(coverageATM, "CoverageATM", "_unitNumber"));
        testParameters.append(this.formTestString(coverageWSP, "CoverageWSP", "_unitName"));
        testParameters.append(this.formTestString(coverageDSP, "CoverageDSP", "_unitNumber"));
        testParameters.append("<_optimizedVariation>" + optimizedVariation + "</_optimizedVariation>");
        this.myTestParameters = testParameters.toString();
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, int numberOfSequences, float dataRate, Vector coverageWAM, Vector coverageTRX, Vector coverageATM, Vector coverageWSP, Vector coverageDSP, boolean optimizedVariation, String reportFile, int filter, int progressInterval, BTSMessage.Type type) {
        this(connection, testListener, numberOfSequences, dataRate, coverageWAM, coverageTRX, coverageATM, coverageWSP, coverageDSP, optimizedVariation, reportFile, filter, progressInterval);
        this.myType = type;
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, int numberOfSequences, float userDataRate, Vector coverageModules, boolean optimizedVariation, String reportFile, int filter, int progressInterval, String testType) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.initialize(connection, testListener, reportFile, filter, progressInterval, testType);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_numberOfSequences>" + numberOfSequences + "</_numberOfSequences>");
        testParameters.append("<_userDataRate>" + userDataRate + "</_userDataRate>");
        testParameters.append(this.formTestString(coverageModules, "CoverageModules", "_unitName"));
        testParameters.append("<_optimizedVariation>" + optimizedVariation + "</_optimizedVariation>");
        this.myTestParameters = testParameters.toString();
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, int numberOfSequences, float userDataRate, Vector coverageModules, boolean optimizedVariation, String reportFile, int filter, int progressInterval, String testType, BTSMessage.Type type) {
        this(connection, testListener, numberOfSequences, userDataRate, coverageModules, optimizedVariation, reportFile, filter, progressInterval, testType);
        this.myType = type;
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, int duration, Vector coverageModules, boolean optimizedVariation, String reportFile, int filter, int progressInterval, String testType) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.initialize(connection, testListener, reportFile, filter, progressInterval, testType);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_duration>" + duration + "</_duration>");
        testParameters.append(this.formTestString(coverageModules, "CoverageModules", "_unitName"));
        testParameters.append("<_optimizedVariation>" + optimizedVariation + "</_optimizedVariation>");
        this.myTestParameters = testParameters.toString();
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, int duration, Vector coverageModules, boolean optimizedVariation, String reportFile, int filter, int progressInterval, String testType, BTSMessage.Type type) {
        this(connection, testListener, duration, coverageModules, optimizedVariation, reportFile, filter, progressInterval, testType);
        this.myType = type;
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, int duration, Vector coverageModules, String reportFile, int filter, int progressInterval, String testType) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.initialize(connection, testListener, reportFile, filter, progressInterval, testType);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_duration>" + duration + "</_duration>");
        testParameters.append(this.formTestString(coverageModules, "CoverageModules", "_unitName"));
        this.myTestParameters = testParameters.toString();
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, int duration, Vector coverageModules, String reportFile, int filter, int progressInterval, String testType, BTSMessage.Type type) {
        this(connection, testListener, duration, coverageModules, reportFile, filter, progressInterval, testType);
        this.myType = type;
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, Vector coverageModules, int unitId, String reportFile, int filter, int progressInterval, String testType) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.initialize(connection, testListener, reportFile, filter, progressInterval, testType);
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_unitId>" + unitId + "</_unitId>");
        testParameters.append(this.formTestString(coverageModules, "CoverageModules", "_unitName"));
        testParameters.append("<_reportingInterval>" + progressInterval + "</_reportingInterval>");
        this.myTestParameters = testParameters.toString();
    }

    public WcdmaLoopTestScenario(BTSConnection connection, TestListener testListener, Vector coverageModules, int unitId, String reportFile, int filter, int progressInterval, String testType, BTSMessage.Type type) {
        this(connection, testListener, coverageModules, unitId, reportFile, filter, progressInterval, testType);
        this.myType = type;
    }

    private void initialize(BTSConnection connection, TestListener testListener, String reportFile, int filter, int progressInterval, String testType) {
        this.myConnection = connection;
        this.myTestListener = testListener;
        this.myReportFile = reportFile;
        this.myFilter = filter;
        this.myProgressInterval = progressInterval;
        this.myActiveTest = ActiveTest.getInstance();
        this.myTestType = testType;
        this.abortLock = new Object();
        this.timeoutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WcdmaLoopTestScenario.this.abortLock.notify();
            }
        };
        this.progressActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WcdmaLoopTestScenario.this.myRunning) {
                    WcdmaLoopTestScenario.this.sendTestProgressRequest();
                } else {
                    TimerService.getInstance().stopTimer(WcdmaLoopTestScenario.this.progressActionListener);
                }
            }
        };
    }

    private String formTestString(Vector vecTestUnitsIds, String strTagName, String strElementName) {
        StringBuffer testParameters = new StringBuffer();
        if (!vecTestUnitsIds.isEmpty()) {
            if (((String)vecTestUnitsIds.firstElement()).equalsIgnoreCase("all")) {
                testParameters.append("<" + strTagName + "><All/></" + strTagName + ">");
            } else {
                testParameters.append("<" + strTagName + ">");
                Enumeration enumeration = vecTestUnitsIds.elements();
                while (enumeration.hasMoreElements()) {
                    testParameters.append("<" + strElementName + ">" + enumeration.nextElement() + "</" + strElementName + ">");
                }
                testParameters.append("</" + strTagName + ">");
            }
        }
        return testParameters.toString();
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("This scenario can not be executed more than once.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                block10: {
                    BTSMessage response;
                    block9: {
                        if (CoreAsset.isSnapshotOpening()) {
                            WcdmaLoopTestScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                            WcdmaLoopTestScenario.this.myTestListener.testFailed(85);
                            return true;
                        }
                        WcdmaLoopTestScenario.this.mySeqNumber = WcdmaLoopTestScenario.this.myConnection.createScenario();
                        StartTestRequest startTestRequest = new StartTestRequest(WcdmaLoopTestScenario.this.mySeqNumber, WcdmaLoopTestScenario.this.myTestType, WcdmaLoopTestScenario.this.myTestParameters, WcdmaLoopTestScenario.this.myType);
                        WcdmaLoopTestScenario.this.myConnection.sendToBTS((BTSMessage)startTestRequest);
                        response = WcdmaLoopTestScenario.this.myConnection.receiveFromBTS(WcdmaLoopTestScenario.this.mySeqNumber);
                        if (!(response instanceof StartTestResponse)) break block9;
                        StartTestResponse startResponse = (StartTestResponse)response;
                        if (startResponse.getSuccessCode() != 34) {
                            switch (startResponse.getSuccessCode()) {
                                case 27: {
                                    WcdmaLoopTestScenario.this.myTestListener.testFailed(4);
                                    break;
                                }
                                case 42: {
                                    WcdmaLoopTestScenario.this.myTestListener.testFailed(6);
                                    break;
                                }
                                default: {
                                    WcdmaLoopTestScenario.this.myTestListener.testFailed(-1);
                                }
                            }
                            return false;
                        }
                        BtsTest thisTest = new BtsTest(WcdmaLoopTestScenario.this.myTestType, WcdmaLoopTestScenario.this.mySeqNumber, true);
                        WcdmaLoopTestScenario.this.myActiveTest.addActiveTest(thisTest);
                        WcdmaLoopTestScenario.this.myTestListener.testStarted();
                        if (!WcdmaLoopTestScenario.this.myRunning) break block10;
                        TimerService.getInstance().startTimer(WcdmaLoopTestScenario.this.progressActionListener, (long)WcdmaLoopTestScenario.this.myProgressInterval);
                        while (!WcdmaLoopTestScenario.this.myScenarioReady) {
                            response = WcdmaLoopTestScenario.this.myConnection.receiveFromBTS(WcdmaLoopTestScenario.this.mySeqNumber);
                            WcdmaLoopTestScenario.this.messageReceived(response);
                        }
                        break block10;
                    }
                    if (response instanceof StopTestResponse) {
                        WcdmaLoopTestScenario.this.messageReceived(response);
                        while (!WcdmaLoopTestScenario.this.myScenarioReady) {
                            response = WcdmaLoopTestScenario.this.myConnection.receiveFromBTS(WcdmaLoopTestScenario.this.mySeqNumber);
                            WcdmaLoopTestScenario.this.messageReceived(response);
                        }
                    }
                }
                return false;
            }

            protected void finished() {
                super.finished();
                WcdmaLoopTestScenario.this.allowScenarioTermination();
            }
        };
        worker.start();
    }

    private void messageReceived(BTSMessage message) {
        if (message == null) {
            this.myLogger.error((Object)"Null message received. Probably polling end.");
            this.myRunning = false;
            return;
        }
        if (message instanceof TestProgressResponse) {
            this.processTestProgressResponse(message);
        } else if (message instanceof TestCompletedNotif) {
            this.processTestCompletedNotif(message);
        } else if (message instanceof StopTestResponse) {
            this.processStopTestResponse(message);
        } else if (message instanceof TestReportResponse) {
            this.processTestReportResponse(message);
        } else {
            this.myLogger.error((Object)("Wrong reply received from BTS. TestProgressResponse, TestCompletedNotif or StopTestResponse expected, " + message.getClass() + " received."));
            this.myTestListener.testFailed(28);
        }
    }

    private void processTestProgressResponse(BTSMessage message) {
        TestProgressResponse testProgressResponse = (TestProgressResponse)message;
        if (testProgressResponse.getProgressValue() < 100) {
            this.myTestListener.reportProgress(testProgressResponse.getProgressValue());
        } else if (testProgressResponse.getProgressValue() == 100) {
            this.myTestListener.reportProgress(testProgressResponse.getProgressValue());
            TimerService.getInstance().stopTimer(this.progressActionListener);
        }
    }

    private void processTestCompletedNotif(BTSMessage message) {
        TimerService.getInstance().stopTimer(this.progressActionListener);
        this.myActiveTest.removeActiveTest(this.mySeqNumber);
        TestCompletedNotif notif = (TestCompletedNotif)message;
        this.myTestListener.testCompleted(notif.getCdmaTestSuccess());
        if (!this.myRunning) {
            this.allowScenarioTermination();
        } else {
            TestReportRequest testReportRequest = new TestReportRequest(this.mySeqNumber, this.myReportFile, this.myFilter, this.myType);
            this.myConnection.sendToBTS((BTSMessage)testReportRequest);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTestReportResponse(BTSMessage message) {
        if (!this.myRunning) {
            throw new IllegalStateException("TestReportResponse should not arrive while test is running.");
        }
        TestReportResponse testReportResponse = (TestReportResponse)message;
        this.myConnection.deleteScenario(this.mySeqNumber);
        if (testReportResponse.getSuccessCode() == 34) {
            File file = null;
            try {
                FTPTransferInfo ftpTransferInfo = testReportResponse.getFTPTransferInfo();
                if (ftpTransferInfo == null || ftpTransferInfo.getFileId().equals("Coreasset_Unknown") || ftpTransferInfo.getServerAddress().equals("Coreasset_Unknown")) {
                    ftpTransferInfo = ScenarioManagerImpl.getFTPTransferInfo();
                    ftpTransferInfo.setFileName(this.myReportFile);
                    FileTransferClient client = this.myConnection.getFileTransferFactory().getFileTransferClient();
                    client.setFTPTransferInfo(ftpTransferInfo);
                    file = client.getFile();
                } else {
                    FileTransferClient client = this.myConnection.getFileTransferFactory().getFileTransferClient();
                    client.setFTPTransferInfo(ftpTransferInfo);
                    file = client.getFile();
                    this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(this.mySeqNumber, new String[]{ftpTransferInfo.getFileId()}));
                }
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Error occured during test report file transfer. ", (Throwable)e);
            }
            if (file == null) {
                this.myLogger.error((Object)"test report file transfer.");
                this.myTestListener.testFailed(7);
                return;
            }
            this.myTestListener.testCompleted(file);
        } else {
            switch (testReportResponse.getSuccessCode()) {
                case 41: {
                    this.myTestListener.testFailed(5);
                    break;
                }
                case 42: {
                    this.myTestListener.testFailed(8);
                    break;
                }
                default: {
                    this.myTestListener.testFailed(-1);
                }
            }
        }
        this.myRunning = false;
        this.allowScenarioTermination();
    }

    private void processStopTestResponse(BTSMessage message) {
        StopTestResponse stopTestResponse = (StopTestResponse)message;
        int successCode = stopTestResponse.getSuccessCode();
        if (successCode == 34) {
            this.myTestListener.testAborted(1);
            this.abortSuccess = true;
        } else if (successCode == 39) {
            this.myTestListener.testAborted(2);
            this.abortSuccess = false;
        } else if (successCode == 40) {
            this.myTestListener.testAborted(3);
            this.abortSuccess = false;
        } else {
            this.myTestListener.testAborted(-1);
            this.abortSuccess = false;
        }
    }

    private void sendTestProgressRequest() {
        TestProgressRequest testProgressRequest = new TestProgressRequest(this.mySeqNumber, this.myType);
        this.myConnection.sendToBTS((BTSMessage)testProgressRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allowScenarioTermination() {
        Object object = this.abortLock;
        synchronized (object) {
            this.myRunning = false;
            this.myScenarioReady = true;
            this.abortLock.notify();
        }
        this.myLogger.debug((Object)"Trying to interrupt message receiving...");
        this.myConnection.interruptScenario(this.mySeqNumber);
    }

    @Override
    public boolean abort() {
        this.myRunning = false;
        if (this.myConnection != null) {
            StopTestRequest stopTestRequest = new StopTestRequest(this.mySeqNumber, this.myTestType, this.myType);
            this.myConnection.sendToBTS((BTSMessage)stopTestRequest);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort(long timeout) {
        this.myRunning = false;
        if (this.myConnection != null) {
            StopTestRequest stopTestRequest = new StopTestRequest(this.mySeqNumber, this.myTestType, this.myType);
            this.myConnection.sendToBTS((BTSMessage)stopTestRequest);
            Object object = this.abortLock;
            synchronized (object) {
                try {
                    if (!this.myScenarioReady) {
                        this.myLogger.debug((Object)"Stop test timer started");
                        TimerService.getInstance().startTimer(this.timeoutListener, timeout, 1);
                        this.abortLock.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.myLogger.error((Object)e);
                }
            }
            this.myLogger.debug((Object)"Trying to interrupt message receiving...");
            this.myConnection.interruptScenario(this.mySeqNumber);
        }
        return this.abortSuccess;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

