/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.TestReportRequest;
import com.nokia.em.bts.coreasset.message.TestReportResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.btstests.TestReportListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.io.File;
import org.apache.log4j.Logger;

public class WcdmaTestResultsScenario
implements Scenario {
    private BTSConnection myConnection;
    private TestReportListener myTestReportListener;
    private String myReportFile;
    private int myFilter;
    private int mySeqNumber;
    private boolean myRunning = false;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public WcdmaTestResultsScenario(BTSConnection connection, TestReportListener testReportListener, String strReportFile, int intFilter) {
        this.myConnection = connection;
        this.myTestReportListener = testReportListener;
        this.myReportFile = strReportFile;
        this.myFilter = intFilter;
    }

    public WcdmaTestResultsScenario(BTSConnection connection, TestReportListener testReportListener, String strReportFile, int intFilter, BTSMessage.Type type) {
        this(connection, testReportListener, strReportFile, intFilter);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    WcdmaTestResultsScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestFailed(85);
                    return true;
                }
                if (WcdmaTestResultsScenario.this.myConnection == null) {
                    WcdmaTestResultsScenario.this.myLogger.error((Object)"Failed. BTSConnection not found");
                    WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestFailed(-1);
                    return false;
                }
                WcdmaTestResultsScenario.this.mySeqNumber = WcdmaTestResultsScenario.this.myConnection.createScenario();
                TestReportRequest testReportRequest = new TestReportRequest(WcdmaTestResultsScenario.this.mySeqNumber, WcdmaTestResultsScenario.this.myReportFile, WcdmaTestResultsScenario.this.myFilter, WcdmaTestResultsScenario.this.myType);
                WcdmaTestResultsScenario.this.myConnection.sendToBTS((BTSMessage)testReportRequest);
                WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestReportRequested();
                BTSMessage response = WcdmaTestResultsScenario.this.myConnection.receiveFromBTS(WcdmaTestResultsScenario.this.mySeqNumber);
                if (!(response instanceof TestReportResponse)) {
                    WcdmaTestResultsScenario.this.myLogger.error((Object)("Wrong response message is received from BTS. TestReportResponse expected, " + response + " received."));
                    WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestFailed(-1);
                    return false;
                }
                TestReportResponse testReportResponse = (TestReportResponse)response;
                if (testReportResponse.getSuccessCode() == 34) {
                    File file = null;
                    try {
                        FTPTransferInfo ftpTransferInfo = testReportResponse.getFTPTransferInfo();
                        if (ftpTransferInfo == null || ftpTransferInfo.getFileId().equals("Coreasset_Unknown") || ftpTransferInfo.getServerAddress().equals("Coreasset_Unknown")) {
                            ftpTransferInfo = ScenarioManagerImpl.getFTPTransferInfo();
                            ftpTransferInfo.setFileName(WcdmaTestResultsScenario.this.myReportFile);
                            FileTransferClient client = WcdmaTestResultsScenario.this.myConnection.getFileTransferFactory().getFileTransferClient();
                            client.setFTPTransferInfo(ftpTransferInfo);
                            file = client.getFile();
                        } else {
                            FileTransferClient client = WcdmaTestResultsScenario.this.myConnection.getFileTransferFactory().getFileTransferClient();
                            client.setFTPTransferInfo(ftpTransferInfo);
                            file = client.getFile();
                            String[] fileLoads = new String[]{ftpTransferInfo.getFileId()};
                            WcdmaTestResultsScenario.this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(WcdmaTestResultsScenario.this.mySeqNumber, fileLoads));
                        }
                    }
                    catch (Exception e) {
                        WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestFailed(7);
                        WcdmaTestResultsScenario.this.myLogger.error((Object)"test report file transfer.");
                        return false;
                    }
                    if (file != null) {
                        WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestReportReceived(file);
                        return true;
                    }
                    WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestFailed(7);
                    WcdmaTestResultsScenario.this.myLogger.error((Object)"test report file transfer.");
                    return false;
                }
                switch (testReportResponse.getSuccessCode()) {
                    case 41: {
                        WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestFailed(5);
                        return true;
                    }
                    case 42: {
                        WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestFailed(8);
                        return true;
                    }
                }
                WcdmaTestResultsScenario.this.myTestReportListener.cdmaTestFailed(-1);
                return true;
            }

            protected void finished() {
                WcdmaTestResultsScenario.this.myConnection.deleteScenario(WcdmaTestResultsScenario.this.mySeqNumber);
                WcdmaTestResultsScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        if (this.myConnection != null) {
            StopTestRequest stopTestRequest = new StopTestRequest(this.mySeqNumber, "CDMATest", this.myType);
            this.myConnection.sendToBTS((BTSMessage)stopTestRequest);
        } else {
            this.myLogger.error((Object)"Failed. BTSConnection not found");
        }
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

