/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests.rftest;

import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFCell;
import java.util.ArrayList;
import java.util.List;

public final class RFTest {
    private final String myAntenna;
    private List<RFCell> myCells = null;
    private String myIntermodulation = "Coreasset_Unknown";
    private CaptureType myCaptureType = null;
    private int myCaptureLength = -1;

    public RFTest(String antenna, List<RFCell> cells, String intermodulation) {
        this.myAntenna = antenna;
        this.myCells = cells;
        this.myIntermodulation = intermodulation;
    }

    public RFTest(String antenna, RFCell cell, String intermodulation) {
        this.myAntenna = antenna;
        this.myCells = new ArrayList<RFCell>();
        this.myCells.add(cell);
        this.myIntermodulation = intermodulation;
    }

    public RFTest(String antenna, int captureLength, CaptureType captureType) {
        this.myAntenna = antenna;
        this.myCaptureType = captureType;
        this.myCaptureLength = captureLength;
    }

    public RFTest(String antenna, List<RFCell> cells, int captureLength) {
        this.myAntenna = antenna;
        this.myCells = cells;
        this.myCaptureType = CaptureType.RX_CARRIER;
        this.myCaptureLength = captureLength;
    }

    public RFTest(String antenna, RFCell cell, int captureLength) {
        this.myAntenna = antenna;
        this.myCells = new ArrayList<RFCell>();
        this.myCells.add(cell);
        this.myCaptureType = CaptureType.RX_CARRIER;
        this.myCaptureLength = captureLength;
    }

    public RFTest(String antenna, List<RFCell> cells) {
        this.myAntenna = antenna;
        this.myCells = cells;
    }

    public RFTest(String antenna, RFCell cell) {
        this.myAntenna = antenna;
        this.myCells = new ArrayList<RFCell>();
        this.myCells.add(cell);
    }

    public String getAntenna() {
        return this.myAntenna;
    }

    public List<RFCell> getCells() {
        return this.myCells;
    }

    public String getIntermodulation() {
        return this.myIntermodulation;
    }

    public CaptureType getCaptureType() {
        return this.myCaptureType;
    }

    public int getCaptureLength() {
        return this.myCaptureLength;
    }

    public static enum CaptureType {
        TX_FEEDBACK,
        RX_COMBINED,
        RX_COMBINED_RAW,
        RX_CARRIER;

    }
}

