/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests.rftest;

import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFCell;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFTest;
import java.util.List;

public final class RFTestFormatter {
    private static final String ELEMENT_CELL = "Cell";
    private static final String ELEMENT_CELLS = "Cells";
    private static final String ELEMENT_RF_TEST = "RFTest";
    private static final String TAG_STOP_FREQUENCY = "_stopFrequency";
    private static final String TAG_START_FREQUENCY = "_startFrequency";
    private static final String TAG_TX_POWER = "_txPower";
    private static final String TAG_LCR_ID = "_lcrId";
    private static final String TAG_ANTENNA_DN = "_antennaDn";
    private static final String TAG_CAPTURE_TYPE = "_captureType";
    private static final String TAG_CAPTURE_LENGTH = "_captureLength";
    private static final String TAG_INTERMODULATION = "_intermodulation";

    private RFTestFormatter() {
    }

    static String getXMLForTestData(List<RFTest> testData) {
        StringBuffer sb = new StringBuffer();
        if (testData != null) {
            for (RFTest test : testData) {
                sb.append(RFTestFormatter.getXMLForTest(test));
            }
        }
        return sb.toString();
    }

    static String getXMLForTest(RFTest test) {
        StringBuffer sb = new StringBuffer();
        if (test != null) {
            sb.append(RFTestFormatter.getStartTag(ELEMENT_RF_TEST));
            sb.append(RFTestFormatter.getXMLForCells(test.getCells()));
            sb.append(RFTestFormatter.getXMLForAntenna(test.getAntenna()));
            sb.append(RFTestFormatter.getXMLForParameters(test));
            sb.append(RFTestFormatter.getEndTag(ELEMENT_RF_TEST));
        }
        return sb.toString();
    }

    static String getXMLForParameters(RFTest test) {
        StringBuffer sb = new StringBuffer();
        sb.append(RFTestFormatter.getXMLFor(TAG_INTERMODULATION, test.getIntermodulation()));
        sb.append(RFTestFormatter.getXMLFor(TAG_CAPTURE_LENGTH, test.getCaptureLength()));
        sb.append(RFTestFormatter.getXMLFor(TAG_CAPTURE_TYPE, (Object)test.getCaptureType()));
        return sb.toString();
    }

    static String getXMLForAntenna(String antenna) {
        StringBuffer sb = new StringBuffer();
        if (antenna != null) {
            sb.append(RFTestFormatter.getXMLFor(TAG_ANTENNA_DN, antenna));
        }
        return sb.toString();
    }

    private static String getXMLForCells(List<RFCell> cells) {
        StringBuffer sb = new StringBuffer();
        if (cells != null) {
            sb.append(RFTestFormatter.getStartTag(ELEMENT_CELLS));
            for (RFCell cell : cells) {
                sb.append(RFTestFormatter.getXMLForCell(cell));
            }
            sb.append(RFTestFormatter.getEndTag(ELEMENT_CELLS));
        }
        return sb.toString();
    }

    static String getXMLForCell(RFCell cell) {
        StringBuffer sb = new StringBuffer();
        if (cell != null) {
            sb.append(RFTestFormatter.getStartTag(ELEMENT_CELL));
            sb.append(RFTestFormatter.getXMLFor(TAG_LCR_ID, cell.getLcrId()));
            sb.append(RFTestFormatter.getXMLFor(TAG_TX_POWER, cell.getTxPower()));
            sb.append(RFTestFormatter.getXMLFor(TAG_START_FREQUENCY, cell.getStartFrequency()));
            sb.append(RFTestFormatter.getXMLFor(TAG_STOP_FREQUENCY, cell.getStopFrequency()));
            sb.append(RFTestFormatter.getEndTag(ELEMENT_CELL));
        }
        return sb.toString();
    }

    protected static String getXMLFor(String tag, int value) {
        if (value != -1) {
            return RFTestFormatter.wrapInTags(tag, value);
        }
        return "";
    }

    protected static String getXMLFor(String tag, float value) {
        if (value != -1.0f) {
            return RFTestFormatter.wrapInTags(tag, Float.valueOf(value));
        }
        return "";
    }

    protected static String getXMLFor(String tag, String value) {
        if (!"Coreasset_Unknown".equals(value)) {
            return RFTestFormatter.wrapInTags(tag, value);
        }
        return "";
    }

    protected static String getXMLFor(String tag, Object value) {
        if (value != null) {
            return RFTestFormatter.wrapInTags(tag, value);
        }
        return "";
    }

    protected static String getStartTag(String tag) {
        return "<" + tag + ">";
    }

    protected static String getEndTag(String tag) {
        return "</" + tag + ">";
    }

    protected static String wrapInTags(String tag, Object value) {
        return String.valueOf(RFTestFormatter.getStartTag(tag)) + value + RFTestFormatter.getEndTag(tag);
    }
}

