/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests.rftest;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.OperationFeedback;
import com.nokia.em.bts.coreasset.message.StartTestRequest;
import com.nokia.em.bts.coreasset.message.StartTestResponse;
import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.message.TestCompletedNotif;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTest;
import com.nokia.em.bts.coreasset.scenario.btstests.BtsTest;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFTest;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFTestFormatter;
import com.nokia.em.bts.coreasset.scenario.btstests.rftest.RFTestListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.FileLoadPrepare;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RFTestScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private RFTestListener myTestListener;
    private String myTestParameters;
    private RFTestListener.TestInfo myTestInfo;
    private ActiveTest myActiveTest;
    private boolean myIsRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private ActionListener myOperationFeedbackSender = null;
    private static final int OPERATION_FEEDBACK_DELAY = 120000;
    int mySeqNum;
    private static final int GET_FILE_RETRY_COUNT = 3;
    private static final int GET_FILE_RETRY_DELAY = 10000;

    public RFTestScenario(BTSConnection connection, RFTestListener testListener, RFTestListener.TestInfo testInfo, List<RFTest> testData) {
        this.init(connection, testListener, testInfo, testData);
        this.myActiveTest = ActiveTest.getInstance();
        this.myOperationFeedbackSender = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RFTestScenario.this.myBTSConnection.sendToBTS((BTSMessage)new OperationFeedback(RFTestScenario.this.mySeqNum));
            }
        };
    }

    public RFTestScenario(BTSConnection connection, RFTestListener testListener, RFTestListener.TestInfo testInfo, RFTest rfTest) {
        ArrayList<RFTest> list = new ArrayList<RFTest>();
        list.add(rfTest);
        this.init(connection, testListener, testInfo, list);
        this.myActiveTest = ActiveTest.getInstance();
        this.myOperationFeedbackSender = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RFTestScenario.this.myBTSConnection.sendToBTS((BTSMessage)new OperationFeedback(RFTestScenario.this.mySeqNum));
            }
        };
    }

    private void init(BTSConnection connection, RFTestListener testListener, RFTestListener.TestInfo testInfo, List<RFTest> testData) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myTestListener = testListener;
        this.myTestInfo = testInfo;
        this.myTestParameters = RFTestFormatter.getXMLForTestData(testData);
    }

    public RFTestListener.TestInfo getTestInfo() {
        return this.myTestInfo;
    }

    public boolean isRunning() {
        return this.myIsRunning;
    }

    @Override
    public void execute() {
        this.myLogger.debug((Object)"execute");
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myIsRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return RFTestScenario.this.runScenario();
            }

            protected void finished() {
                RFTestScenario.this.myBTSConnection.deleteScenario(RFTestScenario.this.mySeqNum);
                RFTestScenario.this.myIsRunning = false;
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        this.myLogger.debug((Object)"runScenario");
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myTestListener.startFailed(RFTestListener.StartFailure.NO_SNAPSHOT);
            return true;
        }
        this.mySeqNum = this.myBTSConnection.createScenario();
        this.myBTSConnection.sendToBTS((BTSMessage)new StartTestRequest(this.mySeqNum, this.myTestInfo.toString(), this.myTestParameters, this.myType));
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNum, 200000L);
        if (response instanceof StartTestResponse) {
            StartTestResponse startResponse = (StartTestResponse)response;
            if (startResponse.getSuccessCode() != 34) {
                this.informStartFailure(startResponse.getSuccessCode());
                return false;
            }
            this.myActiveTest.addActiveTest(new BtsTest(this.myTestInfo.toString(), this.mySeqNum, true));
            this.myTestListener.started();
            do {
                response = this.myBTSConnection.receiveFromBTS(this.mySeqNum, 200000L);
                this.handleResponse(response);
            } while (this.myIsRunning);
        } else if (response instanceof Timeout) {
            this.myTestListener.startFailed(RFTestListener.StartFailure.TIMEOUT);
        } else if (response == null) {
            this.myTestListener.startFailed(RFTestListener.StartFailure.INVALID_MESSAGE);
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. StartTestResponse expected.");
            this.myTestListener.startFailed(RFTestListener.StartFailure.INVALID_MESSAGE);
        }
        return false;
    }

    private void informStartFailure(int successCode) {
        switch (successCode) {
            case 108: {
                this.myTestListener.startFailed(RFTestListener.StartFailure.RFSW_REJECTING);
                break;
            }
            case 129: {
                this.myTestListener.startFailed(RFTestListener.StartFailure.INVALID_BTS_STATE);
                break;
            }
            case 65: {
                this.myTestListener.startFailed(RFTestListener.StartFailure.INVALID_DATA);
                break;
            }
            case 130: {
                this.myTestListener.startFailed(RFTestListener.StartFailure.TEST_MODEL_START_FAIL);
                break;
            }
            case 77: {
                this.myTestListener.startFailed(RFTestListener.StartFailure.MISSING_LICENCE);
                break;
            }
            case 42: {
                this.myTestListener.startFailed(RFTestListener.StartFailure.INVALID_PARAMETER);
                break;
            }
            case 136: {
                this.myTestListener.startFailed(RFTestListener.StartFailure.FAILURE);
                break;
            }
            default: {
                this.myTestListener.startFailed(RFTestListener.StartFailure.UNKNOWN_REASON);
            }
        }
    }

    @Override
    public boolean abort() {
        BtsTest activeTest = this.myActiveTest.getActiveTest(this.myTestInfo.toString());
        if (activeTest != null) {
            this.myBTSConnection.sendToBTS((BTSMessage)new StopTestRequest(activeTest.getSequenceNumber(), this.myTestInfo.toString(), this.myType));
        } else {
            this.myLogger.error((Object)("Unable to abort, " + (Object)((Object)this.myTestInfo) + " not found from active tests"));
        }
        if (this.myOperationFeedbackSender != null) {
            TimerService.getInstance().stopTimer(this.myOperationFeedbackSender);
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() throws Exception {
                do {
                    BTSMessage response = RFTestScenario.this.myBTSConnection.receiveFromBTS(RFTestScenario.this.mySeqNum, 200000L);
                    RFTestScenario.this.handleResponse(response);
                } while (RFTestScenario.this.myIsRunning);
                return true;
            }
        };
        worker.start();
        return true;
    }

    private void handleResponse(BTSMessage response) {
        if (response instanceof StopTestResponse) {
            this.handleStopTestResponse(response);
        } else if (response instanceof TestCompletedNotif) {
            this.handleTestCompletedNotif(response);
        } else if (response instanceof FileLoadPrepare) {
            this.handleFileLoadPrepare(response);
        } else if (response instanceof Timeout) {
            this.handleTimeoutResponse();
        } else if (response == null) {
            this.handleNullResponse();
        }
    }

    private void handleStopTestResponse(BTSMessage response) {
        StopTestResponse stopTestResponse = (StopTestResponse)response;
        switch (stopTestResponse.getSuccessCode()) {
            case 34: {
                this.handleNullResponse();
                break;
            }
            case 39: {
                this.myActiveTest.removeActiveTest(this.mySeqNum);
                this.myTestListener.abortFailed(RFTestListener.AbortFailure.NO_TEST);
                this.myIsRunning = false;
                break;
            }
            default: {
                this.myTestListener.abortFailed(RFTestListener.AbortFailure.UNKNOWN_REASON);
            }
        }
    }

    private void informCompletion(int testSuccess) {
        switch (testSuccess) {
            case 34: {
                this.myTestListener.completed(RFTestListener.TestSuccess.OK);
                break;
            }
            case 126: {
                this.myTestListener.completed(RFTestListener.TestSuccess.UNABLE_TO_STORE_FILE);
                break;
            }
            case 127: {
                this.myTestListener.completed(RFTestListener.TestSuccess.UNABLE_TO_GENERATE_FILE);
                break;
            }
            case 128: {
                this.myTestListener.completed(RFTestListener.TestSuccess.UNABLE_TO_EXECUTE);
                break;
            }
            case 58: {
                this.myTestListener.completed(RFTestListener.TestSuccess.TELECOM_NOT_RESPONDING);
                break;
            }
            case 135: {
                this.myTestListener.completed(RFTestListener.TestSuccess.TELECOM_NOT_RELEASED);
                break;
            }
            default: {
                this.myTestListener.completed(RFTestListener.TestSuccess.UNKNOWN_RESULT);
            }
        }
    }

    private void handleTimeoutResponse() {
        this.myTestListener.timeout();
    }

    private void handleNullResponse() {
        this.myActiveTest.removeActiveTest(this.mySeqNum);
        this.myTestListener.aborted();
        this.myIsRunning = false;
    }

    private void handleFileLoadPrepare(BTSMessage response) {
        FileLoadPrepare flp = (FileLoadPrepare)response;
        if (flp.getCause() == 36 || flp.getCause() == -1) {
            FTPTransferInfo ftpInfo = (FTPTransferInfo)flp.getFTPTransferInfo().get(0);
            String fileId = ftpInfo.getFileId();
            if (fileId != null && fileId.trim().length() != 0) {
                RFTestListenerFileTransferAdapter fileTransferListener = new RFTestListenerFileTransferAdapter();
                int retryCount = 0;
                File file = null;
                while (retryCount < 3 && this.myIsRunning) {
                    try {
                        file = this.getTransferFile(fileTransferListener, ftpInfo);
                        if (file != null) {
                            file.deleteOnExit();
                            TimerService.getInstance().stopTimer(this.myOperationFeedbackSender);
                            this.myTestListener.fileReceived(fileId, file.getAbsolutePath());
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.myLogger.error((Object)"Fetching RF test file error.", (Throwable)e);
                    }
                    TimerService.getInstance().stopTimer(this.myOperationFeedbackSender);
                    this.retryDelay();
                    ++retryCount;
                }
                FileLoadCompleted message = new FileLoadCompleted(this.mySeqNum, new String[]{fileId}, 131);
                if (retryCount == 3 || !this.myIsRunning) {
                    this.myLogger.debug((Object)("After 3 retries, failed to get file: " + fileId));
                    this.myTestListener.fileTransferFailed(fileId);
                    message.setCause(37);
                }
                this.myBTSConnection.sendToBTS((BTSMessage)message);
            } else {
                this.myLogger.debug((Object)"Null fileId received.");
            }
        }
    }

    private File getTransferFile(FileTransferListener fileTransferListener, FTPTransferInfo ftpInfo) throws FileTransferException {
        FileTransferClient ftpClient = this.myBTSConnection.getFileTransferFactory().getFileTransferClient();
        ftpClient.setFTPTransferInfo(ftpInfo);
        return ftpClient.getFile(fileTransferListener);
    }

    private void retryDelay() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            this.myLogger.error((Object)"InterruptedException.", (Throwable)e);
        }
    }

    private void handleTestCompletedNotif(BTSMessage response) {
        TestCompletedNotif tcn = (TestCompletedNotif)response;
        this.myActiveTest.removeActiveTest(this.mySeqNum);
        this.informCompletion(tcn.getRFTestResult());
        this.myIsRunning = false;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    private class RFTestListenerFileTransferAdapter
    implements FileTransferListener {
        private RFTestListenerFileTransferAdapter() {
        }

        public void fileTransferSucceeded(String strFileId) {
        }

        public void fileTransferFailed(String strFileId) {
        }

        public void fileTransferStarted(String strFileId, long lSize) {
            RFTestScenario.this.myBTSConnection.sendToBTS((BTSMessage)new OperationFeedback(RFTestScenario.this.mySeqNum));
            TimerService.getInstance().startTimer(RFTestScenario.this.myOperationFeedbackSender, 120000L);
            RFTestScenario.this.myTestListener.fileTransferStarted();
        }

        public void fileTransferUpdated(String strFileId, float fPercentage) {
        }

        public void fileSetTransferUpdated(float fPercentage) {
        }

        public void fileSetTransferStarted() {
        }

        public void fileSetTransferCancelled() {
        }

        public void fileSetTransferCancellingFailed(int intFailReason) {
        }

        public void fileSetTransferRejected(int nackReason) {
        }

        public void fileSetTransferFailed(int intFailReason) {
        }

        public void fileSetTransferFailed(int intFailReason, String errorMessage) {
        }

        public void fileSetTransferCompleted(String strFileId) {
        }

        public void fileTransferPhaseCompleted(String strFileId, int phase, int result) {
        }
    }
}

