/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.btstests.sfpdatamonitoring;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.SFPDiagnosticDataMonitoringNotification;
import com.nokia.em.bts.coreasset.message.SFPDiagnosticDataMonitoringStartRequest;
import com.nokia.em.bts.coreasset.message.SFPDiagnosticDataMonitoringStopRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.sfpdatamonitoring.SFPDiagnosticData;
import com.nokia.em.bts.coreasset.scenario.btstests.sfpdatamonitoring.SFPDiagnosticDataMonitoringListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class SFPDiagnosticDataMonitoringScenario
implements Scenario,
BTSNotificationListener {
    private BTSConnection myConnection;
    private SFPDiagnosticDataMonitoringListener myListener;
    private Logger myLogger;
    private boolean myIsRunning;
    private int mySeqNumber;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SFPDiagnosticDataMonitoringScenario(BTSConnection connection, SFPDiagnosticDataMonitoringListener listener) {
        this.myConnection = connection;
        this.myListener = listener;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myIsRunning = false;
    }

    public SFPDiagnosticDataMonitoringScenario(BTSConnection connection, SFPDiagnosticDataMonitoringListener listener, BTSMessage.Type type) {
        this(connection, listener);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myListener.sfpDiagnosticDataStartFailed(85);
        }
        this.setIsRunning(true);
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                SFPDiagnosticDataMonitoringScenario.this.runScenario();
                return true;
            }
        };
        worker.start();
    }

    public void cleanup() {
        this.myConnection.unsubscribeNotification((BTSNotificationListener)this);
    }

    @Override
    public boolean abort() {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                SFPDiagnosticDataMonitoringScenario.this.sendStopRequest();
                return true;
            }
        };
        worker.start();
        return true;
    }

    protected void runScenario() {
        this.mySeqNumber = this.myConnection.createScenario();
        this.myConnection.subscribeNotification((BTSNotificationListener)this);
        this.sendStartRequest();
    }

    private void sendStartRequest() {
        SFPDiagnosticDataMonitoringStartRequest startRequest = new SFPDiagnosticDataMonitoringStartRequest(this.mySeqNumber, this.myType);
        this.myConnection.sendToBTS((BTSMessage)startRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Timeout) {
            this.myListener.sfpDiagnosticDataStartFailed(68);
        } else if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (ack.getAck()) {
                this.myListener.sfpDiagnosticDataStarted();
                return;
            }
            this.myListener.sfpDiagnosticDataStartFailed(ack.getNackReason());
        } else if (response != null) {
            this.myListener.sfpDiagnosticDataStartFailed(28);
        }
        this.myConnection.unsubscribeNotification((BTSNotificationListener)this);
        this.myConnection.deleteScenario(this.mySeqNumber);
        this.setIsRunning(false);
    }

    private void sendStopRequest() {
        this.myConnection.clearPreviousResponse(this.mySeqNumber);
        this.myConnection.sendToBTS((BTSMessage)new SFPDiagnosticDataMonitoringStopRequest(this.mySeqNumber, this.myType));
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                this.myListener.sfpDiagnosticDataStopFailed(ack.getNackReason());
            } else {
                this.myListener.sfpDiagnosticDataStopped();
                this.setIsRunning(false);
                this.myConnection.unsubscribeNotification((BTSNotificationListener)this);
                this.myConnection.deleteScenario(this.mySeqNumber);
            }
        } else if (response instanceof Timeout) {
            this.myListener.sfpDiagnosticDataStopFailed(68);
        } else if (response != null) {
            this.myListener.sfpDiagnosticDataStopFailed(28);
        }
    }

    public void btsNotificationReceived(BTSMessage btsMessage) {
        if (btsMessage instanceof SFPDiagnosticDataMonitoringNotification) {
            SFPDiagnosticDataMonitoringNotification notif = (SFPDiagnosticDataMonitoringNotification)btsMessage;
            Node node = notif.getData();
            SFPDiagnosticData data = new SFPDiagnosticData(node);
            this.myListener.sfpDiagnosticDataReceived(data);
        }
    }

    private synchronized void setIsRunning(boolean value) {
        this.myIsRunning = value;
    }

    private synchronized boolean isRunning() {
        return this.myIsRunning;
    }
}

