/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.cabinettests;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.StartTestRequest;
import com.nokia.em.bts.coreasset.message.StartTestResponse;
import com.nokia.em.bts.coreasset.message.StopTestRequest;
import com.nokia.em.bts.coreasset.message.StopTestResponse;
import com.nokia.em.bts.coreasset.message.TestCompletedNotif;
import com.nokia.em.bts.coreasset.message.TestReportNotifCab;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.btstests.ActiveTest;
import com.nokia.em.bts.coreasset.scenario.btstests.BtsTest;
import com.nokia.em.bts.coreasset.scenario.cabinettests.CabinetTest;
import com.nokia.em.bts.coreasset.scenario.cabinettests.CabinetTestImpl;
import com.nokia.em.bts.coreasset.scenario.cabinettests.CabinetTestListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CabinetTestScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private CabinetTestListener myCabinetTestListener;
    private String myTestParameters;
    private String myTestType;
    private int myCabTestDuration;
    private boolean myRunning = false;
    private boolean myAborted = false;
    private int mySeqNumber;
    private ActiveTest myActiveTest;
    private static final int MILLISECOND_FACTOR = 1000;
    private static final String CABINET_TEST_DATA_NODENAME = "CabTestData";
    private static final String CABINET_CABTESTTYPE_NODENAME = "_cabTestType";
    private static final String CABINET_HWRESOURCE_NODENAME = "_hwResource";
    private static final String CABINET_COMPONENT_NODENAME = "_component";
    private static final String CABINET_TESTVERDICT_NODENAME = "_testVerdict";
    private static final String CABINET_TESTVERDICT_OK_NODEVALUE = "ok";
    private static final String CABINET_TESTVERDICT_PASS_NODEVALUE = "pass";
    private static final String CABINET_TESTVERDICT_FAIL_NODEVALUE = "fail";
    private static final String CABINET_TESTVERDICT_NOTTESTED_NODEVALUE = "notTested";
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private static Logger myLogger = Logger.getLogger(CabinetTestScenario.class);

    public CabinetTestScenario(BTSConnection connection, CabinetTestListener cabinetTestListener, int cabTestDuration, boolean antennaTiltExcerciseIncluded, int antennaPackAmount, int antennaSuccessLimitPromille, int antennaMaxConsecutiveFailures, int ethernetPackAmount, int ethernetPackSize, int ethernetPackInterval, int ethernetSuccessLimitPromille) {
        this.myBTSConnection = connection;
        this.myCabinetTestListener = cabinetTestListener;
        this.myTestType = "cabinetTest";
        this.myCabTestDuration = cabTestDuration;
        StringBuffer testParameters = new StringBuffer();
        testParameters.append("<_cabTestDuration>" + cabTestDuration + "</_cabTestDuration>");
        testParameters.append("<CabinetTestDataEth>");
        testParameters.append("<_packAmount>" + ethernetPackAmount + "</_packAmount>");
        testParameters.append("<_packSize>" + ethernetPackSize + "</_packSize>");
        testParameters.append("<_packInterval>" + ethernetPackInterval + "</_packInterval>");
        testParameters.append("<_successLimitPermillage>" + ethernetSuccessLimitPromille + "</_successLimitPermillage>");
        testParameters.append("</CabinetTestDataEth>");
        testParameters.append("<CabinetTestDataAnt>");
        testParameters.append("<_packAmount>" + antennaPackAmount + "</_packAmount>");
        testParameters.append("<_successLimitPermillage>" + antennaSuccessLimitPromille + "</_successLimitPermillage>");
        testParameters.append("<_maxConsecFailures>" + antennaMaxConsecutiveFailures + "</_maxConsecFailures>");
        testParameters.append("</CabinetTestDataAnt>");
        testParameters.append("<_antTiltExcercIncl>" + antennaTiltExcerciseIncluded + "</_antTiltExcercIncl>");
        this.myTestParameters = testParameters.toString();
        this.myActiveTest = ActiveTest.getInstance();
    }

    public CabinetTestScenario(BTSConnection connection, CabinetTestListener cabinetTestListener, int cabTestDuration, boolean antennaTiltExcerciseIncluded, int antennaPackAmount, int antennaSuccessLimitPromille, int antennaMaxConsecutiveFailures, int ethernetPackAmount, int ethernetPackSize, int ethernetPackInterval, int ethernetSuccessLimitPromille, BTSMessage.Type type) {
        this(connection, cabinetTestListener, cabTestDuration, antennaTiltExcerciseIncluded, antennaPackAmount, antennaSuccessLimitPromille, antennaMaxConsecutiveFailures, ethernetPackAmount, ethernetPackSize, ethernetPackInterval, ethernetSuccessLimitPromille);
        this.myType = type;
    }

    public static List<CabinetTest> parseXML(Element xmlElement) {
        NodeList dataNodeList = xmlElement.getElementsByTagName(CABINET_TEST_DATA_NODENAME);
        ArrayList<CabinetTest> cabinetTests = new ArrayList<CabinetTest>();
        String cabTestType = "Coreasset_Unknown";
        String hwResource = "Coreasset_Unknown";
        String component = "Coreasset_Unknown";
        int testVerdict = -1;
        int i = 0;
        while (i < dataNodeList.getLength()) {
            try {
                Node node = dataNodeList.item(i);
                NodeList childNodes = node.getChildNodes();
                cabTestType = "Coreasset_Unknown";
                hwResource = "Coreasset_Unknown";
                component = "Coreasset_Unknown";
                testVerdict = -1;
                int j = 0;
                while (j < childNodes.getLength()) {
                    Node childNode = childNodes.item(j);
                    if (childNode.hasChildNodes()) {
                        String childNodeName = childNode.getNodeName();
                        String childNodeValue = childNode.getFirstChild().getNodeValue().trim();
                        if (childNodeName.equalsIgnoreCase(CABINET_CABTESTTYPE_NODENAME)) {
                            cabTestType = childNodeValue;
                        } else if (childNodeName.equalsIgnoreCase(CABINET_HWRESOURCE_NODENAME)) {
                            hwResource = childNodeValue;
                        } else if (childNodeName.equalsIgnoreCase(CABINET_COMPONENT_NODENAME)) {
                            component = childNodeValue;
                        } else if (childNodeName.equalsIgnoreCase(CABINET_TESTVERDICT_NODENAME)) {
                            if (childNodeValue.equalsIgnoreCase(CABINET_TESTVERDICT_OK_NODEVALUE)) {
                                testVerdict = 0;
                            } else if (childNodeValue.equalsIgnoreCase(CABINET_TESTVERDICT_PASS_NODEVALUE)) {
                                testVerdict = 1;
                            } else if (childNodeValue.equalsIgnoreCase(CABINET_TESTVERDICT_FAIL_NODEVALUE)) {
                                testVerdict = 2;
                            } else if (childNodeValue.equalsIgnoreCase(CABINET_TESTVERDICT_NOTTESTED_NODEVALUE)) {
                                testVerdict = 3;
                            }
                        }
                    }
                    ++j;
                }
                cabinetTests.add(new CabinetTestImpl(cabTestType, hwResource, component, testVerdict));
            }
            catch (Exception e) {
                myLogger.error((Object)("Problems in parsing object, cabTestType:" + cabTestType + " hwResource:" + hwResource + " component:" + component + " testVerdict:" + testVerdict + " ERROR:" + e.getMessage()));
            }
            ++i;
        }
        cabinetTests.trimToSize();
        return cabinetTests;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        myLogger.debug((Object)"executing Cabinet Test");
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    myLogger.debug((Object)"Snapshot open not supported.");
                    CabinetTestScenario.this.myCabinetTestListener.testStartFailed(85);
                    return true;
                }
                CabinetTestScenario.this.mySeqNumber = CabinetTestScenario.this.myBTSConnection.createScenario();
                StartTestRequest startTestRequest = new StartTestRequest(CabinetTestScenario.this.mySeqNumber, CabinetTestScenario.this.myTestType, CabinetTestScenario.this.myTestParameters, CabinetTestScenario.this.myType);
                CabinetTestScenario.this.myBTSConnection.sendToBTS((BTSMessage)startTestRequest);
                BTSMessage response = CabinetTestScenario.this.myBTSConnection.receiveFromBTS(CabinetTestScenario.this.mySeqNumber);
                if (response instanceof StartTestResponse) {
                    List<CabinetTest> cabinetTests;
                    StartTestResponse startResponse = (StartTestResponse)response;
                    if (startResponse.getSuccessCode() != 34) {
                        CabinetTestScenario.this.sendTestStartFailed(startResponse.getSuccessCode());
                        return false;
                    }
                    long duration = startResponse.getCabinetTestEstimatedDuration();
                    FTPTransferInfo ftpTransferInfo = startResponse.getCabinetTestFTPTransferInfo();
                    try {
                        FileTransferClient client = CabinetTestScenario.this.myBTSConnection.getFileTransferFactory().getFileTransferClient();
                        client.setFTPTransferInfo(ftpTransferInfo);
                        File xmlFile = client.getFile();
                        cabinetTests = CabinetTestScenario.parseXML(Tools.parseElement((String)xmlFile.getAbsolutePath()));
                    }
                    catch (FileTransferException e) {
                        myLogger.error((Object)"Cannot get file.");
                        CabinetTestScenario.this.myCabinetTestListener.testStartFailed(81);
                        return false;
                    }
                    catch (Exception ex) {
                        myLogger.error((Object)("Unexpected error. " + ex.getMessage()));
                        CabinetTestScenario.this.myCabinetTestListener.testStartFailed(-1);
                        return false;
                    }
                    if (CabinetTestScenario.this.myAborted) {
                        CabinetTestScenario.this.myCabinetTestListener.testStartFailed(62);
                        return false;
                    }
                    BtsTest thisTest = new BtsTest(CabinetTestScenario.this.myTestType, CabinetTestScenario.this.mySeqNumber, true);
                    CabinetTestScenario.this.myActiveTest.addActiveTest(thisTest);
                    CabinetTestScenario.this.myCabinetTestListener.testStarted(duration, cabinetTests);
                    CabinetTestScenario.this.myBTSConnection.sendToBTS((BTSMessage)new FileLoadCompleted(CabinetTestScenario.this.mySeqNumber, new String[]{ftpTransferInfo.getFileId()}));
                    if (CabinetTestScenario.this.myCabTestDuration > 0) {
                        TimerService.getInstance().startTimer(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                CabinetTestScenario.this.abort();
                            }
                        }, (long)(CabinetTestScenario.this.myCabTestDuration * 1000), 1);
                    }
                    while (true) {
                        if ((response = CabinetTestScenario.this.myBTSConnection.receiveFromBTS(CabinetTestScenario.this.mySeqNumber)) instanceof TestReportNotifCab) {
                            CabinetTestScenario.this.sendTestReported((TestReportNotifCab)response);
                            continue;
                        }
                        if (response instanceof TestCompletedNotif) {
                            TestCompletedNotif testCompletedNotif = (TestCompletedNotif)response;
                            CabinetTestScenario.this.myCabinetTestListener.testFinished(testCompletedNotif.getCabinetTestSuccess());
                            CabinetTestScenario.this.myActiveTest.removeActiveTest(CabinetTestScenario.this.mySeqNumber);
                            return true;
                        }
                        if (response instanceof StopTestResponse) {
                            StopTestResponse stopTestResponse = (StopTestResponse)response;
                            CabinetTestScenario.this.myCabinetTestListener.testStopped(stopTestResponse.getSuccessCode());
                            continue;
                        }
                        if (response == null) break;
                    }
                    CabinetTestScenario.this.myActiveTest.removeActiveTest(CabinetTestScenario.this.mySeqNumber);
                    CabinetTestScenario.this.myCabinetTestListener.testFinished(37);
                    return true;
                }
                if (CabinetTestScenario.this.myAborted) {
                    myLogger.error((Object)"Aborted.");
                    CabinetTestScenario.this.myCabinetTestListener.testStartFailed(62);
                } else {
                    myLogger.error((Object)"Wrong reply received from BTS. StartTestResponse expected.");
                    CabinetTestScenario.this.myCabinetTestListener.testStartFailed(28);
                }
                return false;
            }

            protected void finished() {
                CabinetTestScenario.this.myBTSConnection.deleteScenario(CabinetTestScenario.this.mySeqNumber);
                CabinetTestScenario.this.myAborted = false;
                CabinetTestScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myAborted = true;
            if (this.myActiveTest.getActiveTest(0, this.myTestType) == null) {
                this.myBTSConnection.interruptScenario(this.mySeqNumber);
            }
            StopTestRequest message = new StopTestRequest(this.mySeqNumber, this.myTestType);
            this.myBTSConnection.sendToBTS((BTSMessage)message);
        } else {
            myLogger.debug((Object)"Cannot abort, not running.");
        }
        return true;
    }

    private void sendTestStartFailed(int successCode) {
        switch (successCode) {
            case 42: {
                this.myCabinetTestListener.testStartFailed(42);
                break;
            }
            case 60: {
                this.myCabinetTestListener.testStartFailed(60);
                break;
            }
            case 62: {
                this.myCabinetTestListener.testStartFailed(62);
                break;
            }
            case 27: {
                this.myCabinetTestListener.testStartFailed(27);
                break;
            }
            default: {
                this.myCabinetTestListener.testStartFailed(-1);
            }
        }
    }

    private void sendTestReported(TestReportNotifCab response) {
        List<CabinetTest> cabinetTestRaports = response.getCabTestResults();
        for (CabinetTest test : cabinetTestRaports) {
            if (test != null) {
                try {
                    this.myCabinetTestListener.testReported(test);
                }
                catch (Exception e) {
                    myLogger.error((Object)("GUI did not like our test report, type:" + test.getCabTestType() + " comp:" + test.getComponent() + " hwr:" + test.getHwResource() + " verd:" + test.getTestVerdict()));
                }
                continue;
            }
            myLogger.debug((Object)"Possible problem, test was null.");
        }
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

