/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.commissioning;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.commissioning.SCFTransferListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.CommissioningReply;
import com.nokia.em.bts.rp.master.message.CommissioningRequest;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class GetCommissioningScenario
implements Scenario {
    private final SCFTransferListener myListener;
    private final Logger myLogger;
    private final BTSConnection myConnection;
    protected List<String> myFiles;
    protected List<String> myStartedFiles;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public GetCommissioningScenario(SCFTransferListener listener, BTSConnection connection) {
        this.myListener = listener;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFiles = new CopyOnWriteArrayList<String>();
        this.myStartedFiles = new CopyOnWriteArrayList<String>();
    }

    public GetCommissioningScenario(SCFTransferListener listener, BTSConnection connection, BTSMessage.Type type) {
        this(listener, connection);
        this.myType = type;
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"This scenario cannot be aborted.");
        return true;
    }

    @Override
    public void execute() {
        CoreAssetThread commissioningWorker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    GetCommissioningScenario.this.myLogger.debug((Object)"No support for snapshot opening.");
                    GetCommissioningScenario.this.myListener.fileTransfersFailed(85);
                    return true;
                }
                int seqNumber = GetCommissioningScenario.this.myConnection.createScenario();
                CommissioningRequest commissioningRequest = new CommissioningRequest(seqNumber, GetCommissioningScenario.this.myType);
                GetCommissioningScenario.this.myConnection.sendToBTS((BTSMessage)commissioningRequest);
                BTSMessage response = GetCommissioningScenario.this.myConnection.receiveFromBTS(seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (ackResponse.getAck()) {
                        response = GetCommissioningScenario.this.myConnection.receiveFromBTS(seqNumber);
                    } else {
                        GetCommissioningScenario.this.myConnection.deleteScenario(seqNumber);
                        GetCommissioningScenario.this.myLogger.debug((Object)("CommissioningStateUnknown. BTS replied Nack to CommissionRequest with reason " + ackResponse.getNackReason()));
                        GetCommissioningScenario.this.myListener.fileTransfersFailed(ackResponse.getNackReason());
                        return false;
                    }
                }
                if (response instanceof CommissioningReply) {
                    GetCommissioningScenario.this.myConnection.deleteScenario(seqNumber);
                    CommissioningReply commissioningReply = (CommissioningReply)response;
                    GetCommissioningScenario.this.myConnection.setBTSId(commissioningReply.getBtsId());
                    List ftpTransferInfos = commissioningReply.getFTPTransferInfo();
                    if (ftpTransferInfos != null && ftpTransferInfos.size() > 0) {
                        ScenarioManagerImpl.setFTPTransferInfo((FTPTransferInfo)ftpTransferInfos.get(0));
                        for (FTPTransferInfo info : ftpTransferInfos) {
                            FileTransferClient client = GetCommissioningScenario.this.myConnection.getFileTransferFactory().getFileTransferClient();
                            client.setFTPTransferInfo(info);
                            try {
                                GetCommissioningScenario.this.myFiles.add(info.getFileId());
                                GetCommissioningScenario.this.myStartedFiles.add(info.getFileId());
                                client.getFile((FileTransferListener)new FileTransferListenerImpl());
                            }
                            catch (FileTransferException e) {
                                GetCommissioningScenario.this.myListener.fileTransferFailed(info.getFileId());
                            }
                            GetCommissioningScenario.this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(seqNumber, new String[]{info.getFileId()}));
                        }
                        GetCommissioningScenario.this.myListener.fileTransfersFinished();
                        return true;
                    }
                    GetCommissioningScenario.this.myListener.fileTransfersFinished();
                    return null;
                }
                GetCommissioningScenario.this.myConnection.deleteScenario(seqNumber);
                GetCommissioningScenario.this.myLogger.error((Object)"Wrong reply received from BTS. CommissioningReply or Ack expected.");
                GetCommissioningScenario.this.myListener.fileTransfersFailed(28);
                return null;
            }
        };
        commissioningWorker.start();
    }

    private class FileTransferListenerImpl
    extends FileTransferAdapter {
        private FileTransferListenerImpl() {
        }

        public void fileTransferFailed(String strFileId) {
            GetCommissioningScenario.this.myListener.fileTransferFailed(GetCommissioningScenario.this.myFiles.remove(0));
        }

        public void fileTransferStarted(String strFileId, long size) {
            GetCommissioningScenario.this.myListener.fileTransferStarted(GetCommissioningScenario.this.myStartedFiles.remove(0));
        }

        public void fileTransferSucceeded(String strFileId) {
            GetCommissioningScenario.this.myListener.fileTransferSucceeded(strFileId, GetCommissioningScenario.this.myFiles.remove(0));
        }
    }
}

