/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.fileoperation;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.FileDeleteRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.fileoperation.DeleteFilesFromBTSListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.util.List;
import org.apache.log4j.Logger;

public class DeleteFilesFromBTSScenario
implements Scenario {
    private final Logger myLogger;
    private final BTSConnection myConnection;
    private DeleteFilesFromBTSListener myListener;
    private int myFileType;
    protected List<String> myFileIds;
    private boolean myRunning = false;
    private int mySeqnum;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public DeleteFilesFromBTSScenario(BTSConnection connection, DeleteFilesFromBTSListener listener, int fileType, List<String> fileIds) {
        this.myListener = listener;
        this.myFileType = fileType;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFileIds = fileIds;
    }

    public DeleteFilesFromBTSScenario(BTSConnection connection, DeleteFilesFromBTSListener listener, int fileType, List<String> fileIds, BTSMessage.Type type) {
        this(connection, listener, fileType, fileIds);
        this.myType = type;
    }

    @Override
    public void execute() {
        this.myLogger.trace((Object)"Executing.");
        if (this.myRunning) {
            this.myLogger.debug((Object)"Illegal state, scenario already in process.");
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        CoreAssetThread fileDeleteWorker = new CoreAssetThread(){

            protected Object construct() {
                return DeleteFilesFromBTSScenario.this.runScenario();
            }

            protected void finished() {
                DeleteFilesFromBTSScenario.this.myLogger.debug((Object)"Worker finished.");
                DeleteFilesFromBTSScenario.this.myConnection.deleteScenario(DeleteFilesFromBTSScenario.this.mySeqnum);
                DeleteFilesFromBTSScenario.this.myRunning = false;
            }
        };
        fileDeleteWorker.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"No support for snapshot opening.");
            this.myListener.fileDeleteFailed(85);
            return false;
        }
        this.myRunning = true;
        this.mySeqnum = this.myConnection.createScenario();
        FileDeleteRequest fileDeleteRequest = new FileDeleteRequest(this.mySeqnum, this.myFileType, this.myFileIds, this.myType);
        this.myConnection.sendToBTS((BTSMessage)fileDeleteRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqnum, 60000L);
        return this.runScenario(response);
    }

    private Object runScenario(BTSMessage response) {
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (ack.getAck()) {
                this.myLogger.debug((Object)"File delete succeeded.");
                this.myListener.fileDeleteSucceeded();
            } else {
                this.myLogger.error((Object)"File delete failed.");
                this.myListener.fileDeleteFailed(ack.getNackReason());
            }
            return ack.getAck();
        }
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"Setting logging categories timeouted.");
            this.myListener.fileDeleteFailed(68);
            return false;
        }
        this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
        this.myListener.fileDeleteFailed(28);
        return false;
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"Cannot be aborted.");
        return false;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

