/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.fileoperation;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.FileActivationAck;
import com.nokia.em.bts.coreasset.message.FileActivationRequest;
import com.nokia.em.bts.coreasset.message.OperationFeedback;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.fileoperation.FileActivationListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class FileActivationScenario
implements Scenario {
    private final Logger myLogger = Logger.getLogger(this.getClass());
    private final BTSConnection myConnection;
    private final int myFileType;
    private final long myPlanId;
    FileActivationListener myListener;
    private long myTimeout;

    public FileActivationScenario(BTSConnection connection, FileActivationListener listener, int fileType, long planId) {
        this(connection, listener, fileType, planId, 360000L);
    }

    public FileActivationScenario(BTSConnection connection, FileActivationListener listener, int fileType, long planId, long timeout) {
        this.myConnection = connection;
        this.myListener = listener;
        this.myFileType = fileType;
        this.myPlanId = planId;
        this.myTimeout = timeout;
    }

    @Override
    public void execute() {
        CoreAssetThread fileActivationWorker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    FileActivationScenario.this.myLogger.debug((Object)"No support for snapshot opening.");
                    FileActivationScenario.this.myListener.fileActivationFailed(85, -1, "");
                    return true;
                }
                final int seqNumber = FileActivationScenario.this.myConnection.createScenario();
                FileActivationRequest fileActivationRequest = new FileActivationRequest(seqNumber, FileActivationScenario.this.myFileType, FileActivationScenario.this.myPlanId);
                FileActivationScenario.this.myConnection.sendToBTS((BTSMessage)fileActivationRequest);
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileActivationScenario.this.myConnection.interruptScenario(seqNumber);
                    }
                };
                this.restartTimeoutTimer(listener);
                BTSMessage response = null;
                while ((response = FileActivationScenario.this.myConnection.receiveFromBTS(seqNumber)) instanceof OperationFeedback) {
                    this.restartTimeoutTimer(listener);
                }
                TimerService.getInstance().stopTimer(listener);
                if (response instanceof FileActivationAck) {
                    FileActivationScenario.this.myConnection.deleteScenario(seqNumber);
                    FileActivationAck fileActivationAck = (FileActivationAck)response;
                    int cause = fileActivationAck.getCause();
                    if (cause == 36) {
                        FileActivationScenario.this.myLogger.debug((Object)"FileActivation succeeded");
                        FileActivationScenario.this.myListener.fileActivationSucceeded(fileActivationAck.getResetCoverage(), fileActivationAck.getOperationFeedback());
                        return true;
                    }
                    FileActivationScenario.this.myLogger.debug((Object)("FileActivation failed cause:" + cause));
                    FileActivationScenario.this.myListener.fileActivationFailed(cause, fileActivationAck.getResetCoverage(), fileActivationAck.getOperationFeedback());
                    return false;
                }
                if (response == null || response instanceof Timeout) {
                    FileActivationScenario.this.myConnection.deleteScenario(seqNumber);
                    FileActivationScenario.this.myLogger.debug((Object)"FileActivation failed cause: TIMEOUT");
                    FileActivationScenario.this.myListener.fileActivationFailed(68, 94, "");
                    return false;
                }
                FileActivationScenario.this.myConnection.deleteScenario(seqNumber);
                FileActivationScenario.this.myLogger.error((Object)"Wrong reply received from BTS. FileActivationAck expected.");
                FileActivationScenario.this.myListener.fileActivationFailed(28, -1, "");
                return null;
            }

            private void restartTimeoutTimer(ActionListener listener) {
                TimerService.getInstance().stopTimer(listener);
                TimerService.getInstance().startTimer(listener, FileActivationScenario.this.myTimeout);
            }
        };
        fileActivationWorker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }
}

