/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.fileoperation;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.FileLoadRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.fileoperation.GetFileFromBTSAdapter;
import com.nokia.em.bts.coreasset.scenario.fileoperation.GetFileFromBTSListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.FileLoadPrepare;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class GetFileFromBTSScenario
implements Scenario {
    private final Logger myLogger;
    private final BTSConnection myConnection;
    private GetFileFromBTSListener myListener;
    private int myFileType;
    private String myFileId = null;
    private int myUnitId = -1;
    private File myFilePath = null;
    protected List<String> myFiles;
    protected List<String> myStartedFiles;
    private List<FileTransferClient> myRunningFileTransferClients;
    private int myFileLoadRequestSeqNumber;
    private int cause;
    private boolean myFileTypeIncluded;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private int myMaxTryTime;
    private int myTryTime;
    private int myRetryInterval;
    private int myTimeout = -1;
    private boolean myRunning = false;

    public void setIncludedFileTypeInFileLoadCompleted(boolean fileTypeIncluded) {
        this.myFileTypeIncluded = fileTypeIncluded;
    }

    public GetFileFromBTSScenario(BTSConnection connection, GetFileFromBTSListener listener, int fileType) {
        this.myListener = listener;
        this.myFileType = fileType;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFiles = new CopyOnWriteArrayList<String>();
        this.myStartedFiles = new CopyOnWriteArrayList<String>();
        this.myRunningFileTransferClients = new CopyOnWriteArrayList<FileTransferClient>();
    }

    public GetFileFromBTSScenario(BTSConnection connection, GetFileFromBTSListener listener, int fileType, BTSMessage.Type type) {
        this(connection, listener, fileType);
        this.myType = type;
    }

    public GetFileFromBTSScenario(BTSConnection connection, GetFileFromBTSListener listener, int fileType, BTSMessage.Type type, int maxtryTime, int retryInterval) {
        this(connection, listener, fileType, type);
        this.myMaxTryTime = maxtryTime;
        this.myRetryInterval = retryInterval;
    }

    public GetFileFromBTSScenario(BTSConnection connection, GetFileFromBTSListener listener, int fileType, int timeout, BTSMessage.Type type) {
        this(connection, listener, fileType, type);
        this.myTimeout = timeout;
    }

    public GetFileFromBTSScenario(BTSConnection connection, GetFileFromBTSListener listener, int fileType, String fileId) {
        this(connection, listener, fileType);
        this.myFileId = fileId;
    }

    public GetFileFromBTSScenario(BTSConnection connection, GetFileFromBTSListener listener, int fileType, String fileId, BTSMessage.Type type) {
        this(connection, listener, fileType, fileId);
        this.myType = type;
    }

    public GetFileFromBTSScenario(BTSConnection connection, GetFileFromBTSListener listener, int fileType, String fileId, File filePath) {
        this(connection, listener, fileType, fileId);
        this.myFilePath = filePath;
    }

    public GetFileFromBTSScenario(BTSConnection connection, GetFileFromBTSListener listener, int fileType, String fileId, int unitId, int timeout) {
        this(connection, listener, fileType, fileId);
        this.myUnitId = unitId;
        this.myTimeout = timeout;
    }

    @Override
    public void execute() {
        if (this.isRunning()) {
            this.myLogger.debug((Object)"Illegal state.");
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.setIsRunning(true);
        CoreAssetThread fileTransferWorker = new CoreAssetThread(){

            protected Object construct() {
                return GetFileFromBTSScenario.this.runScenario(GetFileFromBTSScenario.this.myTimeout);
            }
        };
        fileTransferWorker.start();
    }

    @Override
    public boolean abort() {
        this.myListener = new GetFileFromBTSAdapter();
        if (this.myConnection != null) {
            this.myLogger.debug((Object)"Trying to interrupt message receiving...");
            this.myConnection.interruptScenario(this.myFileLoadRequestSeqNumber);
        }
        if (!this.myRunningFileTransferClients.isEmpty()) {
            this.myLogger.debug((Object)"Trying to interrupt file transfer...");
            for (FileTransferClient client : this.myRunningFileTransferClients) {
                client.abort();
            }
        }
        this.myLogger.debug((Object)"Abort done.");
        return true;
    }

    private void setIsRunning(boolean value) {
        this.myRunning = value;
    }

    protected boolean isRunning() {
        return this.myRunning;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    protected Object runScenario(int timeout) {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"No support for snapshot opening.");
            this.myListener.filesetTransferFailed(85);
            return true;
        }
        ++this.myTryTime;
        this.myFileLoadRequestSeqNumber = this.myConnection.createScenario();
        FileLoadRequest fileLoadRequest = this.myUnitId != -1 ? new FileLoadRequest(this.myFileLoadRequestSeqNumber, this.myFileType, this.myFileId, this.myUnitId, this.myType) : new FileLoadRequest(this.myFileLoadRequestSeqNumber, this.myFileType, this.myFileId, this.myType);
        if (!this.myConnection.sendToBTS((BTSMessage)fileLoadRequest)) {
            this.myLogger.error((Object)"Fail to send FileLoadRequest message to BTS.");
            this.myListener.filesetTransferFailed(37);
            this.myConnection.deleteScenario(this.myFileLoadRequestSeqNumber);
            return null;
        }
        BTSMessage response = null;
        response = timeout > 0 ? this.myConnection.receiveFromBTS(this.myFileLoadRequestSeqNumber, (long)timeout) : this.myConnection.receiveFromBTS(this.myFileLoadRequestSeqNumber);
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"FileActivation failed cause: TIMEOUT");
            this.myConnection.deleteScenario(this.myFileLoadRequestSeqNumber);
            this.myListener.filesetTransferFailed(68);
            return false;
        }
        if (response instanceof FileLoadPrepare) {
            return this.fileTransferResult(response);
        }
        this.myLogger.error((Object)"Wrong reply received from BTS. FileLoadPrepare expected.");
        if (this.myConnection.isBTSConnected()) {
            this.myListener.filesetTransferFailed(28);
        } else {
            this.myListener.filesetTransferFailed(87);
        }
        this.myConnection.deleteScenario(this.myFileLoadRequestSeqNumber);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fileTransferResult(BTSMessage response) {
        FileLoadPrepare flp = (FileLoadPrepare)response;
        this.cause = flp.getCause();
        List ftpTransferInfos = flp.getFTPTransferInfo();
        if (ftpTransferInfos.size() > 0) {
            ScenarioManagerImpl.setFTPTransferInfo((FTPTransferInfo)ftpTransferInfos.get(0));
            Iterator iter = ftpTransferInfos.iterator();
            ArrayList<String> transferedFiles = new ArrayList<String>();
            while (iter.hasNext()) {
                FTPTransferInfo info = (FTPTransferInfo)iter.next();
                String password = new String(info.getPassword());
                if (!(info.getServerAddress().equalsIgnoreCase("Coreasset_Unknown") || info.getUserName().equalsIgnoreCase("Coreasset_Unknown") || password.equalsIgnoreCase("Coreasset_Unknown") || info.getFileId().equalsIgnoreCase("Coreasset_Unknown"))) {
                    FileTransferClient client = this.myConnection.getFileTransferFactory().getFileTransferClient();
                    client.setFTPTransferInfo(info);
                    if (this.myFilePath != null) {
                        File fileId = new File(info.getFileId());
                        File file = new File(this.myFilePath, fileId.getName());
                        client.setFilePath(file.getPath());
                    }
                    try {
                        this.myFiles.add(info.getFileId());
                        this.myStartedFiles.add(info.getFileId());
                        this.myRunningFileTransferClients.add(client);
                        client.getFile((FileTransferListener)new FileTransferImpl());
                        this.myRunningFileTransferClients.remove(client);
                        transferedFiles.add(info.getFileId());
                    }
                    catch (FileTransferException e) {
                        if (e.getErrorResponseCode() == 404) continue;
                        this.myListener.fileTransferFailed(info.getFileId());
                    }
                    continue;
                }
                this.myListener.fileTransferFailed(info.getFileId());
            }
            if (this.myFileTypeIncluded) {
                this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(this.myFileLoadRequestSeqNumber, transferedFiles, this.myFileType));
            } else {
                this.myConnection.sendToBTS((BTSMessage)new FileLoadCompleted(this.myFileLoadRequestSeqNumber, transferedFiles));
            }
            this.myConnection.receiveFromBTS(this.myFileLoadRequestSeqNumber, 3000L);
            this.myConnection.deleteScenario(this.myFileLoadRequestSeqNumber);
            this.myListener.filesetTransferFinished();
            return true;
        }
        this.myConnection.deleteScenario(this.myFileLoadRequestSeqNumber);
        if (this.cause == 27 && this.myTryTime < this.myMaxTryTime) {
            this.myLogger.debug((Object)("OAM busy, will retry after " + this.myRetryInterval + " seconds. Retry times: " + this.myTryTime));
            try {
                GetFileFromBTSScenario iter = this;
                synchronized (iter) {
                    this.wait(this.myRetryInterval * 1000);
                }
            }
            catch (InterruptedException e) {
                this.myLogger.error((Object)("Interrupted when waiting for next file retry! File type: " + this.myFileType));
            }
            return this.runScenario(this.myTimeout);
        }
        this.myLogger.error((Object)"Empty FTPTransferInfo received");
        this.myListener.filesetTransferFailed(66);
        return false;
    }

    private class FileTransferImpl
    extends FileTransferAdapter {
        private FileTransferImpl() {
        }

        public void fileSetTransferFailed(int intFailReason) {
            GetFileFromBTSScenario.this.myListener.filesetTransferFailed(intFailReason);
        }

        public void fileTransferFailed(String strFileId) {
            GetFileFromBTSScenario.this.myListener.fileTransferFailed(GetFileFromBTSScenario.this.myFiles.remove(0));
        }

        public void fileTransferStarted(String strFileId, long size) {
            GetFileFromBTSScenario.this.myListener.fileTransferStarted(GetFileFromBTSScenario.this.myStartedFiles.remove(0));
        }

        public void fileTransferSucceeded(String strFileId) {
            if (GetFileFromBTSScenario.this.cause == 36) {
                GetFileFromBTSScenario.this.myListener.fileTransferSucceeded(strFileId, GetFileFromBTSScenario.this.myFiles.remove(0));
            } else {
                GetFileFromBTSScenario.this.myListener.fileTransferSucceeded(strFileId, GetFileFromBTSScenario.this.myFiles.remove(0), GetFileFromBTSScenario.this.cause);
            }
        }
    }
}

