/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.fileoperation;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.fileoperation.SendFileToBTSListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferAdapter;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferServer;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.FileLoadPrepare;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.apache.log4j.Logger;

public class SendFileToBTSScenario
implements Scenario {
    private final Logger myLogger;
    private final BTSConnection myConnection;
    private int myFileType;
    private final SendFileToBTSListener myListener;
    private String myFileId;
    private boolean myFileInfo;
    private File myFileToSnapshot;
    private String myFileSavingTask;
    private String myFileSavingFolder;
    private String mySnapshotSCFName;
    private int myUnitId = -1;
    private static final int SNAPSHOT_TIMEOUT = 10000;
    private static final long L_CRC_MIN = 0x80000001L;
    private static final long L_CRC_MAX = 0x100000000L;
    private static final long L_REDUCE_VAL = 0x100000000L;
    private long myTimeout;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SendFileToBTSScenario(BTSConnection connection, SendFileToBTSListener listener, int fileType, String fileId, Boolean blnFileInfo) {
        this(connection, listener, fileType, fileId, blnFileInfo, null, null, null, -1L);
    }

    public SendFileToBTSScenario(BTSConnection connection, SendFileToBTSListener listener, int fileType, String fileId, Boolean blnFileInfo, BTSMessage.Type type) {
        this(connection, listener, fileType, fileId, blnFileInfo, null, null, null, -1L);
        this.myType = type;
    }

    public SendFileToBTSScenario(BTSConnection connection, SendFileToBTSListener listener, int fileType, String fileId, Boolean blnFileInfo, String savingTask, String savingFolder, String snapshotSCFName, long timeout) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFileType = fileType;
        this.myListener = listener;
        this.myFileId = fileId;
        this.myFileInfo = blnFileInfo;
        if (savingTask != null && savingFolder != null && snapshotSCFName != null) {
            this.myFileSavingFolder = savingFolder;
            this.myFileSavingTask = savingTask;
            this.mySnapshotSCFName = snapshotSCFName;
            CoreAsset.addSnapshotSaver(new FileSnapshotSaver());
        }
        this.myTimeout = timeout;
    }

    public SendFileToBTSScenario(BTSConnection connection, SendFileToBTSListener listener, int fileType, String fileId, Boolean blnFileInfo, String savingTask, String savingFolder, String snapshotSCFName, long timeout, BTSMessage.Type type) {
        this(connection, listener, fileType, fileId, blnFileInfo, savingTask, savingFolder, snapshotSCFName, timeout);
        this.myType = type;
    }

    public SendFileToBTSScenario(BTSConnection connection, SendFileToBTSListener listener, int fileType, String fileId, Boolean blnFileInfo, int unitId, int timeout) {
        this(connection, listener, fileType, fileId, blnFileInfo, null, null, null, timeout);
        this.myUnitId = unitId;
    }

    @Override
    public void execute() {
        CoreAssetThread fileTransferWorker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    SendFileToBTSScenario.this.myLogger.debug((Object)"No support for snapshot opening.");
                    SendFileToBTSScenario.this.myListener.fileTransferFailed(85, -1, "");
                    return true;
                }
                try {
                    String strThisIp = SendFileToBTSScenario.this.myConnection.getLocalIPAddress();
                    File file = new File(SendFileToBTSScenario.this.myFileId);
                    SendFileToBTSScenario.this.myFileToSnapshot = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + CoreAsset.FILE_SEPARATOR + SendFileToBTSScenario.this.mySnapshotSCFName);
                    PFileUtils.copyFile((File)SendFileToBTSScenario.this.myFileToSnapshot, (File)file);
                    SendFileToBTSScenario.this.myFileToSnapshot.deleteOnExit();
                    int seqNumber = SendFileToBTSScenario.this.myConnection.createScenario();
                    FileTransferServer server = SendFileToBTSScenario.this.myConnection.getFileTransferFactory().getFileTransferServer();
                    server.initListenerAndPath((FileTransferListener)new FileTransferAdapter(), file.getParent());
                    FTPTransferInfo ftpTransferInfo = new FTPTransferInfo(file.getName(), strThisIp, server.getUserName(), server.getPassword().toCharArray());
                    try {
                        int port = server.startServer();
                        if (port != 21) {
                            ftpTransferInfo.setServerAddress(String.valueOf(ftpTransferInfo.getServerAddress()) + ":" + port);
                        }
                    }
                    catch (Exception ftpEx) {
                        SendFileToBTSScenario.this.myLogger.error((Object)"Unable to start File Server.", (Throwable)ftpEx);
                        return false;
                    }
                    FileLoadPrepare fileLoadPrepare = SendFileToBTSScenario.this.myUnitId != -1 ? new FileLoadPrepare(seqNumber, ftpTransferInfo, SendFileToBTSScenario.this.myFileType, SendFileToBTSScenario.this.myUnitId) : (SendFileToBTSScenario.this.myFileInfo ? new FileLoadPrepare(seqNumber, ftpTransferInfo, SendFileToBTSScenario.this.myFileType, SendFileToBTSScenario.this.calculateCRCChecksum(file), SendFileToBTSScenario.this.myType) : new FileLoadPrepare(seqNumber, ftpTransferInfo, SendFileToBTSScenario.this.myFileType, SendFileToBTSScenario.this.myType));
                    SendFileToBTSScenario.this.myConnection.sendToBTS((BTSMessage)fileLoadPrepare);
                    BTSMessage response = SendFileToBTSScenario.this.myConnection.receiveFromBTS(seqNumber, SendFileToBTSScenario.this.myTimeout);
                    SendFileToBTSScenario.this.myConnection.deleteScenario(seqNumber);
                    if (response instanceof FileLoadCompleted) {
                        FileLoadCompleted fileLoadCompleted = (FileLoadCompleted)response;
                        int cause = fileLoadCompleted.getCause();
                        if (cause == 36) {
                            SendFileToBTSScenario.this.myListener.fileTransferSucceeded(SendFileToBTSScenario.this.myFileId, fileLoadCompleted.getResetCoverage(), fileLoadCompleted.getOperationFeedback());
                            server.stopServer();
                            SendFileToBTSScenario.this.myLogger.debug((Object)("FileLoadCompleted successfully for file: " + SendFileToBTSScenario.this.myFileId));
                            return true;
                        }
                        SendFileToBTSScenario.this.myLogger.debug((Object)("File transfer failed cause: " + cause));
                        SendFileToBTSScenario.this.myListener.fileTransferFailed(cause, fileLoadCompleted.getResetCoverage(), fileLoadCompleted.getOperationFeedback());
                        server.stopServer();
                        return false;
                    }
                    if (response instanceof Timeout) {
                        SendFileToBTSScenario.this.myLogger.warn((Object)"Sending file timed out");
                        SendFileToBTSScenario.this.myListener.fileTransferFailed(68, -1, "");
                        server.stopServer();
                        return false;
                    }
                    SendFileToBTSScenario.this.myLogger.error((Object)"Wrong reply received from BTS. FileLoadCompleted expected.");
                    SendFileToBTSScenario.this.myListener.fileTransferFailed(28, -1, "");
                    server.stopServer();
                    return false;
                }
                catch (Exception e) {
                    SendFileToBTSScenario.this.myLogger.error((Object)("Unknown Error occurred." + e.getMessage()));
                    SendFileToBTSScenario.this.myListener.fileTransferFailed(30, -1, "");
                    return false;
                }
            }
        };
        fileTransferWorker.start();
    }

    private long calculateCRCChecksum(File file) throws IOException {
        Adler32 inChecker = new Adler32();
        CheckedInputStream in = null;
        in = new CheckedInputStream(new FileInputStream(file), inChecker);
        int fileIndex = in.read();
        while (fileIndex != -1) {
            fileIndex = in.read();
        }
        in.close();
        long lngCheckSum = inChecker.getValue();
        if (lngCheckSum >= 0x80000001L && lngCheckSum <= 0x100000000L) {
            lngCheckSum -= 0x100000000L;
        }
        return lngCheckSum;
    }

    @Override
    public boolean abort() {
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    protected class FileSnapshotSaver
    implements SnapshotSaver {
        protected FileSnapshotSaver() {
        }

        public void cancel(SaverProgressListener sp) {
            sp.saveCancelled((SnapshotSaver)this);
        }

        public int getSavingPriority() {
            return 2;
        }

        public Collection getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL snapshot_level) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(SendFileToBTSScenario.this.myFileSavingTask);
            return l;
        }

        public boolean isLocalisationRequired() {
            return false;
        }

        public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL snapshot_level, final SaverProgressListener sp) {
            CoreAssetThread worker = new CoreAssetThread(){

                protected Object construct() {
                    FileSnapshotSaver.this.runSave(url, sp);
                    return null;
                }
            };
            worker.start();
        }

        private void runSave(String url, SaverProgressListener sp) {
            try {
                sp.taskStarted(SendFileToBTSScenario.this.myFileSavingTask, 7, 10000, this.isLocalisationRequired());
                File dir = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SendFileToBTSScenario.this.myFileSavingFolder);
                if (dir.mkdir() || dir.exists()) {
                    File file = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SendFileToBTSScenario.this.myFileSavingFolder + CoreAsset.FILE_SEPARATOR + SendFileToBTSScenario.this.mySnapshotSCFName);
                    PFileUtils.copyFile((File)file, (File)SendFileToBTSScenario.this.myFileToSnapshot);
                    sp.taskUpdated(SendFileToBTSScenario.this.myFileSavingTask, 8, this.isLocalisationRequired());
                } else {
                    sp.taskUpdated(SendFileToBTSScenario.this.myFileSavingTask, 4, this.isLocalisationRequired());
                }
            }
            catch (Exception e) {
                sp.taskUpdated(SendFileToBTSScenario.this.myFileSavingTask, 4, this.isLocalisationRequired());
                SendFileToBTSScenario.this.myLogger.error((Object)"Failed to save file. ", (Throwable)e);
            }
            sp.saveCompleted((SnapshotSaver)this);
        }

        public void stopProcess(int process) {
        }
    }
}

