/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.frequencydifferencedata;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ChangeDACWordRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.DACWordListener;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.DacWordSnapshotSaver;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ChangeDACWordScenario
implements Scenario {
    private BTSConnection myConnection;
    private DACWordListener myDACWordListener;
    private int myDACWord;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private Object myLock = new Object();
    private int myUnitId = -1;
    private String myUnitName;
    private boolean myAborted;
    private int mySeqNumber = -1;

    public ChangeDACWordScenario(BTSConnection connection, DACWordListener dacWordListener, int dacWord) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myDACWordListener = dacWordListener;
        this.myDACWord = dacWord;
    }

    public ChangeDACWordScenario(BTSConnection connection, DACWordListener dacWordListener, int dacWord, BTSMessage.Type type) {
        this(connection, dacWordListener, dacWord);
        this.myType = type;
    }

    public ChangeDACWordScenario(BTSConnection connection, DACWordListener dacWordListener, int dacWord, BTSMessage.Type type, int unitId, String unitName) {
        this(connection, dacWordListener, dacWord, type);
        this.myUnitId = unitId;
        this.myUnitName = unitName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myRunning) {
                throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
            }
            this.myRunning = true;
            this.myAborted = false;
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return ChangeDACWordScenario.this.runScenario();
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myAborted = true;
        this.myConnection.interruptScenario(this.mySeqNumber);
        return true;
    }

    public boolean runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myDACWordListener.changeDACWordRequestFailed(85);
            return true;
        }
        try {
            this.mySeqNumber = this.myConnection.createScenario();
            ChangeDACWordRequest changeDACWordRequest = this.myUnitId == -1 ? new ChangeDACWordRequest(this.mySeqNumber, this.myDACWord, this.myType) : new ChangeDACWordRequest(this.mySeqNumber, this.myDACWord, this.myType, this.myUnitId);
            this.myConnection.sendToBTS((BTSMessage)changeDACWordRequest);
            if (this.myAborted) {
                return false;
            }
            BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber);
            if (response instanceof Ack) {
                Ack ackResponse = (Ack)response;
                if (ackResponse.getAck()) {
                    this.myLogger.debug((Object)"Change succeeded.");
                    DacWordSnapshotSaver.getInstance(this.myUnitName).setDacWord(this.myDACWord);
                    this.myDACWordListener.changeDACWordRequestSucceeded();
                    return true;
                }
                this.myLogger.debug((Object)"Change failed.");
                this.myDACWordListener.changeDACWordRequestFailed(ackResponse.getNackReason());
                return false;
            }
            if (response instanceof Timeout) {
                this.myLogger.debug((Object)"Change failed. Connection timeout.");
                this.myDACWordListener.changeDACWordRequestFailed(68);
                return false;
            }
            this.myLogger.debug((Object)"Change failed, invalid message or connection lost.");
            this.myDACWordListener.changeDACWordRequestFailed(28);
            return false;
        }
        finally {
            if (this.mySeqNumber != -1) {
                this.myConnection.deleteScenario(this.mySeqNumber);
            }
            this.myRunning = false;
        }
    }
}

