/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.frequencydifferencedata;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ClockOperationRequest;
import com.nokia.em.bts.coreasset.message.ClockOperationTerminated;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.FastTuningListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ClockOperationScenario
implements Scenario {
    private BTSConnection myConnection;
    private FastTuningListener myFastTuningListener;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private String myUnitId;

    public ClockOperationScenario(BTSConnection connection, FastTuningListener fastTuningListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myFastTuningListener = fastTuningListener;
    }

    public ClockOperationScenario(BTSConnection connection, FastTuningListener fastTuningListener, BTSMessage.Type type) {
        this(connection, fastTuningListener);
        this.myType = type;
    }

    public ClockOperationScenario(BTSConnection connection, FastTuningListener fastTuningListener, BTSMessage.Type type, String unitId) {
        this(connection, fastTuningListener, type);
        this.myUnitId = unitId;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber;

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    ClockOperationScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    ClockOperationScenario.this.myFastTuningListener.fastTuningFailed(85);
                    return false;
                }
                this.seqNumber = ClockOperationScenario.this.myConnection.createScenario();
                ClockOperationRequest clockOperationRequest = new ClockOperationRequest(this.seqNumber, 33, ClockOperationScenario.this.myType, ClockOperationScenario.this.myUnitId);
                ClockOperationScenario.this.myConnection.sendToBTS((BTSMessage)clockOperationRequest);
                BTSMessage response = ClockOperationScenario.this.myConnection.receiveFromBTS(this.seqNumber);
                if (response instanceof Ack) {
                    Ack ackResponse = (Ack)response;
                    if (!ackResponse.getAck()) {
                        ClockOperationScenario.this.myFastTuningListener.fastTuningFailed(ackResponse.getNackReason());
                        return false;
                    }
                    response = ClockOperationScenario.this.myConnection.receiveFromBTS(this.seqNumber);
                    if (response instanceof ClockOperationTerminated) {
                        ClockOperationTerminated clockOperationTerminated = (ClockOperationTerminated)response;
                        if (!clockOperationTerminated.isAck()) {
                            ClockOperationScenario.this.myFastTuningListener.fastTuningFailed(clockOperationTerminated.getNackReason());
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }

            protected void finished() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        ClockOperationScenario.this.myFastTuningListener.fastTuningCompleted();
                    }
                }
                catch (Exception e) {
                    ClockOperationScenario.this.myLogger.error((Object)"start fast tuning failed!", (Throwable)e);
                    ClockOperationScenario.this.myFastTuningListener.fastTuningFailed(30);
                }
                ClockOperationScenario.this.myConnection.deleteScenario(this.seqNumber);
                ClockOperationScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"Abort not supported in this scenario.");
        return true;
    }
}

