/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.frequencydifferencedata;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import java.io.File;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DacWordSnapshotSaver
implements SnapshotSaver {
    private static DacWordSnapshotSaver myInstance;
    private static Map<String, DacWordSnapshotSaver> myInstances;
    private int myDacWord;
    protected static final String SNAPSHOT_TASK = "Dacword";
    private static final String SNAPSHOT_TASK_NAME = "CoreAsset_Snapshot_Dacword";
    private static final int SNAPSHOT_TIMEOUT = 10000;
    private static final String SAVING_DAC_WORD_TASK_NAME = "Saving {0} DAC word";
    private Logger myLogger;
    private String myUnitName = "";

    private DacWordSnapshotSaver() {
        CoreAsset.addSnapshotSaver(this);
        this.myLogger = Logger.getLogger(this.getClass());
    }

    private DacWordSnapshotSaver(String unitName) {
        this.myUnitName = unitName;
        CoreAsset.addSnapshotSaver(this);
        this.myLogger = Logger.getLogger(this.getClass());
    }

    public static DacWordSnapshotSaver getInstance() {
        if (myInstance == null) {
            myInstance = new DacWordSnapshotSaver();
        }
        return myInstance;
    }

    public static DacWordSnapshotSaver getInstance(String unitName) {
        String tempUnitName;
        if (myInstances == null) {
            myInstances = new HashMap<String, DacWordSnapshotSaver>();
        }
        String string = tempUnitName = unitName == null ? "" : unitName;
        if (!myInstances.containsKey(tempUnitName)) {
            myInstances.put(tempUnitName, new DacWordSnapshotSaver(tempUnitName));
        }
        return myInstances.get(tempUnitName);
    }

    public static void removeSnapshotSaver(DacWordSnapshotSaver saver) {
        myInstances.values().remove(saver);
    }

    protected void setDacWord(int dacWord) {
        this.myDacWord = dacWord;
    }

    public Collection getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        String savingDACWordSnapshotText = this.getSnapshotTaskName();
        ArrayList<String> l = new ArrayList<String>();
        l.add(savingDACWordSnapshotText);
        return l;
    }

    private String getSnapshotTaskName() {
        return this.myUnitName.isEmpty() ? SNAPSHOT_TASK_NAME : MessageFormat.format(SAVING_DAC_WORD_TASK_NAME, this.myUnitName);
    }

    public boolean isLocalisationRequired() {
        return true;
    }

    public void save(final String url, PSnapshotConst.SNAPSHOT_LEVEL level, final SaverProgressListener sp) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return DacWordSnapshotSaver.this.runSaver(url, sp);
            }
        };
        worker.start();
    }

    public Object runSaver(String url, SaverProgressListener sp) {
        try {
            sp.taskStarted(this.getSnapshotTaskName(), 7, 10000, this.isLocalisationRequired());
            File dir = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK);
            if (!dir.mkdir()) {
                this.myLogger.warn((Object)"Failed to create dac word snapshot directory");
            }
            File snapshotFile = new File(String.valueOf(url) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + this.generateFileName());
            FileWriter writer = new FileWriter(snapshotFile);
            writer.write(String.valueOf(this.myDacWord));
            writer.close();
            sp.taskUpdated(this.getSnapshotTaskName(), 8, this.isLocalisationRequired());
        }
        catch (Exception e) {
            sp.taskUpdated(this.getSnapshotTaskName(), 4, this.isLocalisationRequired());
        }
        sp.saveCompleted((SnapshotSaver)this);
        return null;
    }

    private String generateFileName() {
        String fileName = this.myUnitName.isEmpty() ? SNAPSHOT_TASK : "Dacword_" + this.myUnitName.replace(" ", "_");
        return String.valueOf(fileName) + ".txt";
    }

    public void cancel(SaverProgressListener sp) {
        sp.saveCancelled((SnapshotSaver)this);
    }

    public int getSavingPriority() {
        return 2;
    }

    public void stopProcess(int process) {
    }
}

