/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.frequencydifferencedata;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.FrequencyHistoryRequest;
import com.nokia.em.bts.coreasset.message.FrequencyHistoryResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.FrequencyData;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.FrequencyDataImpl;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.FrequencyDifferenceDataListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.filetransfer.FTPTransferInfo;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferClient;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferException;
import com.nokia.em.bts.rp.master.filetransfer.FileTransferListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.FileLoadCompleted;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.snapshot.SaverProgressListener;
import com.nokia.em.bts.rp.master.snapshot.SnapshotSaver;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FrequencyDifferenceDataScenario
implements Scenario,
SnapshotSaver {
    private FileTransferListener myFtpListener;
    private BTSConnection myConnection;
    private FrequencyDifferenceDataListener myFrequencyListener;
    private int mySeqNumber = -1;
    private boolean myRunning = false;
    private boolean myAborted = false;
    private static final SimpleDateFormat DATA_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String FREQUENCY_HISTORY_DATA_NODENAME = "FrequencyHistoryData";
    private static final String CLOCK_FREQUENCY_DIFF_NODENAME = "_clockFrequencyDiff";
    private static final String DAC_WORD_NODENAME = "_dacWord";
    private static final String UNIT_ID_NODENAME = "_unitId";
    private static final String OBSERVATION_TIME_NODENAME = "_observationTime";
    private static final String REJECTED_SAMPLE_NODENAME = "_rejectedSamplePc";
    private static final String TUNING_MODE_NODENAME = "_tuningMode";
    private static final String TUNING_MODE_NORMAL_NODEVALUE = "NormalTuning";
    private static final String TUNING_MODE_FAST_NODEVALUE = "FastTuning";
    private static final String TUNING_MODE_MANUAL_NODEVALUE = "ManualTuning";
    private static final String REFERENCE_SOURCE_NODENAME = "_referenceSource";
    private static final String REFERENCE_2MEXT_NODEVALUE_MACRO = "2M External";
    private static final String REFERENCE_2MEXT_NODEVALUE_MICRO = "2MExternal";
    private static final String REFERENCE_GPSPPS_NODEVALUE = "GPS/PPS";
    private static final String REFERENCE_TRS_NODEVALUE = "Transmission (TDM/SyncE/ToP)";
    private static final String GPS_SATELLITE_AMOUNT_NODENAME = "_gpsSatelliteAmount";
    private static final String PHASE_DEVIATIONS_NODENAME = "PhaseDeviations";
    private static final String DEVIATION_RANGE_ATTRIBUTE = "_deviationRange";
    private Map<File, String> myGZipFiles = new HashMap<File, String>();
    private static final String SNAPSHOT_TASK = "ClockFreq";
    private static final String SNAPSHOT_TASK_NAME = "CoreAsset_Snapshot_ClockFreq";
    private static final String SAVING_FREQ_HIST_DATA_TASK_NAME = "Saving {0} frequency history data";
    private static final int SNAPSHOT_TIMEOUT = 10000;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private Logger myLogger;
    private Map<File, String> myCurrentGZipFiles = new HashMap<File, String>();
    private Object myLock = new Object();
    private String myUnitId;
    private String myUnitName = "";

    static {
        DATA_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public FrequencyDifferenceDataScenario(BTSConnection connection, FileTransferListener ftpListener, FrequencyDifferenceDataListener frequencyListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myFrequencyListener = frequencyListener;
        this.myConnection = connection;
        this.myFtpListener = ftpListener;
    }

    public FrequencyDifferenceDataScenario(BTSConnection connection, FileTransferListener ftpListener, FrequencyDifferenceDataListener frequencyListener, BTSMessage.Type type) {
        this(connection, ftpListener, frequencyListener);
        this.myType = type;
    }

    public FrequencyDifferenceDataScenario(BTSConnection connection, FileTransferListener ftpListener, FrequencyDifferenceDataListener frequencyListener, BTSMessage.Type type, String unitId, String unitName) {
        this(connection, ftpListener, frequencyListener, type);
        this.myUnitId = unitId;
        this.myUnitName = unitName;
    }

    private void openSnapshot() {
        File[] gZipFiles = new File(String.valueOf(CoreAsset.getSnapshotOpenLocation().getFile()) + CoreAsset.FILE_SEPARATOR + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + this.generateFolderName()).listFiles();
        ArrayList<FrequencyData> data = new ArrayList<FrequencyData>();
        if (gZipFiles != null) {
            this.myLogger.debug((Object)("Found " + gZipFiles.length + " frequency history data files."));
            File[] fileArray = gZipFiles;
            int n = gZipFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    File file = Tools.gunZip((File)f);
                    Element element = Tools.parseElementFromFile((String)file.getAbsolutePath());
                    data.addAll(this.parseData(element));
                    this.myLogger.debug((Object)("Parsed clock frequency history data file " + file.getName()));
                }
                catch (Exception e) {
                    this.myLogger.error((Object)"Failed to open clock frequency history data file: ", (Throwable)e);
                }
                ++n2;
            }
            this.myLogger.debug((Object)"All files parsed, sending to GUI.");
            this.myFrequencyListener.frequencyDifferenceDataReceived(data.toArray(new FrequencyData[0]));
        } else {
            this.myLogger.debug((Object)"No clock frequency data in snapshot");
            this.myFrequencyListener.frequencyDifferenceDataFailed(1);
        }
    }

    protected List<FrequencyData> parseData(Element element) {
        if (element == null) {
            this.myLogger.error((Object)"No XML Element data.");
            return new ArrayList<FrequencyData>();
        }
        ArrayList<FrequencyData> dataSet = new ArrayList<FrequencyData>();
        NodeList dataNodeList = element.getElementsByTagName(FREQUENCY_HISTORY_DATA_NODENAME);
        int i = 0;
        while (i < dataNodeList.getLength()) {
            try {
                Node node = dataNodeList.item(i);
                NodeList childNodes = node.getChildNodes();
                Float frequencyDifference = null;
                int dacWord = -1;
                int unitId = -1;
                Float rejectedSamplePercentage = null;
                int tuningMode = -1;
                Date timeDate = new Date();
                int referenceSource = -1;
                Float gpsAmount = null;
                LinkedHashMap<String, Integer> phaseDeviations = new LinkedHashMap<String, Integer>();
                int j = 0;
                while (j < childNodes.getLength()) {
                    block25: {
                        String childNodeValue;
                        String childNodeName;
                        Node childNode;
                        block34: {
                            block36: {
                                block35: {
                                    block31: {
                                        block33: {
                                            block32: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                block26: {
                                                                    childNode = childNodes.item(j);
                                                                    if (!childNode.hasChildNodes()) break block25;
                                                                    childNodeName = childNode.getNodeName();
                                                                    childNodeValue = childNode.getFirstChild().getNodeValue();
                                                                    if (!childNodeName.equalsIgnoreCase(CLOCK_FREQUENCY_DIFF_NODENAME)) break block26;
                                                                    try {
                                                                        frequencyDifference = Float.valueOf(Float.parseFloat(childNodeValue));
                                                                    }
                                                                    catch (Exception exception) {}
                                                                    break block25;
                                                                }
                                                                if (!childNodeName.equalsIgnoreCase(DAC_WORD_NODENAME)) break block27;
                                                                try {
                                                                    dacWord = Integer.parseInt(childNodeValue);
                                                                }
                                                                catch (Exception e) {
                                                                    this.myLogger.error((Object)"Unable to get DAC word");
                                                                    dacWord = -2;
                                                                }
                                                                break block25;
                                                            }
                                                            if (!childNodeName.equalsIgnoreCase(UNIT_ID_NODENAME)) break block28;
                                                            try {
                                                                unitId = Integer.parseInt(childNodeValue);
                                                            }
                                                            catch (Exception e) {
                                                                this.myLogger.error((Object)"Unable to get unit Id");
                                                            }
                                                            break block25;
                                                        }
                                                        if (!childNodeName.equalsIgnoreCase(OBSERVATION_TIME_NODENAME)) break block29;
                                                        try {
                                                            timeDate = DATA_DATE_FORMAT.parse(childNodeValue);
                                                        }
                                                        catch (Exception e) {
                                                            this.myLogger.error((Object)"Failed to parse observation time: ", (Throwable)e);
                                                        }
                                                        break block25;
                                                    }
                                                    if (!childNodeName.equalsIgnoreCase(REJECTED_SAMPLE_NODENAME)) break block30;
                                                    try {
                                                        rejectedSamplePercentage = Float.valueOf(Float.parseFloat(childNodeValue));
                                                    }
                                                    catch (Exception e) {
                                                        this.myLogger.error((Object)"Unable to get rejected sample percentage");
                                                    }
                                                    break block25;
                                                }
                                                if (!childNodeName.equalsIgnoreCase(TUNING_MODE_NODENAME)) break block31;
                                                if (!TUNING_MODE_NORMAL_NODEVALUE.equalsIgnoreCase(childNodeValue)) break block32;
                                                tuningMode = 3;
                                                break block25;
                                            }
                                            if (!TUNING_MODE_FAST_NODEVALUE.equalsIgnoreCase(childNodeValue)) break block33;
                                            tuningMode = 2;
                                            break block25;
                                        }
                                        if (!TUNING_MODE_MANUAL_NODEVALUE.equalsIgnoreCase(childNodeValue)) break block25;
                                        tuningMode = 1;
                                        break block25;
                                    }
                                    if (!childNodeName.equalsIgnoreCase(REFERENCE_SOURCE_NODENAME)) break block34;
                                    if (!REFERENCE_2MEXT_NODEVALUE_MACRO.equalsIgnoreCase(childNodeValue) && !REFERENCE_2MEXT_NODEVALUE_MICRO.equalsIgnoreCase(childNodeValue)) break block35;
                                    referenceSource = 5;
                                    break block25;
                                }
                                if (!REFERENCE_GPSPPS_NODEVALUE.equalsIgnoreCase(childNodeValue)) break block36;
                                referenceSource = 4;
                                break block25;
                            }
                            if (!REFERENCE_TRS_NODEVALUE.equalsIgnoreCase(childNodeValue)) break block25;
                            referenceSource = 7;
                            break block25;
                        }
                        if (childNodeName.equalsIgnoreCase(GPS_SATELLITE_AMOUNT_NODENAME)) {
                            gpsAmount = TextUtils.isNumeric((String)childNodeValue) ? Float.valueOf(Float.parseFloat(childNodeValue)) : Float.valueOf(Float.NaN);
                        } else if (childNodeName.equalsIgnoreCase(PHASE_DEVIATIONS_NODENAME)) {
                            NodeList deviationNodes = childNode.getChildNodes();
                            int k = 0;
                            while (k < deviationNodes.getLength()) {
                                Node rangeNode;
                                Node deviationNode = deviationNodes.item(k);
                                if (deviationNode.hasChildNodes() && (rangeNode = deviationNode.getAttributes().getNamedItem(DEVIATION_RANGE_ATTRIBUTE)) != null) {
                                    try {
                                        String strRange = rangeNode.getNodeValue();
                                        Integer intValue = Integer.valueOf(deviationNode.getFirstChild().getNodeValue());
                                        if (strRange.startsWith("u")) {
                                            strRange = "<" + strRange.substring(1);
                                        } else if (strRange.startsWith("o")) {
                                            strRange = ">" + strRange.substring(1);
                                        }
                                        phaseDeviations.put(strRange, intValue);
                                    }
                                    catch (Exception e) {
                                        this.myLogger.error((Object)"Failed to parse phase deviation: ", (Throwable)e);
                                    }
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                dataSet.add(new FrequencyDataImpl(frequencyDifference, dacWord, unitId, timeDate, rejectedSamplePercentage, tuningMode, referenceSource, gpsAmount, phaseDeviations));
            }
            catch (Exception e) {
                this.myLogger.error((Object)"Exception, ", (Throwable)e);
            }
            ++i;
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myRunning) {
                throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
            }
            this.myRunning = true;
            this.myAborted = false;
        }
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return FrequencyDifferenceDataScenario.this.processFrequencyHistoryFile(true);
            }

            protected void finished() {
                FrequencyDifferenceDataScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myAborted = true;
        this.myConnection.interruptScenario(this.mySeqNumber);
        return true;
    }

    public Collection getSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        String savingDACWordSnapshotText = this.getSnapshotTaskName();
        ArrayList<String> l = new ArrayList<String>();
        l.add(savingDACWordSnapshotText);
        return l;
    }

    private String getSnapshotTaskName() {
        return this.myUnitName.isEmpty() ? SNAPSHOT_TASK_NAME : MessageFormat.format(SAVING_FREQ_HIST_DATA_TASK_NAME, this.myUnitName);
    }

    public boolean isLocalisationRequired() {
        return true;
    }

    public void save(final String url, final PSnapshotConst.SNAPSHOT_LEVEL level, final SaverProgressListener sp) {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return FrequencyDifferenceDataScenario.this.saveMethodConstruct(url, level, sp);
            }
        };
        worker.start();
    }

    protected Object saveMethodConstruct(String url, PSnapshotConst.SNAPSHOT_LEVEL level, SaverProgressListener sp) {
        block11: {
            if (PSnapshotConst.SNAPSHOT_LEVEL.AVAILABLE_DATA == level) {
                this.myGZipFiles.clear();
                this.myGZipFiles.putAll(this.myCurrentGZipFiles);
                break block11;
            }
            this.myAborted = false;
            if (this.processFrequencyHistoryFile(false).booleanValue()) break block11;
            sp.taskUpdated(this.getSnapshotTaskName(), 4, this.isLocalisationRequired());
            this.myLogger.error((Object)"processFrequencyHistoryFile failure");
            sp.saveCompleted((SnapshotSaver)this);
            return null;
        }
        try {
            sp.taskStarted(this.getSnapshotTaskName(), 7, 10000, this.isLocalisationRequired());
            for (File file : this.myGZipFiles.keySet()) {
                File fileDirectory;
                Path directory = Paths.get(this.generateSnapshotFolderPath(url), this.myGZipFiles.get(file));
                Optional<String> parentDirectory = this.getParentPathAsString(directory);
                if (!parentDirectory.isPresent() || !(fileDirectory = new File(parentDirectory.get())).mkdirs()) continue;
                File f = new File(directory.toString());
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    try {
                        int length;
                        in = new FileInputStream(file);
                        out = new FileOutputStream(f, false);
                        byte[] buffer = new byte[4096];
                        while ((length = in.read(buffer)) > 0) {
                            out.write(buffer, 0, length);
                        }
                    }
                    catch (Exception e) {
                        sp.taskUpdated(this.getSnapshotTaskName(), 4, this.isLocalisationRequired());
                        this.myLogger.error((Object)("Failed to copy clock frequency history snapshot file " + file.getName()));
                        out.close();
                        in.close();
                        sp.taskUpdated(this.getSnapshotTaskName(), 8, this.isLocalisationRequired());
                        this.myLogger.debug((Object)("Clock frequency history snapshot file " + file.getName() + " successfully copied"));
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    out.close();
                    in.close();
                    sp.taskUpdated(this.getSnapshotTaskName(), 8, this.isLocalisationRequired());
                    this.myLogger.debug((Object)("Clock frequency history snapshot file " + file.getName() + " successfully copied"));
                    throw throwable;
                }
                out.close();
                in.close();
                sp.taskUpdated(this.getSnapshotTaskName(), 8, this.isLocalisationRequired());
                this.myLogger.debug((Object)("Clock frequency history snapshot file " + file.getName() + " successfully copied"));
            }
            if (this.myGZipFiles.isEmpty()) {
                sp.taskUpdated(this.getSnapshotTaskName(), 8, this.isLocalisationRequired());
                this.myLogger.debug((Object)"No clock frequency history files found for snapshot");
            }
        }
        catch (Exception e) {
            sp.taskUpdated(this.getSnapshotTaskName(), 4, this.isLocalisationRequired());
            this.myLogger.error((Object)"Failed to save clock frequency history snapshot data: ", (Throwable)e);
        }
        sp.saveCompleted((SnapshotSaver)this);
        return null;
    }

    private Optional<String> getParentPathAsString(Path directory) {
        Optional<Path> parentPath = Optional.ofNullable(directory.getParent());
        return parentPath.map(path -> path.toString());
    }

    private String generateSnapshotFolderPath(String url) {
        String tempSnapshotPath = url.replaceFirst("/", "");
        String folderPath = String.valueOf(tempSnapshotPath) + SNAPSHOT_TASK + CoreAsset.FILE_SEPARATOR + this.generateFolderName();
        return folderPath;
    }

    private String generateFolderName() {
        String folderName = this.myUnitName.isEmpty() ? this.myUnitName : this.myUnitName.replace(" ", "_");
        return folderName;
    }

    public void cancel(SaverProgressListener sp) {
        this.abort();
        this.removeSnapshotSaver();
        sp.saveCancelled((SnapshotSaver)this);
    }

    public int getSavingPriority() {
        return 2;
    }

    public void stopProcess(int process) {
    }

    public Boolean processFrequencyHistoryFile(boolean isCurrent) {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Opening snapshot.");
            this.openSnapshot();
            return true;
        }
        try {
            this.mySeqNumber = this.myConnection.createScenario();
            FrequencyHistoryRequest frequencyHistoryRequest = new FrequencyHistoryRequest(this.mySeqNumber, this.myType, this.myUnitId);
            this.myConnection.sendToBTS((BTSMessage)frequencyHistoryRequest);
            BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
            this.myGZipFiles.clear();
            boolean sentStarted = false;
            if (this.myAborted) {
                Boolean bl = false;
                return bl;
            }
            if (response instanceof Ack) {
                Ack ack = (Ack)response;
                if (ack.getAck()) {
                    this.myFrequencyListener.frequencyDifferenceDataStarted();
                    sentStarted = true;
                    response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
                } else {
                    this.myFrequencyListener.frequencyDifferenceDataFailed(5);
                    this.myLogger.error((Object)("BTS Nacked, reason " + ack.getNackReasonString()));
                    Boolean bl = false;
                    return bl;
                }
            }
            if (response instanceof Timeout) {
                this.myLogger.error((Object)"BTS Timeout");
                this.myFrequencyListener.frequencyDifferenceDataFailed(6);
                if (isCurrent) {
                    this.myCurrentGZipFiles.clear();
                }
                Boolean bl = false;
                return bl;
            }
            if (response instanceof FrequencyHistoryResponse) {
                FrequencyHistoryResponse frequencyHistoryResponse = (FrequencyHistoryResponse)response;
                List<FTPTransferInfo> ftpTransferInfos = frequencyHistoryResponse.getFtpTransferInfos();
                if (ftpTransferInfos.size() > 0) {
                    if (!sentStarted) {
                        this.myFrequencyListener.frequencyDifferenceDataStarted();
                    }
                    ArrayList<FrequencyData> data = new ArrayList<FrequencyData>();
                    this.myLogger.debug((Object)("Found " + ftpTransferInfos.size() + " frequency history data files"));
                    for (FTPTransferInfo f : ftpTransferInfos) {
                        File myGZipFile;
                        FileTransferClient client = this.myConnection.getFileTransferFactory().getFileTransferClient();
                        client.setFTPTransferInfo(f);
                        this.myLogger.debug((Object)("Getting frequency history data file " + f.getFileId()));
                        try {
                            myGZipFile = client.getFile(this.myFtpListener);
                            if (myGZipFile == null || f.getFileId() == null) {
                                this.myFrequencyListener.frequencyDifferenceDataFailed(1);
                                Boolean bl = false;
                                return bl;
                            }
                            this.myGZipFiles.put(myGZipFile, new File(f.getFileId()).getName());
                        }
                        catch (FileTransferException ftpE) {
                            this.myLogger.error((Object)("Failed to get frequency history data file " + f.getFileId() + ": "), (Throwable)ftpE);
                            FileLoadCompleted fileLoadCompleted = new FileLoadCompleted(this.mySeqNumber, new String[]{f.getFileId()});
                            this.myConnection.sendToBTS((BTSMessage)fileLoadCompleted);
                            this.myFrequencyListener.frequencyDifferenceDataFailed(3);
                            Boolean bl = false;
                            return bl;
                        }
                        if (isCurrent) {
                            this.myCurrentGZipFiles.clear();
                            this.myCurrentGZipFiles.put(myGZipFile, new File(f.getFileId()).getName());
                        }
                        FileLoadCompleted fileLoadCompleted = new FileLoadCompleted(this.mySeqNumber, new String[]{f.getFileId()});
                        this.myConnection.sendToBTS((BTSMessage)fileLoadCompleted);
                        if (this.myAborted) {
                            this.myFrequencyListener.frequencyDifferenceDataFailed(2);
                            Boolean bl = false;
                            return bl;
                        }
                        File file = Tools.gunZip((File)myGZipFile);
                        if (file == null) {
                            if (isCurrent) {
                                this.myFrequencyListener.frequencyDifferenceDataFailed(5);
                            }
                            Boolean bl = false;
                            return bl;
                        }
                        Element element = Tools.parseElementFromFile((String)file.getAbsolutePath());
                        data.addAll(this.parseData(element));
                        this.myLogger.debug((Object)("Succesfully got frequency history data file " + f.getFileId()));
                    }
                    this.myFrequencyListener.frequencyDifferenceDataReceived(data.toArray(new FrequencyData[0]));
                    this.myLogger.debug((Object)("Sent frequency history data (" + data.size() + ") to GUI"));
                    Boolean bl = true;
                    return bl;
                }
                FileLoadCompleted fileLoadCompleted = new FileLoadCompleted(this.mySeqNumber, new String[0]);
                this.myConnection.sendToBTS((BTSMessage)fileLoadCompleted);
                this.myFrequencyListener.frequencyDifferenceDataFailed(1);
                Boolean bl = false;
                return bl;
            }
            if (response == null) {
                this.myFrequencyListener.frequencyDifferenceDataFailed(2);
                Boolean bl = false;
                return bl;
            }
            this.myLogger.error((Object)"Invalid message from BTS");
            this.myFrequencyListener.frequencyDifferenceDataFailed(0);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (this.mySeqNumber > -1) {
                this.myConnection.deleteScenario(this.mySeqNumber);
            }
        }
    }

    public void removeSnapshotSaver() {
        CoreAsset.removeSnapshotSaver(this);
    }

    public void addSnapshotSaver() {
        CoreAsset.addSnapshotSaver(this);
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    public Map<File, String> getFiles() {
        return this.myGZipFiles;
    }
}

