/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.frequencydifferencedata;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ReadDACWordReply;
import com.nokia.em.bts.coreasset.message.ReadDACWordRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.DACWordListener;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.DacWordSnapshotSaver;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.log4j.Logger;

public class ReadDACWordScenario
implements Scenario {
    private BTSConnection myConnection;
    private DACWordListener myDACWordListener;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;
    private int myUnitId = -1;
    private String myUnitName = "";
    private boolean myAborted;
    private int mySeqNumber = -1;

    public ReadDACWordScenario(BTSConnection connection, DACWordListener dacWordListener) {
        this.myConnection = connection;
        this.myDACWordListener = dacWordListener;
        this.myLogger = Logger.getLogger(this.getClass());
    }

    public ReadDACWordScenario(BTSConnection connection, DACWordListener dacWordListener, BTSMessage.Type type) {
        this(connection, dacWordListener);
        this.myType = type;
    }

    public ReadDACWordScenario(BTSConnection connection, DACWordListener dacWordListener, BTSMessage.Type type, int unitId, String unitName) {
        this(connection, dacWordListener, type);
        this.myUnitId = unitId;
        this.myUnitName = unitName;
    }

    private void openSnapshot() {
        String fileName = this.myUnitName.isEmpty() ? "Dacword" : "Dacword_" + this.myUnitName.replace(" ", "_");
        File file = new File(String.valueOf(CoreAsset.getSnapshotOpenLocation().getFile()) + CoreAsset.FILE_SEPARATOR + "Dacword" + CoreAsset.FILE_SEPARATOR + fileName + ".txt");
        if (!file.exists()) {
            this.myLogger.debug((Object)"No snapshot file found.");
            this.myDACWordListener.readDACWordRequestFailed();
            return;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String s = in.readLine();
            in.close();
            if (s != null) {
                this.myDACWordListener.readDACWordRequestSucceeded(Integer.parseInt(s));
            } else {
                this.myDACWordListener.readDACWordRequestFailed();
            }
        }
        catch (Exception e) {
            this.myLogger.debug((Object)"Cannot open snapshot file.");
            this.myDACWordListener.readDACWordRequestFailed();
        }
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.myAborted = false;
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber = -1;

            protected Object construct() {
                this.seqNumber = ReadDACWordScenario.this.myConnection.createScenario();
                return ReadDACWordScenario.this.runScenario(this.seqNumber);
            }

            protected void finished() {
                ReadDACWordScenario.this.myConnection.deleteScenario(this.seqNumber);
                ReadDACWordScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    public Object runScenario(int seqNumber) {
        this.mySeqNumber = seqNumber;
        if (CoreAsset.isSnapshotOpening()) {
            this.openSnapshot();
            return true;
        }
        ReadDACWordRequest dacWordRequest = this.myUnitId == -1 ? new ReadDACWordRequest(this.mySeqNumber, this.myType) : new ReadDACWordRequest(this.mySeqNumber, this.myType, this.myUnitId);
        this.myConnection.sendToBTS((BTSMessage)dacWordRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (this.myAborted) {
            return false;
        }
        if (response instanceof ReadDACWordReply) {
            ReadDACWordReply reply = (ReadDACWordReply)response;
            if (!reply.isDACWordSet()) {
                this.myLogger.debug((Object)"No dacword in BTS.");
                this.myDACWordListener.readDACWordRequestFailed();
                return false;
            }
            this.myLogger.debug((Object)"Dacword read successful.");
            int dacWord = reply.getDACWord();
            DacWordSnapshotSaver.getInstance(this.myUnitName).setDacWord(dacWord);
            this.myDACWordListener.readDACWordRequestSucceeded(dacWord);
            return true;
        }
        if (response instanceof Timeout) {
            this.myLogger.debug((Object)"Dacword read failed, connection lost.");
            this.myDACWordListener.readDACWordRequestFailed(68);
            return false;
        }
        this.myLogger.debug((Object)"Dacword read failed, invalid message or connection lost.");
        this.myDACWordListener.readDACWordRequestFailed();
        return false;
    }

    @Override
    public boolean abort() {
        this.myAborted = true;
        this.myConnection.interruptScenario(this.mySeqNumber);
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

