/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.frequencydifferencedata;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.SaveDACWordRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.frequencydifferencedata.DACWordListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class SaveDACWordScenario
implements Scenario {
    private BTSConnection myConnection;
    private DACWordListener myDACWordListener;
    private boolean myRunning = false;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public SaveDACWordScenario(BTSConnection connection, DACWordListener dacWordListener) {
        this.myConnection = connection;
        this.myDACWordListener = dacWordListener;
        this.myLogger = Logger.getLogger(this.getClass());
    }

    public SaveDACWordScenario(BTSConnection connection, DACWordListener dacWordListener, BTSMessage.Type type) {
        this(connection, dacWordListener);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){
            int seqNumber = -1;

            protected Object construct() {
                return SaveDACWordScenario.this.runScenario();
            }

            protected void finished() {
                SaveDACWordScenario.this.myConnection.deleteScenario(this.seqNumber);
                SaveDACWordScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"This scenario cannot be aborted.");
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myDACWordListener.saveDACWordRequestFailed(85);
            return true;
        }
        int seqnum = this.myConnection.createScenario();
        SaveDACWordRequest saveDACWordRequest = new SaveDACWordRequest(seqnum, this.myType);
        this.myConnection.sendToBTS((BTSMessage)saveDACWordRequest);
        BTSMessage response = this.myConnection.receiveFromBTS(seqnum);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                this.myLogger.debug((Object)"Save succeeded.");
                this.myDACWordListener.saveDACWordRequestSucceeded();
                return true;
            }
            this.myLogger.debug((Object)"Save failed.");
            this.myDACWordListener.saveDACWordRequestFailed(ackResponse.getNackReason());
            return false;
        }
        this.myLogger.debug((Object)"Save failed, invalid message or connection lost.");
        this.myDACWordListener.saveDACWordRequestFailed(28);
        return false;
    }
}

