/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.gpsmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ChangeGPSTakeOverModeRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.gpsmanagement.GPSTakeOverModeListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ChangeGPSTakeOverModeScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private GPSTakeOverModeListener myGPSTakeOverModeListener;
    private boolean myRunning;
    private int mySeqNbr;
    private Logger myLogger;
    private boolean myEnableState;
    private boolean myAborted;
    private int myUnitId;
    private static final int TIMEOUT_ACK = 60000;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public ChangeGPSTakeOverModeScenario(BTSConnection btsConnection, GPSTakeOverModeListener gpsTakeOverModeListener, int unitId, boolean activated) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = btsConnection;
        this.myGPSTakeOverModeListener = gpsTakeOverModeListener;
        this.myUnitId = unitId;
        this.myEnableState = activated;
        this.myRunning = false;
    }

    public ChangeGPSTakeOverModeScenario(BTSConnection btsConnection, GPSTakeOverModeListener gpsTakeOverModeListener, int unitId, boolean activated, BTSMessage.Type type) {
        this(btsConnection, gpsTakeOverModeListener, unitId, activated);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.myAborted = false;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return ChangeGPSTakeOverModeScenario.this.runScenario();
            }

            protected void finished() {
                ChangeGPSTakeOverModeScenario.this.myBTSConnection.deleteScenario(ChangeGPSTakeOverModeScenario.this.mySeqNbr);
                ChangeGPSTakeOverModeScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myGPSTakeOverModeListener.modeChangeFailed(85);
            return null;
        }
        this.mySeqNbr = this.myBTSConnection.createScenario();
        ChangeGPSTakeOverModeRequest request = new ChangeGPSTakeOverModeRequest(this.mySeqNbr, this.myUnitId, this.myEnableState, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)request);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (ack.getAck()) {
                this.myGPSTakeOverModeListener.modeChangeAcknowledged();
            } else {
                this.myGPSTakeOverModeListener.modeChangeFailed(ack.getNackReason());
            }
        } else if (response instanceof Timeout) {
            this.myLogger.debug((Object)"Mode change request failed for timeouted ");
            this.myGPSTakeOverModeListener.modeChangeFailed(68);
        } else if (response == null) {
            if (this.myAborted) {
                this.myLogger.debug((Object)"Aborted by user.");
            } else {
                this.myLogger.debug((Object)"Null message, connection lost.");
                this.myGPSTakeOverModeListener.modeChangeFailed(87);
            }
        } else {
            this.myLogger.error((Object)"Invalid message from BTS.");
            this.myGPSTakeOverModeListener.modeChangeFailed(28);
        }
        return null;
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myAborted = true;
            this.myBTSConnection.interruptScenario(this.mySeqNbr);
        }
        return true;
    }
}

