/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.gpsmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ResetModuleRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.gpsmanagement.ResetModuleListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ResetModuleScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private ResetModuleListener myResetListener;
    private boolean myRunning;
    private int mySeqNbr;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private boolean myAborted;
    private int myUnitId;

    public ResetModuleScenario(BTSConnection btsConnection, ResetModuleListener resetListener, int unitId) {
        this.myBTSConnection = btsConnection;
        this.myResetListener = resetListener;
        this.myUnitId = unitId;
        this.myRunning = false;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.myAborted = false;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return ResetModuleScenario.this.runScenario();
            }

            protected void finished() {
                ResetModuleScenario.this.myBTSConnection.deleteScenario(ResetModuleScenario.this.mySeqNbr);
                ResetModuleScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myResetListener.resetFailed(85);
            return null;
        }
        this.mySeqNbr = this.myBTSConnection.createScenario();
        ResetModuleRequest request = new ResetModuleRequest(this.mySeqNbr, this.myUnitId);
        this.myBTSConnection.sendToBTS((BTSMessage)request);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (ack.getAck()) {
                this.myLogger.debug((Object)"Module reset successful.");
                this.myResetListener.moduleReseted();
            } else {
                int reason = ack.getNackReason();
                this.myLogger.debug((Object)("Module reset failed, " + reason));
                this.myResetListener.resetFailed(reason);
            }
        } else if (response == null) {
            if (this.myAborted) {
                this.myLogger.debug((Object)"Aborted by user.");
            } else {
                this.myLogger.debug((Object)"Null message, connection lost.");
                this.myResetListener.resetFailed(87);
            }
        } else {
            this.myLogger.error((Object)"Invalid message from BTS.");
            this.myResetListener.resetFailed(28);
        }
        return null;
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myAborted = true;
            this.myBTSConnection.interruptScenario(this.mySeqNbr);
        }
        return true;
    }
}

