/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.AutoconnTrsParamsUpdateRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.AutoconnTrsParamsUpdateListener;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.AutoconnectionParametersBean;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class AutoconnTrsParamsUpdateScenario
implements Scenario {
    private Logger myLogger;
    private BTSConnection myBTSConnection;
    private int mySeqNbr;
    private boolean myRunning;
    private AutoconnTrsParamsUpdateListener myListener;
    private AutoconnectionParametersBean myParams;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public AutoconnTrsParamsUpdateScenario(BTSConnection connection, AutoconnTrsParamsUpdateListener listener, AutoconnectionParametersBean params) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myListener = listener;
        this.myParams = params;
    }

    public AutoconnTrsParamsUpdateScenario(BTSConnection connection, AutoconnTrsParamsUpdateListener listener, AutoconnectionParametersBean params, BTSMessage.Type type) {
        this(connection, listener, params);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return AutoconnTrsParamsUpdateScenario.this.runScenario();
            }

            protected void finished() {
                AutoconnTrsParamsUpdateScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            return true;
        }
        this.mySeqNbr = this.myBTSConnection.createScenario();
        AutoconnTrsParamsUpdateRequest requesst = new AutoconnTrsParamsUpdateRequest(this.mySeqNbr, this.myParams, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)requesst);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                this.myListener.autoconnTrsParamsUpdateFailed(ack.getNackReason());
            } else {
                this.myListener.autoconnTrsParamsUpdateSuccess();
            }
        } else if (response instanceof Timeout) {
            this.myListener.autoconnTrsParamsUpdateFailed(68);
        } else if (response != null) {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
            this.myListener.autoconnTrsParamsUpdateFailed(28);
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected. response is null or thread terminated");
        }
        this.myRunning = false;
        this.myBTSConnection.deleteScenario(this.mySeqNbr);
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

