/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.poseidon.PoseidonRuntime;
import java.util.LinkedHashMap;
import java.util.Map;

public class AutoconnectionParametersBean
extends LinkedHashMap<String, Parameter> {
    public static final String AUTOCONN_TRSPARAMS = "AutoconnTrsParams";
    public static final String AUTOCONN_SITEID = "AutoconnectionSiteId";
    public static final String AUTOCONN_ENBIPADDRESS = "_eNBIpAddress";
    public static final String AUTOCONN_NETPREFIXLENGTH = "_netPrefixLength";
    public static final String AUTOCONN_NETMASK = "_netmask";
    public static final String AUTOCONN_DEFAULTGATEWAY = "_defaultGateway";
    public static final String AUTOCONN_VLANID = "_vlanId";
    public static final String AUTOCONN_IDENTISERVERIPADDRESS = "_identificationServerIpAddress";
    public static final String AUTOCONN_VNPGATEWAYIPADDRESS = "_vnpGatewayIpAddress";
    public static final String AUTOCONN_CMPSERVERIPADDRESS = "_cmpServerIpAddress";
    public static final String AUTOCONN_CMPSERVERPORT = "_cmpServerPort";
    public static final String AUTOCONN_CMPSUBJECTNAME = "_cmpSubjectName";
    public static final String AUTOCONN_CMPDIRECTORY = "_cmpDirectory";
    private static final String EMPTY = "";
    private Parameter siteId = new Parameter("AutoconnectionSiteId");
    private Parameter ipAddress = new Parameter("_eNBIpAddress");
    private Parameter myNetPrefixLength = new Parameter("_netPrefixLength");
    private Parameter netMask = new Parameter("_netmask");
    private Parameter defaultGateway = new Parameter("_defaultGateway");
    private Parameter myVlanId = new Parameter("_vlanId");
    private Parameter identiServerIpAddress = new Parameter("_identificationServerIpAddress");
    private Parameter vnpGatewayIpAddress = new Parameter("_vnpGatewayIpAddress");
    private Parameter cmpServerIpAddress = new Parameter("_cmpServerIpAddress");
    private Parameter cmpServerPort = new Parameter("_cmpServerPort");
    private Parameter cmpSubjectName = new Parameter("_cmpSubjectName");
    private Parameter cmpDirectory = new Parameter("_cmpDirectory");
    private Status myStatus = Status.NOT_INITIALIZED;

    public AutoconnectionParametersBean() {
        this.put(AUTOCONN_ENBIPADDRESS, this.ipAddress);
        this.put(AUTOCONN_NETPREFIXLENGTH, this.myNetPrefixLength);
        this.put(AUTOCONN_NETMASK, this.netMask);
        this.put(AUTOCONN_DEFAULTGATEWAY, this.defaultGateway);
        this.put(AUTOCONN_VLANID, this.myVlanId);
        this.put(AUTOCONN_IDENTISERVERIPADDRESS, this.identiServerIpAddress);
        this.put(AUTOCONN_VNPGATEWAYIPADDRESS, this.vnpGatewayIpAddress);
        this.put(AUTOCONN_CMPSERVERIPADDRESS, this.cmpServerIpAddress);
        this.put(AUTOCONN_CMPSERVERPORT, this.cmpServerPort);
        this.put(AUTOCONN_CMPSUBJECTNAME, this.cmpSubjectName);
        this.put(AUTOCONN_CMPDIRECTORY, this.cmpDirectory);
    }

    public void setStatus(Status status) {
        this.myStatus = status;
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public boolean isActive() {
        return this.myStatus == Status.ACTIVE;
    }

    public boolean isInitialized() {
        return this.myStatus != Status.NOT_INITIALIZED;
    }

    public String getSiteId() {
        return this.siteId.getValue();
    }

    public void setSiteId(String siteId) {
        this.siteId.setValue(siteId);
    }

    public String getIpAddress() {
        return this.ipAddress.getValue();
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress.setValue(ipAddress);
    }

    public String getNetMask() {
        return this.netMask.getValue();
    }

    public void setNetMask(String netMask) {
        this.netMask.setValue(netMask);
    }

    public String getNetPrefixLength() {
        return this.myNetPrefixLength.getValue();
    }

    public void setNetPrefixLength(String subnetPrefixLength) {
        this.myNetPrefixLength.setValue(subnetPrefixLength);
    }

    public String getDefaultGateway() {
        return this.defaultGateway.getValue();
    }

    public void setDefaultGateway(String defaultGateway) {
        this.defaultGateway.setValue(defaultGateway);
    }

    public String getVlanId() {
        if (this.myVlanId != null && !EMPTY.equals(this.myVlanId.getValue())) {
            try {
                int vlanIdInt = Integer.valueOf(this.myVlanId.getValue());
                this.myVlanId.setValue(String.valueOf(vlanIdInt));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.myVlanId != null ? this.myVlanId.getValue() : null;
    }

    public void setVlanId(String s) {
        String vlanId = s;
        if (vlanId != null && !EMPTY.equals(vlanId)) {
            try {
                int vlanIdInt = Integer.valueOf(vlanId);
                vlanId = String.valueOf(vlanIdInt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myVlanId.setValue(vlanId);
    }

    public String getIdentiServerIpAddress() {
        return this.identiServerIpAddress.getValue();
    }

    public void setIdentiServerIpAddress(String identiServerIpAddress) {
        this.identiServerIpAddress.setValue(identiServerIpAddress);
    }

    public String getVnpGatewayIpAddress() {
        return this.vnpGatewayIpAddress.getValue();
    }

    public void setVnpGatewayIpAddress(String vnpGatewayIpAddress) {
        this.vnpGatewayIpAddress.setValue(vnpGatewayIpAddress);
    }

    public String getCmpServerIpAddress() {
        return this.cmpServerIpAddress.getValue();
    }

    public void setCmpServerIpAddress(String cmpServerIpAddress) {
        this.cmpServerIpAddress.setValue(cmpServerIpAddress);
    }

    public String getCmpServerPort() {
        return this.cmpServerPort.getValue();
    }

    public void setCmpServerPort(String cmpServerPort) {
        this.cmpServerPort.setValue(cmpServerPort);
    }

    public String getCmpSubjectName() {
        return this.cmpSubjectName.getValue();
    }

    public void setCmpSubjectName(String cmpSubjectName) {
        this.cmpSubjectName.setValue(cmpSubjectName);
    }

    public String getCmpDirectory() {
        return this.cmpDirectory.getValue();
    }

    public void setCmpDirectory(String cmpDirectory) {
        this.cmpDirectory.setValue(cmpDirectory);
    }

    public void setParameterActive(String name, boolean isActive) {
        if (this.containsKey(name)) {
            ((Parameter)this.get(name)).setActive(isActive);
        }
    }

    public AutoconnectionParametersBean copy() {
        AutoconnectionParametersBean copy = new AutoconnectionParametersBean();
        for (Map.Entry entry : this.entrySet()) {
            Parameter p = (Parameter)entry.getValue();
            String name = (String)entry.getKey();
            if (!copy.containsKey(name)) continue;
            ((Parameter)copy.get(name)).setValue(p.getValue());
            ((Parameter)copy.get(name)).setActive(p.isActive());
        }
        copy.setStatus(this.myStatus);
        return copy;
    }

    public void resetParamsToActive() {
        for (Parameter p : this.values()) {
            if (p.isActive()) continue;
            p.setValue(EMPTY);
            p.setActive(true);
        }
    }

    public String createParamsUpdateRequestMessage() {
        StringBuilder s = new StringBuilder();
        s.append("<AutoconnTrsParamsUpdateRequest>");
        String managerType = (String)PoseidonRuntime.getRuntime().getRuntimeProperty("manageType");
        if ("FLCBTS".equals(managerType) || "TLCBTS".equals(managerType)) {
            s.append("<").append(AUTOCONN_IDENTISERVERIPADDRESS).append(">");
            s.append(this.identiServerIpAddress.isActive() ? this.getIdentiServerIpAddress() : EMPTY);
            s.append("</").append(AUTOCONN_IDENTISERVERIPADDRESS).append(">");
        } else {
            for (Map.Entry entry : this.entrySet()) {
                s.append("<").append((String)entry.getKey()).append(">");
                s.append(((Parameter)entry.getValue()).isActive() ? ((Parameter)entry.getValue()).getValue() : EMPTY);
                s.append("</").append((String)entry.getKey()).append(">");
            }
        }
        s.append("</AutoconnTrsParamsUpdateRequest>");
        return s.toString();
    }

    public static class Parameter {
        String myName = null;
        String myValue = null;
        boolean myIsActive = true;

        public String getName() {
            return this.myName;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public boolean isActive() {
            return this.myIsActive;
        }

        public void setActive(boolean active) {
            this.myIsActive = active;
        }

        public Parameter(String name) {
            this.myName = name;
            this.myValue = AutoconnectionParametersBean.EMPTY;
        }
    }

    public static enum Status {
        NOT_INITIALIZED,
        ACTIVE,
        INACTIVE;

    }
}

