/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ChangeAutoconfEnabledStateRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.ChangeAutoconfStateListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ChangeAutoconfEnabledStateScenario
implements Scenario {
    private Logger myLogger;
    private ChangeAutoconfStateListener.EnabledState myEnabledState;
    private BTSConnection myBTSConnection;
    private ChangeAutoconfStateListener myChangeAutoconfStateListener;
    private int mySeqNbr;
    private boolean myRunning;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public ChangeAutoconfEnabledStateScenario(BTSConnection connection, ChangeAutoconfStateListener listener, ChangeAutoconfStateListener.EnabledState enabledState) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myChangeAutoconfStateListener = listener;
        this.myEnabledState = enabledState;
    }

    public ChangeAutoconfEnabledStateScenario(BTSConnection connection, ChangeAutoconfStateListener listener, ChangeAutoconfStateListener.EnabledState enabledState, BTSMessage.Type type) {
        this(connection, listener, enabledState);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return ChangeAutoconfEnabledStateScenario.this.runScenario();
            }

            protected void finished() {
                ChangeAutoconfEnabledStateScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myChangeAutoconfStateListener.autoconfEnabledStateChangeFailed(85);
            return true;
        }
        this.mySeqNbr = this.myBTSConnection.createScenario();
        ChangeAutoconfEnabledStateRequest request = new ChangeAutoconfEnabledStateRequest(this.mySeqNbr, this.myEnabledState, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)request);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 60000L);
        this.myBTSConnection.deleteScenario(this.mySeqNbr);
        if (response instanceof Ack) {
            Ack ackResponse = (Ack)response;
            if (ackResponse.getAck()) {
                this.myLogger.debug((Object)"AutoConnection parameters updated.");
                this.myChangeAutoconfStateListener.autoconfEnabledStateChanged();
            } else {
                this.myLogger.debug((Object)"AutoConnection parameters update failed.");
                this.myChangeAutoconfStateListener.autoconfEnabledStateChangeFailed(ackResponse.getNackReason());
            }
        } else if (response instanceof Timeout) {
            this.myLogger.debug((Object)"AutoConnection parameters update timeout.");
            this.myChangeAutoconfStateListener.autoconfEnabledStateChangeFailed(68);
        } else if (response == null) {
            this.myLogger.error((Object)"Null message, aborted or connection lost.");
            this.myChangeAutoconfStateListener.autoconfEnabledStateChangeFailed(87);
        } else {
            this.myLogger.error((Object)"Invalid message from BTS.");
            this.myChangeAutoconfStateListener.autoconfEnabledStateChangeFailed(28);
        }
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

