/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ChangeDirectAccessStatusRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.DirectAccessStatusListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ChangeDirectAccessStatusScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private DirectAccessStatusListener myDirectAccessStatusListener;
    private boolean myRunning;
    private int mySeqNbr;
    private Logger myLogger;
    private boolean myEnableState;
    private boolean myAborted;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public ChangeDirectAccessStatusScenario(BTSConnection btsConnection, DirectAccessStatusListener directAccessStatusListener, boolean enableState) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = btsConnection;
        this.myDirectAccessStatusListener = directAccessStatusListener;
        this.myEnableState = enableState;
        this.myRunning = false;
    }

    public ChangeDirectAccessStatusScenario(BTSConnection btsConnection, DirectAccessStatusListener directAccessStatusListener, boolean enableState, BTSMessage.Type type) {
        this(btsConnection, directAccessStatusListener, enableState);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.myAborted = false;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    ChangeDirectAccessStatusScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    ChangeDirectAccessStatusScenario.this.myDirectAccessStatusListener.statusChangeFailed(85);
                    return null;
                }
                ChangeDirectAccessStatusScenario.this.mySeqNbr = ChangeDirectAccessStatusScenario.this.myBTSConnection.createScenario();
                ChangeDirectAccessStatusRequest request = new ChangeDirectAccessStatusRequest(ChangeDirectAccessStatusScenario.this.mySeqNbr, ChangeDirectAccessStatusScenario.this.myEnableState, ChangeDirectAccessStatusScenario.this.myType);
                ChangeDirectAccessStatusScenario.this.myBTSConnection.sendToBTS((BTSMessage)request);
                BTSMessage response = ChangeDirectAccessStatusScenario.this.myBTSConnection.receiveFromBTS(ChangeDirectAccessStatusScenario.this.mySeqNbr);
                if (response instanceof Ack) {
                    Ack ack = (Ack)response;
                    if (ack.getAck()) {
                        ChangeDirectAccessStatusScenario.this.myLogger.debug((Object)"Change successful.");
                        ChangeDirectAccessStatusScenario.this.myDirectAccessStatusListener.statusChanged();
                    } else {
                        int reason = ack.getNackReason();
                        ChangeDirectAccessStatusScenario.this.myLogger.debug((Object)("Change failed, " + reason));
                        ChangeDirectAccessStatusScenario.this.myDirectAccessStatusListener.statusChangeFailed(reason);
                    }
                } else if (response == null) {
                    if (ChangeDirectAccessStatusScenario.this.myAborted) {
                        ChangeDirectAccessStatusScenario.this.myLogger.debug((Object)"Aborted by user.");
                    } else {
                        ChangeDirectAccessStatusScenario.this.myLogger.debug((Object)"Null message, connection lost.");
                        ChangeDirectAccessStatusScenario.this.myDirectAccessStatusListener.statusChangeFailed(87);
                    }
                } else {
                    ChangeDirectAccessStatusScenario.this.myLogger.error((Object)"Invalid message from BTS.");
                    ChangeDirectAccessStatusScenario.this.myDirectAccessStatusListener.statusChangeFailed(28);
                }
                return null;
            }

            protected void finished() {
                ChangeDirectAccessStatusScenario.this.myBTSConnection.deleteScenario(ChangeDirectAccessStatusScenario.this.mySeqNbr);
                ChangeDirectAccessStatusScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myAborted = true;
            this.myBTSConnection.interruptScenario(this.mySeqNbr);
        }
        return true;
    }
}

