/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ChangeEthernetSecurityStatusRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.EthernetSecurityStatusListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ChangeEthernetSecurityStatusScenario
implements Scenario {
    private static final int TIMEOUT = 120000;
    private BTSConnection myBTSConnection;
    private EthernetSecurityStatusListener myEthernetSecurityStatusListener;
    private boolean myRunning;
    private int mySeqNbr;
    private Logger myLogger;
    private boolean myEnableState;
    private boolean myAborted;
    private String myUnitId;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public ChangeEthernetSecurityStatusScenario(BTSConnection btsConnection, EthernetSecurityStatusListener ethernetSecurityStatusListener, boolean enableState, String unitId) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = btsConnection;
        this.myEthernetSecurityStatusListener = ethernetSecurityStatusListener;
        this.myEnableState = enableState;
        this.myUnitId = unitId;
        this.myRunning = false;
    }

    public ChangeEthernetSecurityStatusScenario(BTSConnection btsConnection, EthernetSecurityStatusListener ethernetSecurityStatusListener, boolean enableState, String unitId, BTSMessage.Type type) {
        this(btsConnection, ethernetSecurityStatusListener, enableState, unitId);
        this.myType = type;
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myAborted = true;
            this.myBTSConnection.interruptScenario(this.mySeqNbr);
        }
        return true;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.myAborted = false;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    ChangeEthernetSecurityStatusScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    ChangeEthernetSecurityStatusScenario.this.myEthernetSecurityStatusListener.statusChangeFailed(85);
                    return null;
                }
                ChangeEthernetSecurityStatusScenario.this.mySeqNbr = ChangeEthernetSecurityStatusScenario.this.myBTSConnection.createScenario();
                ChangeEthernetSecurityStatusRequest request = new ChangeEthernetSecurityStatusRequest(ChangeEthernetSecurityStatusScenario.this.mySeqNbr, ChangeEthernetSecurityStatusScenario.this.myEnableState, ChangeEthernetSecurityStatusScenario.this.myUnitId, ChangeEthernetSecurityStatusScenario.this.myType);
                ChangeEthernetSecurityStatusScenario.this.myBTSConnection.sendToBTS((BTSMessage)request);
                BTSMessage response = ChangeEthernetSecurityStatusScenario.this.myBTSConnection.receiveFromBTS(ChangeEthernetSecurityStatusScenario.this.mySeqNbr, 120000L);
                if (response instanceof Ack) {
                    Ack ack = (Ack)response;
                    if (ack.getAck()) {
                        ChangeEthernetSecurityStatusScenario.this.myLogger.debug((Object)"Change successful.");
                        ChangeEthernetSecurityStatusScenario.this.myEthernetSecurityStatusListener.statusChanged();
                    } else {
                        int reason = ack.getNackReason();
                        ChangeEthernetSecurityStatusScenario.this.myLogger.debug((Object)("Change failed, " + reason));
                        ChangeEthernetSecurityStatusScenario.this.myEthernetSecurityStatusListener.statusChangeFailed(reason);
                    }
                } else if (response instanceof Timeout) {
                    ChangeEthernetSecurityStatusScenario.this.myLogger.error((Object)"BTS dose not response message.");
                    ChangeEthernetSecurityStatusScenario.this.myEthernetSecurityStatusListener.statusChangeFailed(68);
                } else if (response == null) {
                    if (ChangeEthernetSecurityStatusScenario.this.myAborted) {
                        ChangeEthernetSecurityStatusScenario.this.myLogger.debug((Object)"Aborted by user.");
                    } else {
                        ChangeEthernetSecurityStatusScenario.this.myLogger.debug((Object)"Null message, connection lost.");
                        ChangeEthernetSecurityStatusScenario.this.myEthernetSecurityStatusListener.statusChangeFailed(87);
                    }
                } else {
                    ChangeEthernetSecurityStatusScenario.this.myLogger.error((Object)"Invalid message from BTS.");
                    ChangeEthernetSecurityStatusScenario.this.myEthernetSecurityStatusListener.statusChangeFailed(28);
                }
                return null;
            }

            protected void finished() {
                ChangeEthernetSecurityStatusScenario.this.myBTSConnection.deleteScenario(ChangeEthernetSecurityStatusScenario.this.mySeqNbr);
                ChangeEthernetSecurityStatusScenario.this.myRunning = false;
            }
        };
        worker.start();
    }
}

