/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ChangeModeRequest;
import com.nokia.em.bts.coreasset.message.ChangeModeResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.ChangeModeListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ChangeModeScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private ChangeModeListener myChangeModeListener;
    private boolean myRunning;
    private int mySeqNbr;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public ChangeModeScenario(BTSConnection btsConnection, ChangeModeListener changeModeListener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = btsConnection;
        this.myChangeModeListener = changeModeListener;
        this.myRunning = false;
    }

    public ChangeModeScenario(BTSConnection btsConnection, ChangeModeListener changeModeListener, BTSMessage.Type type) {
        this(btsConnection, changeModeListener);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    ChangeModeScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    ChangeModeScenario.this.myChangeModeListener.changeFailed(85);
                    return true;
                }
                ChangeModeScenario.this.mySeqNbr = ChangeModeScenario.this.myBTSConnection.createScenario();
                ChangeModeRequest request = new ChangeModeRequest(ChangeModeScenario.this.mySeqNbr, ChangeModeScenario.this.myType);
                ChangeModeScenario.this.myBTSConnection.sendToBTS((BTSMessage)request);
                BTSMessage response = ChangeModeScenario.this.myBTSConnection.receiveFromBTS(ChangeModeScenario.this.mySeqNbr);
                if (response instanceof ChangeModeResponse) {
                    ChangeModeResponse changeModeResponse = (ChangeModeResponse)response;
                    int result = changeModeResponse.getResult();
                    if (result == 36) {
                        ChangeModeScenario.this.myLogger.debug((Object)"Change successful.");
                        ChangeModeScenario.this.myChangeModeListener.changeSuccessful();
                    } else {
                        ChangeModeScenario.this.myLogger.debug((Object)"Change failed.");
                        ChangeModeScenario.this.myChangeModeListener.changeFailed(result);
                    }
                } else if (response == null) {
                    ChangeModeScenario.this.myLogger.error((Object)"Null message, aborted or connection lost.");
                    ChangeModeScenario.this.myChangeModeListener.changeFailed(62);
                } else {
                    ChangeModeScenario.this.myLogger.error((Object)"Invalid message from BTS.");
                    ChangeModeScenario.this.myChangeModeListener.changeFailed(28);
                }
                return true;
            }

            protected void finished() {
                ChangeModeScenario.this.myBTSConnection.deleteScenario(ChangeModeScenario.this.mySeqNbr);
                ChangeModeScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        this.myBTSConnection.interruptScenario(this.mySeqNbr);
        return true;
    }
}

