/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.ClearAutoconnParamsRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.ClearAutoconnParamsListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class ClearAutoconnParamsScenario
implements Scenario {
    private Logger myLogger;
    private boolean myIsSiteIDSelected;
    private boolean myIsSecuCreSelected;
    private boolean myIsACNonOpBackhaulParamsSelected;
    private BTSConnection myBTSConnection;
    private ClearAutoconnParamsListener myListener;
    private int mySeqNbr;
    private boolean myRunning;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public ClearAutoconnParamsScenario(BTSConnection connection, ClearAutoconnParamsListener listener) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myListener = listener;
    }

    public ClearAutoconnParamsScenario(BTSConnection connection, ClearAutoconnParamsListener listener, BTSMessage.Type type) {
        this(connection, listener);
        this.myType = type;
    }

    public ClearAutoconnParamsScenario(BTSConnection connection, ClearAutoconnParamsListener listener, BTSMessage.Type type, boolean isSiteIDSelected, boolean isSecuCreSelected, boolean isACNonOpBackhaulParamsSelected) {
        this(connection, listener, type);
        this.myIsSiteIDSelected = isSiteIDSelected;
        this.myIsSecuCreSelected = isSecuCreSelected;
        this.myIsACNonOpBackhaulParamsSelected = isACNonOpBackhaulParamsSelected;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return ClearAutoconnParamsScenario.this.runScenario();
            }

            protected void finished() {
                ClearAutoconnParamsScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        return true;
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            return true;
        }
        this.mySeqNbr = this.myBTSConnection.createScenario();
        ClearAutoconnParamsRequest requesst = new ClearAutoconnParamsRequest(this.mySeqNbr, this.myType, this.myIsSiteIDSelected, this.myIsSecuCreSelected, this.myIsACNonOpBackhaulParamsSelected);
        this.myBTSConnection.sendToBTS((BTSMessage)requesst);
        this.myListener.autoconnParamsClearStarted();
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNbr, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                this.myListener.autoconnParamsClearFailed(ack.getNackReason());
            } else {
                this.myListener.autoconnParamsClearSuccess();
            }
        } else if (response instanceof Timeout) {
            this.myListener.autoconnParamsClearFailed(68);
        } else if (response != null) {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
            this.myListener.autoconnParamsClearFailed(28);
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected. response is null or thread terminated");
        }
        this.myRunning = false;
        this.myBTSConnection.deleteScenario(this.mySeqNbr);
        return true;
    }
}

