/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.DownloadCertificatesListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.RAMLRequest;
import com.nokia.em.bts.rp.master.message.RAMLResponse;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class DownloadCertificatesScenario
implements Scenario {
    private Logger myLogger;
    private BTSConnection myConnection;
    private DownloadCertificatesListener myListener;
    private String ramlMessage;
    private boolean myRunning = false;
    private int mySeqNumber;
    private BTSMessage.Type myType = BTSMessage.Type.TRS;

    public DownloadCertificatesScenario(BTSConnection connection, DownloadCertificatesListener listener, String ramlRequest) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myConnection = connection;
        this.myListener = listener;
        this.ramlMessage = ramlRequest;
    }

    public DownloadCertificatesScenario(BTSConnection connection, DownloadCertificatesListener listener, String ramlRequest, BTSMessage.Type type) {
        this(connection, listener, ramlRequest);
        this.myType = type;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return DownloadCertificatesScenario.this.runScenario();
            }

            protected void finished() {
                DownloadCertificatesScenario.this.myConnection.deleteScenario(DownloadCertificatesScenario.this.mySeqNumber);
                DownloadCertificatesScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myListener.downloadFailed(85);
            return true;
        }
        this.mySeqNumber = this.myConnection.createScenario();
        RAMLRequest downloadCerticatesRequest = new RAMLRequest(this.mySeqNumber, this.ramlMessage, BTSMessage.Type.TRS);
        this.myConnection.sendToBTS((BTSMessage)downloadCerticatesRequest);
        boolean finished = false;
        do {
            BTSMessage response;
            if ((response = this.myConnection.receiveFromBTS(this.mySeqNumber, 60000L)) instanceof RAMLResponse) {
                RAMLResponse ramlResponse = (RAMLResponse)response;
                finished = ramlResponse.isLastMessage();
                this.myLogger.debug((Object)"Raml response received.");
                this.myListener.downloadSuccessfull(ramlResponse);
                continue;
            }
            if (response instanceof Timeout) {
                this.myLogger.debug((Object)"Download certificates scenario timeout");
                this.myListener.downloadFailed(68);
                finished = true;
                continue;
            }
            this.myLogger.debug((Object)"Wrong message reveived in download certificates scenario");
            this.myListener.downloadFailed(28);
            finished = true;
        } while (!finished);
        return true;
    }

    @Override
    public boolean abort() {
        this.myLogger.debug((Object)"trying to abort download certificates scenario");
        if (this.myConnection != null) {
            this.myLogger.debug((Object)"Trying to interrupt message receiving...");
            this.myConnection.interruptScenario(this.mySeqNumber);
        }
        this.myRunning = false;
        this.myLogger.debug((Object)"download certicates scenario aborted successfully");
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

