/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.EACInputEnableChangeReply;
import com.nokia.em.bts.coreasset.message.EACInputEnableChangeRequest;
import com.nokia.em.bts.coreasset.message.EACOutputStateChangeReply;
import com.nokia.em.bts.coreasset.message.EACOutputStateChangeRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.EACStateChangeListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class EACStateChangeScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private EACStateChangeListener myEACStateChangeListener;
    private boolean myRunning;
    private EACStateChangeListener.EAC_TYPE myEacType;
    private EACStateChangeListener.EAC_STATE myEacState;
    private int myEacId;
    private int myUnitId;
    private boolean myAborted;
    private int mySeqNbr;
    private Logger myLogger;
    private static final int TIMEOUT = 60000;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public EACStateChangeScenario(BTSConnection btsConnection, EACStateChangeListener eacStateListener, EACStateChangeListener.EAC_TYPE eacType, int eacId, int unitId, EACStateChangeListener.EAC_STATE eacState) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = btsConnection;
        this.myEACStateChangeListener = eacStateListener;
        this.myEacType = eacType;
        this.myEacId = eacId;
        this.myUnitId = unitId;
        this.myEacState = eacState;
        this.myRunning = false;
    }

    public EACStateChangeScenario(BTSConnection btsConnection, EACStateChangeListener eacStateListener, EACStateChangeListener.EAC_TYPE eacType, int eacId, int unitId, EACStateChangeListener.EAC_STATE eacState, BTSMessage.Type type) {
        this(btsConnection, eacStateListener, eacType, eacId, unitId, eacState);
        this.myType = type;
    }

    private BTSMessage getRequestMessage() {
        this.mySeqNbr = this.myBTSConnection.createScenario();
        if (this.myEacType == EACStateChangeListener.EAC_TYPE.INPUT) {
            if (this.myEacState == EACStateChangeListener.EAC_STATE.ON_ENABLE) {
                return new EACInputEnableChangeRequest(this.mySeqNbr, this.myEacId, 48, this.myUnitId, this.myType);
            }
            return new EACInputEnableChangeRequest(this.mySeqNbr, this.myEacId, 49, this.myUnitId, this.myType);
        }
        if (this.myEacState == EACStateChangeListener.EAC_STATE.ON_ENABLE) {
            return new EACOutputStateChangeRequest(this.mySeqNbr, this.myEacId, 44, this.myUnitId, this.myType);
        }
        return new EACOutputStateChangeRequest(this.mySeqNbr, this.myEacId, 45, this.myUnitId, this.myType);
    }

    private void processSuccessCode(int successCode) {
        switch (successCode) {
            case -1: {
                this.myEACStateChangeListener.stateRequestFailed(28);
                break;
            }
            case 34: {
                this.myEACStateChangeListener.stateRequested();
                break;
            }
            default: {
                this.myEACStateChangeListener.stateRequestFailed(successCode);
            }
        }
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        this.myAborted = false;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                if (CoreAsset.isSnapshotOpening()) {
                    EACStateChangeScenario.this.myLogger.debug((Object)"Snapshot open not supported.");
                    EACStateChangeScenario.this.myEACStateChangeListener.stateRequestFailed(85);
                    return null;
                }
                BTSMessage request = EACStateChangeScenario.this.getRequestMessage();
                EACStateChangeScenario.this.myBTSConnection.sendToBTS(request);
                BTSMessage response = EACStateChangeScenario.this.myBTSConnection.receiveFromBTS(EACStateChangeScenario.this.mySeqNbr, 60000L);
                if (response instanceof EACOutputStateChangeReply) {
                    EACStateChangeScenario.this.processSuccessCode(((EACOutputStateChangeReply)response).getSuccessCode());
                } else if (response instanceof EACInputEnableChangeReply) {
                    EACStateChangeScenario.this.processSuccessCode(((EACInputEnableChangeReply)response).getSuccessCode());
                } else if (response instanceof Timeout) {
                    EACStateChangeScenario.this.myEACStateChangeListener.stateRequestFailed(68);
                } else if (EACStateChangeScenario.this.myAborted) {
                    EACStateChangeScenario.this.myEACStateChangeListener.stateRequestFailed(62);
                } else {
                    EACStateChangeScenario.this.myEACStateChangeListener.stateRequestFailed(28);
                }
                return null;
            }

            protected void finished() {
                EACStateChangeScenario.this.myBTSConnection.deleteScenario(EACStateChangeScenario.this.mySeqNbr);
                EACStateChangeScenario.this.myRunning = false;
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myAborted = true;
            this.myBTSConnection.interruptScenario(this.mySeqNbr);
        }
        return true;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

