/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.CoreAsset;
import com.nokia.em.bts.coreasset.message.StartInputVoltageMonitoringRequest;
import com.nokia.em.bts.coreasset.message.StopInputVoltageMonitoringRequest;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.InputVoltageListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class InputVoltageMonitoringScenario
implements Scenario {
    private BTSConnection myBTSConnection;
    private InputVoltageListener myListener;
    private int mySeqNumber;
    private boolean myRunning;
    private int myId;
    private Logger myLogger;
    private BTSMessage.Type myType = BTSMessage.Type.BTS;

    public InputVoltageMonitoringScenario(BTSConnection connection, InputVoltageListener listener, int id) {
        this.init(connection, listener, id);
    }

    public InputVoltageMonitoringScenario(BTSConnection connection, InputVoltageListener listener, int id, BTSMessage.Type type) {
        this(connection, listener, id);
        this.myType = type;
    }

    private void init(BTSConnection connection, InputVoltageListener listener, int id) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBTSConnection = connection;
        this.myListener = listener;
        this.myId = id;
        this.myRunning = false;
    }

    @Override
    public void execute() {
        if (this.myRunning) {
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.myRunning = true;
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return InputVoltageMonitoringScenario.this.runScenario();
            }
        };
        worker.start();
    }

    @Override
    public boolean abort() {
        CoreAssetThread worker = new CoreAssetThread(){

            protected Object construct() {
                return InputVoltageMonitoringScenario.this.stopScenario();
            }
        };
        worker.start();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object stopScenario() {
        StopInputVoltageMonitoringRequest stopRequest = new StopInputVoltageMonitoringRequest(this.mySeqNumber, this.myId, this.myType);
        this.myBTSConnection.sendToBTS((BTSMessage)stopRequest);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Ack) {
            Ack stopAck = (Ack)response;
            if (!stopAck.getAck()) {
                this.myListener.monitoringStopFailed(this.myId, stopAck.getNackReason());
                return false;
            }
            this.myListener.monitoringStopped(this.myId);
            this.myBTSConnection.deleteScenario(this.mySeqNumber);
            this.myRunning = false;
            return true;
        }
        if (response instanceof Timeout) {
            this.myListener.monitoringStopFailed(this.myId, 68);
            return false;
        }
        this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
        this.myListener.monitoringStopFailed(this.myId, 28);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object runScenario() {
        if (CoreAsset.isSnapshotOpening()) {
            this.myLogger.debug((Object)"Snapshot open not supported.");
            this.myListener.monitoringStartFailed(this.myId, 85);
            return true;
        }
        this.mySeqNumber = this.myBTSConnection.createScenario();
        StartInputVoltageMonitoringRequest startRequest = new StartInputVoltageMonitoringRequest(this.mySeqNumber, this.myId);
        this.myBTSConnection.sendToBTS((BTSMessage)startRequest);
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 60000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (ack.getAck()) {
                this.myListener.monitoringStarted(this.myId);
                return true;
            }
            this.myListener.monitoringStartFailed(this.myId, ack.getNackReason());
        } else if (response instanceof Timeout) {
            this.myListener.monitoringStartFailed(this.myId, 68);
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
            this.myListener.monitoringStartFailed(this.myId, 28);
        }
        this.myRunning = false;
        this.myBTSConnection.deleteScenario(this.mySeqNumber);
        return false;
    }

    public BTSMessage.Type getType() {
        return this.myType;
    }

    public void setType(BTSMessage.Type type) {
        this.myType = type;
    }
}

