/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.scenario.hwmanagement;

import com.nokia.em.bts.coreasset.message.MultipleCoreAvailabilityRequest;
import com.nokia.em.bts.coreasset.message.MultipleCoreAvailabilityResponse;
import com.nokia.em.bts.coreasset.scenario.Scenario;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.MultipleCoreAvailabilityCheckListener;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.MultipleCoreState;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.Ack;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.CoreAssetThread;
import org.apache.log4j.Logger;

public class MultipleCoreAvailabilityCheckScenario
implements Scenario,
BTSNotificationListener {
    private BTSConnection myBTSConnection;
    private MultipleCoreAvailabilityCheckListener myListener;
    private static final int MULTIPLECOREAVAILABILITY_MESSAGE_TIMEOUT = 30000;
    private int mySeqNumber;
    private boolean myRunning;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public MultipleCoreAvailabilityCheckScenario(BTSConnection connection, MultipleCoreAvailabilityCheckListener listener) {
        this.myBTSConnection = connection;
        this.myListener = listener;
    }

    @Override
    public void execute() {
        if (this.isRunning()) {
            this.myLogger.debug((Object)"Illegal state.");
            throw new IllegalStateException("Cannot execute Scenario. Scenario already in process.");
        }
        this.setIsRunning(true);
        CoreAssetThread fileTransferWorker = new CoreAssetThread(){

            protected Object construct() {
                return MultipleCoreAvailabilityCheckScenario.this.runScenario();
            }
        };
        fileTransferWorker.start();
    }

    @Override
    public boolean abort() {
        if (this.myRunning) {
            this.myBTSConnection.interruptScenario(this.mySeqNumber);
        }
        return true;
    }

    private boolean runScenario() {
        this.mySeqNumber = this.myBTSConnection.createScenario();
        MultipleCoreAvailabilityRequest multipleCoreAvailabilityRequest = new MultipleCoreAvailabilityRequest(this.mySeqNumber);
        this.myBTSConnection.sendToBTS((BTSMessage)multipleCoreAvailabilityRequest);
        this.myListener.multipleCoreRequestSent();
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber, 30000L);
        if (response instanceof Ack) {
            Ack ack = (Ack)response;
            if (!ack.getAck()) {
                this.myListener.multipleCoreRequestRejectted();
            } else {
                this.multipleCoreRequestAcceptted();
            }
        } else if (response instanceof Timeout) {
            this.myListener.multipleCoreAvailabilityCheckFailed(MultipleCoreAvailabilityCheckListener.FailedReason.TIMEOUT);
        } else if (response == null) {
            this.myLogger.error((Object)"Wrong reply received from BTS. PowerOperationCompleted expected.");
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. Ack expected.");
            this.myListener.multipleCoreAvailabilityCheckFailed(MultipleCoreAvailabilityCheckListener.FailedReason.UNKNOWN);
        }
        this.myRunning = false;
        this.myBTSConnection.deleteScenario(this.mySeqNumber);
        return false;
    }

    private void multipleCoreRequestAcceptted() {
        this.myListener.multipleCoreRequestAccept();
        BTSMessage response = this.myBTSConnection.receiveFromBTS(this.mySeqNumber);
        if (response instanceof MultipleCoreAvailabilityResponse) {
            MultipleCoreAvailabilityResponse multipleCoreAvailabilityResponse = (MultipleCoreAvailabilityResponse)response;
            String coreState = multipleCoreAvailabilityResponse.getCoreState();
            if (coreState.equals(MultipleCoreState.Available.toString())) {
                this.myListener.multipleCoreAvailabilityResponseRecived(MultipleCoreState.Available);
            } else if (coreState.equals(MultipleCoreState.AlreadyInModel.toString())) {
                this.myListener.multipleCoreAvailabilityResponseRecived(MultipleCoreState.AlreadyInModel);
            } else if (coreState.equals(MultipleCoreState.NotAvailable.toString())) {
                this.myListener.multipleCoreAvailabilityResponseRecived(MultipleCoreState.NotAvailable);
            }
        } else if (response instanceof Timeout) {
            this.myListener.multipleCoreAvailabilityCheckFailed(MultipleCoreAvailabilityCheckListener.FailedReason.TIMEOUT);
        } else if (response == null) {
            this.myLogger.error((Object)"Wrong reply received from BTS. MultipleCoreAvailabilityResponse expected.");
        } else {
            this.myLogger.error((Object)"Wrong reply received from BTS. MultipleCoreAvailabilityResponse expected.");
            this.myListener.multipleCoreAvailabilityCheckFailed(MultipleCoreAvailabilityCheckListener.FailedReason.UNKNOWN);
        }
    }

    private void setIsRunning(boolean value) {
        this.myRunning = value;
    }

    protected boolean isRunning() {
        return this.myRunning;
    }

    public void btsNotificationReceived(BTSMessage btsMessage) {
    }
}

